/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.resources;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import org.nhindirect.config.model.DNSRecord;
import org.nhindirect.config.repository.DNSRepository;
import org.nhindirect.config.resources.ProtectedResource;
import org.nhindirect.config.resources.util.EntityModelConversion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"dns"})
public class DNSResource
extends ProtectedResource {
    private static final Logger log = LoggerFactory.getLogger(DNSResource.class);
    protected DNSRepository dnsRepo;

    @Autowired
    public void setDNSRepository(DNSRepository dnsRepo) {
        this.dnsRepo = dnsRepo;
    }

    @GetMapping(produces={"application/json"})
    public Flux<DNSRecord> getDNSRecords(@RequestParam(name="type", defaultValue="-1") int type, @RequestParam(name="name", defaultValue="") String name) {
        Flux retRecords;
        if (type > -1 && !name.isEmpty()) {
            retRecords = type == 255 ? this.dnsRepo.findByNameIgnoreCase(name.endsWith(".") ? name : name + ".") : this.dnsRepo.findByNameIgnoreCaseAndType(name.endsWith(".") ? name : name + ".", type);
        } else if (type > -1) {
            retRecords = type == 255 ? this.dnsRepo.findAll() : this.dnsRepo.findByType(type);
        } else if (!name.isEmpty()) {
            retRecords = this.dnsRepo.findByNameIgnoreCase(name.endsWith(".") ? name : name + ".");
        } else {
            log.error("Either a DNS query name or type (or both) must be specified.");
            return Flux.error((Throwable)new ResponseStatusException(HttpStatus.BAD_REQUEST));
        }
        return retRecords.map(record -> EntityModelConversion.toModelDNSRecord(record)).onErrorResume(e -> {
            log.error("Error looking up DNS records.", e);
            return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
        });
    }

    @PutMapping(consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public Mono<Void> addDNSRecord(@RequestBody DNSRecord record) {
        if (record.getType() == 255) {
            log.error("Cannot add record with type ANY");
            return Mono.error((Throwable)new ResponseStatusException(HttpStatus.BAD_REQUEST));
        }
        if (!record.getName().endsWith(".")) {
            record.setName(record.getName() + ".");
        }
        return this.dnsRepo.findByNameIgnoreCaseAndType(record.getName(), record.getType()).filter(compareRecord -> Arrays.equals(record.getData(), compareRecord.getData())).collectList().switchIfEmpty(Mono.just(Collections.emptyList())).flatMap(records -> {
            if (!records.isEmpty()) {
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.CONFLICT));
            }
            org.nhindirect.config.store.DNSRecord addRec = EntityModelConversion.toEntityDNSRecord(record);
            addRec.setId(null);
            addRec.setCreateTime(LocalDateTime.now());
            return this.dnsRepo.save((Object)addRec).then().onErrorResume(e -> {
                log.error("Error adding DNS record.", e);
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
            });
        });
    }

    @PostMapping(consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public Mono<Void> updateDNSRecord(@RequestBody DNSRecord updateRecord) {
        return this.dnsRepo.findById((Object)updateRecord.getId()).switchIfEmpty(Mono.just((Object)new org.nhindirect.config.store.DNSRecord())).flatMap(record -> {
            if (record.getName() == null) {
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.NOT_FOUND));
            }
            if (!updateRecord.getName().endsWith(".")) {
                updateRecord.setName(updateRecord.getName() + ".");
            }
            return this.dnsRepo.save((Object)EntityModelConversion.toEntityDNSRecord(updateRecord)).then().onErrorResume(e -> {
                log.error("Error updating DNS record.", e);
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
            });
        });
    }

    @DeleteMapping(value={"{ids}"})
    public Mono<Void> removeDNSRecordsByIds(@PathVariable(value="ids") String ids) {
        String[] idArray = ids.split(",");
        return Flux.fromStream(Arrays.stream(idArray)).flatMap(id -> this.dnsRepo.deleteById((Object)Long.parseLong(id))).collectList().flatMap(deletes -> Mono.empty());
    }
}

