/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nhindirect.config.store.Certificate;
import org.nhindirect.config.store.dao.CertificateDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"file:src/test/resources/configStore-test.xml"})
@TransactionConfiguration(transactionManager="transactionManager", defaultRollback=true)
@Transactional
public class CertificateDaoTest {
    private static final String derbyHomeLoc = "/target/data";
    private static final String certBasePath = "src/test/resources/certs/";
    private static final String TEST_DOMAIN = "TestDomain1";
    @Autowired
    private CertificateDao certificateDao;

    private static byte[] loadCertificateData(String certFileName) throws Exception {
        File fl = new File(certBasePath + certFileName);
        return FileUtils.readFileToByteArray((File)fl);
    }

    private static byte[] loadPkcs12FromCertAndKey(String certFileName, String keyFileName) throws Exception {
        byte[] retVal = null;
        try {
            KeyStore localKeyStore = KeyStore.getInstance("PKCS12", Certificate.getJCEProviderName());
            localKeyStore.load(null, null);
            byte[] certData = CertificateDaoTest.loadCertificateData(certFileName);
            byte[] keyData = CertificateDaoTest.loadCertificateData(keyFileName);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream inStr = new ByteArrayInputStream(certData);
            java.security.cert.Certificate cert = cf.generateCertificate(inStr);
            ((InputStream)inStr).close();
            KeyFactory kf = KeyFactory.getInstance("RSA");
            PKCS8EncodedKeySpec keysp = new PKCS8EncodedKeySpec(keyData);
            PrivateKey privKey = kf.generatePrivate(keysp);
            char[] array = "".toCharArray();
            localKeyStore.setKeyEntry("privCert", privKey, array, new java.security.cert.Certificate[]{cert});
            ByteArrayOutputStream outStr = new ByteArrayOutputStream();
            localKeyStore.store(outStr, array);
            retVal = outStr.toByteArray();
            outStr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retVal;
    }

    @Test
    public void testCleanDatabase() throws Exception {
        List certificates = this.certificateDao.list((String)null);
        if (certificates != null && certificates.size() > 0) {
            for (Certificate cert : certificates) {
                this.certificateDao.delete(cert.getOwner());
            }
        }
        certificates = this.certificateDao.list((String)null);
        Assert.assertEquals((long)0L, (long)certificates.size());
    }

    @Test
    public void testAddPublicCert() throws Exception {
        this.testCleanDatabase();
        byte[] certData = CertificateDaoTest.loadCertificateData("gm2552.der");
        Certificate cert = new Certificate();
        cert.setData(certData);
        cert.setOwner("gm2552@cerner.com");
        this.certificateDao.save(cert);
        List certificates = this.certificateDao.list((String)null);
        Assert.assertEquals((long)1L, (long)certificates.size());
    }

    @Test
    public void testAddPrivateCert() throws Exception {
        this.testCleanDatabase();
        byte[] certData = CertificateDaoTest.loadPkcs12FromCertAndKey("gm2552.der", "gm2552Key.der");
        Certificate cert = new Certificate();
        cert.setData(certData);
        cert.setOwner("gm2552@cerner.com");
        this.certificateDao.save(cert);
        List certificates = this.certificateDao.list((String)null);
        Assert.assertEquals((long)1L, (long)certificates.size());
    }

    @Test
    public void testGetByOwner() throws Exception {
        this.testCleanDatabase();
        byte[] certData = CertificateDaoTest.loadPkcs12FromCertAndKey("gm2552.der", "gm2552Key.der");
        Certificate cert = new Certificate();
        cert.setData(certData);
        cert.setOwner("gm2552@cerner.com");
        this.certificateDao.save(cert);
        List certificates = this.certificateDao.list("gm2552@cerner.com");
        Assert.assertEquals((long)1L, (long)certificates.size());
        cert = (Certificate)certificates.iterator().next();
        Assert.assertEquals((Object)"gm2552@cerner.com", (Object)cert.getOwner());
        this.testCleanDatabase();
        certData = CertificateDaoTest.loadCertificateData("gm2552.der");
        cert = new Certificate();
        cert.setData(certData);
        cert.setOwner("gm2552@cerner.com");
        this.certificateDao.save(cert);
        certificates = this.certificateDao.list("gm2552@cerner.com");
        Assert.assertEquals((long)1L, (long)certificates.size());
        cert = (Certificate)certificates.iterator().next();
        Assert.assertEquals((Object)"gm2552@cerner.com", (Object)cert.getOwner());
    }

    @Test
    public void testGetById() throws Exception {
        this.testCleanDatabase();
        byte[] certData = CertificateDaoTest.loadPkcs12FromCertAndKey("gm2552.der", "gm2552Key.der");
        Certificate cert = new Certificate();
        cert.setData(certData);
        cert.setOwner("gm2552@cerner.com");
        this.certificateDao.save(cert);
        List certificates = this.certificateDao.list("gm2552@cerner.com");
        Assert.assertEquals((long)1L, (long)certificates.size());
        cert = (Certificate)certificates.iterator().next();
        certificates = this.certificateDao.list(Arrays.asList(cert.getId()));
        Assert.assertEquals((long)1L, (long)certificates.size());
        cert = (Certificate)certificates.iterator().next();
        Assert.assertEquals((Object)"gm2552@cerner.com", (Object)cert.getOwner());
    }

    @Test
    public void testDeleteByOwner() throws Exception {
        this.testCleanDatabase();
        byte[] certData = CertificateDaoTest.loadPkcs12FromCertAndKey("gm2552.der", "gm2552Key.der");
        Certificate cert = new Certificate();
        cert.setData(certData);
        cert.setOwner("gm2552@cerner.com");
        this.certificateDao.save(cert);
        List certificates = this.certificateDao.list("gm2552@cerner.com");
        Assert.assertEquals((long)1L, (long)certificates.size());
        cert = (Certificate)certificates.iterator().next();
        Assert.assertEquals((Object)"gm2552@cerner.com", (Object)cert.getOwner());
        this.certificateDao.delete("gm2552@cerner.com");
        certificates = this.certificateDao.list("gm2552@cerner.com");
        Assert.assertEquals((long)0L, (long)certificates.size());
    }

    @Test
    public void testDeleteById() throws Exception {
        this.testCleanDatabase();
        byte[] certData = CertificateDaoTest.loadPkcs12FromCertAndKey("gm2552.der", "gm2552Key.der");
        Certificate cert = new Certificate();
        cert.setData(certData);
        cert.setOwner("gm2552@cerner.com");
        this.certificateDao.save(cert);
        List certificates = this.certificateDao.list("gm2552@cerner.com");
        Assert.assertEquals((long)1L, (long)certificates.size());
        cert = (Certificate)certificates.iterator().next();
        Assert.assertEquals((Object)"gm2552@cerner.com", (Object)cert.getOwner());
        this.certificateDao.delete(Arrays.asList(cert.getId()));
        certificates = this.certificateDao.list("gm2552@cerner.com");
        Assert.assertEquals((long)0L, (long)certificates.size());
    }

    static {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            File baseLocation = new File("dummy.txt");
            String fullDerbyHome = baseLocation.getAbsolutePath().substring(0, baseLocation.getAbsolutePath().lastIndexOf(File.separator)) + derbyHomeLoc;
            System.setProperty("derby.system.home", fullDerbyHome);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

