/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nhindirect.config.store.ConfigurationStoreException;
import org.nhindirect.config.store.Setting;
import org.nhindirect.config.store.dao.SettingDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"file:src/test/resources/configStore-test.xml"})
@TransactionConfiguration(transactionManager="transactionManager", defaultRollback=true)
@Transactional
public class SettingDaoTest {
    private static final String derbyHomeLoc = "/target/data";
    @Autowired
    private SettingDao settingDao;

    private void addSetting(String name, String value) throws Exception {
        this.settingDao.add(name, value);
    }

    @Test
    public void testCleanDatabase() throws Exception {
        Collection settings = this.settingDao.getAll();
        ArrayList<String> toDelete = new ArrayList<String>();
        if (settings != null && settings.size() > 0) {
            for (Setting setting : settings) {
                toDelete.add(setting.getName());
            }
            this.settingDao.delete(toDelete);
        }
        settings = this.settingDao.getAll();
        Assert.assertEquals((long)0L, (long)settings.size());
    }

    @Test
    public void addSettings() throws Exception {
        this.testCleanDatabase();
        this.addSetting("TestName1", "TestValue1");
        this.addSetting("TestName2", "TestValue2");
        Collection settings = this.settingDao.getAll();
        Assert.assertEquals((long)2L, (long)settings.size());
    }

    @Test
    public void testAddDuplicateSettings_AssertException() throws Exception {
        this.testCleanDatabase();
        this.addSetting("TestName1", "TestValue1");
        boolean exceptionOccured = false;
        try {
            this.addSetting("TestName1", "TestValue2");
        }
        catch (ConfigurationStoreException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testGetAllSettings() throws Exception {
        this.testCleanDatabase();
        this.addSetting("TestName1", "TestValue1");
        this.addSetting("TestName2", "TestValue2");
        Collection settings = this.settingDao.getAll();
        Assert.assertEquals((long)2L, (long)settings.size());
        this.testCleanDatabase();
        this.addSetting("TestName3", "TestValue3");
        this.addSetting("TestName4", "TestValue4");
        this.addSetting("TestName5", "TestValue5");
        settings = this.settingDao.getAll();
    }

    @Test
    public void testGetSettingsByName() throws Exception {
        this.testCleanDatabase();
        this.addSetting("TestName1", "TestValue1");
        this.addSetting("TestName2", "TestValue2");
        Collection settings = this.settingDao.getByNames(Arrays.asList("TestName1"));
        Assert.assertEquals((long)1L, (long)settings.size());
        Setting setting = (Setting)settings.iterator().next();
        Assert.assertEquals((Object)"TestName1", (Object)setting.getName());
        Assert.assertEquals((Object)"TestValue1", (Object)setting.getValue());
        settings = this.settingDao.getByNames(Arrays.asList("TestName2"));
        Assert.assertEquals((long)1L, (long)settings.size());
        setting = (Setting)settings.iterator().next();
        Assert.assertEquals((Object)"TestName2", (Object)setting.getName());
        Assert.assertEquals((Object)"TestValue2", (Object)setting.getValue());
        settings = this.settingDao.getByNames(Arrays.asList("TestName1", "TestName2"));
        Assert.assertEquals((long)2L, (long)settings.size());
    }

    @Test
    public void testUpdateSetting() throws Exception {
        this.testCleanDatabase();
        this.addSetting("TestName1", "TestValue1");
        this.addSetting("TestName2", "TestValue2");
        Collection settings = this.settingDao.getByNames(Arrays.asList("TestName1"));
        Assert.assertEquals((long)1L, (long)settings.size());
        Setting setting = (Setting)settings.iterator().next();
        Assert.assertEquals((Object)"TestName1", (Object)setting.getName());
        Assert.assertEquals((Object)"TestValue1", (Object)setting.getValue());
        this.settingDao.update("TestName1", "TestUpdatedValue1");
        settings = this.settingDao.getByNames(Arrays.asList("TestName1"));
        Assert.assertEquals((Object)"TestName1", (Object)setting.getName());
        Assert.assertEquals((Object)"TestUpdatedValue1", (Object)setting.getValue());
        this.settingDao.update("TestName2", "TestUpdatedValue2");
        settings = this.settingDao.getByNames(Arrays.asList("TestName2"));
        setting = (Setting)settings.iterator().next();
        Assert.assertEquals((Object)"TestName2", (Object)setting.getName());
        Assert.assertEquals((Object)"TestUpdatedValue2", (Object)setting.getValue());
    }

    static {
        try {
            File baseLocation = new File("dummy.txt");
            String fullDerbyHome = baseLocation.getAbsolutePath().substring(0, baseLocation.getAbsolutePath().lastIndexOf(File.separator)) + derbyHomeLoc;
            System.setProperty("derby.system.home", fullDerbyHome);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

