/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nhindirect.config.store.Anchor;
import org.nhindirect.config.store.EntityStatus;
import org.nhindirect.config.store.dao.AnchorDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"file:src/test/resources/configStore-test.xml"})
@TransactionConfiguration(transactionManager="transactionManager", defaultRollback=true)
@Transactional
public class AnchorDaoTest {
    private static final String derbyHomeLoc = "/target/data";
    private static final String certBasePath = "src/test/resources/certs/";
    private static final String TEST_DOMAIN = "TestDomain1";
    @Autowired
    private AnchorDao anchorDao;

    private void addTestAnchors() throws Exception {
        Anchor anchor = new Anchor();
        anchor.setData(AnchorDaoTest.loadCertificateData("secureHealthEmailCACert.der"));
        anchor.setOwner(TEST_DOMAIN);
        anchor.setOutgoing(true);
        anchor.setIncoming(true);
        this.anchorDao.add(anchor);
        anchor = new Anchor();
        anchor.setData(AnchorDaoTest.loadCertificateData("cacert.der"));
        anchor.setOwner(TEST_DOMAIN);
        anchor.setOutgoing(true);
        anchor.setIncoming(true);
        this.anchorDao.add(anchor);
    }

    private static byte[] loadCertificateData(String certFileName) throws Exception {
        File fl = new File(certBasePath + certFileName);
        return FileUtils.readFileToByteArray((File)fl);
    }

    @Test
    public void testCleanDatabase() throws Exception {
        List anchors = this.anchorDao.listAll();
        if (anchors != null && anchors.size() > 0) {
            for (Anchor anchor : anchors) {
                this.anchorDao.delete(anchor.getOwner());
            }
        }
        anchors = this.anchorDao.listAll();
        Assert.assertEquals((long)0L, (long)anchors.size());
    }

    @Test
    public void testDeleteByIds() throws Exception {
        this.testCleanDatabase();
        this.addTestAnchors();
        List anchors = this.anchorDao.listAll();
        Assert.assertNotNull((Object)anchors);
        Assert.assertTrue((anchors.size() > 0 ? 1 : 0) != 0);
        ArrayList<Long> idsToDelete = new ArrayList<Long>();
        for (Anchor anchorToDel : anchors) {
            idsToDelete.add(anchorToDel.getId());
        }
        this.anchorDao.delete(idsToDelete);
        anchors = this.anchorDao.listAll();
        Assert.assertEquals((long)0L, (long)anchors.size());
    }

    @Test
    public void testAddAnchor() throws Exception {
        this.testCleanDatabase();
        this.addTestAnchors();
        List anchors = this.anchorDao.listAll();
        Assert.assertNotNull((Object)anchors);
        Assert.assertEquals((long)2L, (long)anchors.size());
        Anchor retAnchor = (Anchor)anchors.get(0);
        Assert.assertEquals((Object)retAnchor.getOwner(), (Object)TEST_DOMAIN);
    }

    @Test
    public void testGetByOwner() throws Exception {
        this.testCleanDatabase();
        this.addTestAnchors();
        ArrayList<String> owners = new ArrayList<String>();
        owners.add(TEST_DOMAIN);
        List anchors = this.anchorDao.list(owners);
        Assert.assertNotNull((Object)anchors);
        Assert.assertEquals((long)2L, (long)anchors.size());
        for (Anchor retAnchor : anchors) {
            Assert.assertEquals((Object)retAnchor.getOwner(), (Object)TEST_DOMAIN);
        }
    }

    @Test
    public void testUpdateByIds() throws Exception {
        this.testCleanDatabase();
        this.addTestAnchors();
        List anchors = this.anchorDao.listAll();
        Assert.assertEquals((long)2L, (long)anchors.size());
        ArrayList<Long> idsToUpdate = new ArrayList<Long>();
        for (Anchor anchor : anchors) {
            idsToUpdate.add(anchor.getId());
        }
        this.anchorDao.setStatus(idsToUpdate, EntityStatus.ENABLED);
        anchors = this.anchorDao.listAll();
        Assert.assertEquals((long)2L, (long)anchors.size());
        for (Anchor anchor : anchors) {
            Assert.assertEquals((Object)EntityStatus.ENABLED, (Object)anchor.getStatus());
            Assert.assertEquals((Object)TEST_DOMAIN, (Object)anchor.getOwner());
        }
    }

    @Test
    public void testUpdateByOwner() throws Exception {
        this.testCleanDatabase();
        this.addTestAnchors();
        ArrayList<String> owners = new ArrayList<String>();
        owners.add(TEST_DOMAIN);
        List anchors = this.anchorDao.list(owners);
        Assert.assertEquals((long)2L, (long)anchors.size());
        ArrayList<Long> idsToUpdate = new ArrayList<Long>();
        for (Anchor anchor : anchors) {
            idsToUpdate.add(anchor.getId());
        }
        this.anchorDao.setStatus(idsToUpdate, EntityStatus.ENABLED);
        anchors = this.anchorDao.listAll();
        Assert.assertEquals((long)2L, (long)anchors.size());
        for (Anchor anchor : anchors) {
            Assert.assertEquals((Object)EntityStatus.ENABLED, (Object)anchor.getStatus());
            Assert.assertEquals((Object)TEST_DOMAIN, (Object)anchor.getOwner());
        }
    }

    static {
        try {
            File baseLocation = new File("dummy.txt");
            String fullDerbyHome = baseLocation.getAbsolutePath().substring(0, baseLocation.getAbsolutePath().lastIndexOf(File.separator)) + derbyHomeLoc;
            System.setProperty("derby.system.home", fullDerbyHome);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

