/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.io.File;
import java.security.Provider;
import java.security.Security;
import java.util.Collection;
import java.util.List;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.nhindirect.config.store.CertPolicy;
import org.nhindirect.config.store.CertPolicyGroup;
import org.nhindirect.config.store.Domain;
import org.nhindirect.config.store.dao.CertPolicyDao;
import org.nhindirect.config.store.dao.DomainDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"file:src/test/resources/configStore-test.xml"})
@TransactionConfiguration(transactionManager="transactionManager", defaultRollback=true)
@Transactional
public abstract class CertPolicyDaoBaseTest {
    @Autowired
    protected CertPolicyDao polDao;
    @Autowired
    protected DomainDao dmDao;
    private static final String derbyHomeLoc = "/target/data";

    @Before
    public void setUp() {
        this.clearPolicies();
        this.clearDomains();
    }

    protected void clearPolicies() {
        Collection policies = this.polDao.getPolicies();
        Assert.assertNotNull((Object)policies);
        if (!policies.isEmpty()) {
            long[] ids = new long[policies.size()];
            int idx = 0;
            for (CertPolicy policy : policies) {
                ids[idx++] = policy.getId();
            }
            this.polDao.deletePolicies(ids);
        }
        policies = this.polDao.getPolicies();
        Assert.assertTrue((boolean)policies.isEmpty());
        Collection policyGroups = this.polDao.getPolicyGroups();
        Assert.assertNotNull((Object)policyGroups);
        if (!policyGroups.isEmpty()) {
            long[] ids = new long[policies.size()];
            int idx = 0;
            for (CertPolicyGroup group : policyGroups) {
                ids[idx++] = group.getId();
            }
            this.polDao.deletePolicyGroups(ids);
        }
        policyGroups = this.polDao.getPolicyGroups();
        Assert.assertTrue((boolean)policyGroups.isEmpty());
    }

    protected void clearDomains() {
        List domains = this.dmDao.searchDomain(null, null);
        if (domains != null) {
            for (Domain dom : domains) {
                this.dmDao.delete(dom.getDomainName());
            }
        }
        domains = this.dmDao.searchDomain(null, null);
        Assert.assertEquals((long)0L, (long)domains.size());
    }

    static {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            File baseLocation = new File("dummy.txt");
            String fullDerbyHome = baseLocation.getAbsolutePath().substring(0, baseLocation.getAbsolutePath().lastIndexOf(File.separator)) + derbyHomeLoc;
            System.setProperty("derby.system.home", fullDerbyHome);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

