/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.util.Collection;
import java.util.Iterator;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.nhindirect.config.store.CertPolicyDaoBaseTest;
import org.nhindirect.config.store.CertPolicyGroup;
import org.nhindirect.config.store.CertPolicyGroupDomainReltn;
import org.nhindirect.config.store.ConfigurationStoreException;
import org.nhindirect.config.store.Domain;
import org.nhindirect.config.store.dao.DomainDao;
import org.nhindirect.config.store.dao.impl.CertPolicyDaoImpl;

public class CertPolicyDaoBase_getPolicyGroupsByDomainTest
extends CertPolicyDaoBaseTest {
    @Test
    public void testGetPolicyGroupsByDomain_associationsExist_assertPoliciesRetrieved() {
        Domain domain = new Domain();
        domain.setDomainName("Test Domain");
        this.dmDao.add(domain);
        CertPolicyGroup group = new CertPolicyGroup();
        group.setPolicyGroupName("Test Group");
        this.polDao.addPolicyGroup(group);
        this.polDao.associatePolicyGroupToDomain(domain.getId().longValue(), group.getId());
        Collection policies = this.polDao.getPolicyGroupsByDomain(domain.getId().longValue());
        Assert.assertEquals((long)1L, (long)policies.size());
    }

    @Test
    public void testGetPolicyGroupsByDomain_multipleAssociationsExist_assertPoliciesRetrieved() {
        Domain domain = new Domain();
        domain.setDomainName("Test Domain");
        this.dmDao.add(domain);
        CertPolicyGroup group1 = new CertPolicyGroup();
        group1.setPolicyGroupName("Test Group1");
        this.polDao.addPolicyGroup(group1);
        CertPolicyGroup group2 = new CertPolicyGroup();
        group2.setPolicyGroupName("Test Group2");
        this.polDao.addPolicyGroup(group2);
        this.polDao.associatePolicyGroupToDomain(domain.getId().longValue(), group1.getId());
        this.polDao.associatePolicyGroupToDomain(domain.getId().longValue(), group2.getId());
        Collection policies = this.polDao.getPolicyGroupsByDomain(domain.getId().longValue());
        Assert.assertEquals((long)2L, (long)policies.size());
        Iterator polIter = policies.iterator();
        Assert.assertEquals((Object)group1.getPolicyGroupName(), (Object)((CertPolicyGroupDomainReltn)polIter.next()).getCertPolicyGroup().getPolicyGroupName());
        Assert.assertEquals((Object)group2.getPolicyGroupName(), (Object)((CertPolicyGroupDomainReltn)polIter.next()).getCertPolicyGroup().getPolicyGroupName());
    }

    @Test
    public void testGetPolicyGroupsByDomain_multipleAssociationsExist_oneToEachDomain_assertPoliciesRetrieved() {
        Domain domain1 = new Domain();
        domain1.setDomainName("Test Domain 1");
        this.dmDao.add(domain1);
        Domain domain2 = new Domain();
        domain2.setDomainName("Test Domain 2");
        this.dmDao.add(domain2);
        CertPolicyGroup group1 = new CertPolicyGroup();
        group1.setPolicyGroupName("Test Group1");
        this.polDao.addPolicyGroup(group1);
        CertPolicyGroup group2 = new CertPolicyGroup();
        group2.setPolicyGroupName("Test Group2");
        this.polDao.addPolicyGroup(group2);
        this.polDao.associatePolicyGroupToDomain(domain1.getId().longValue(), group1.getId());
        this.polDao.associatePolicyGroupToDomain(domain2.getId().longValue(), group2.getId());
        Collection policies = this.polDao.getPolicyGroupsByDomain(domain1.getId().longValue());
        Assert.assertEquals((long)1L, (long)policies.size());
        Iterator polIter = policies.iterator();
        Assert.assertEquals((Object)group1.getPolicyGroupName(), (Object)((CertPolicyGroupDomainReltn)polIter.next()).getCertPolicyGroup().getPolicyGroupName());
        policies = this.polDao.getPolicyGroupsByDomain(domain2.getId().longValue());
        Assert.assertEquals((long)1L, (long)policies.size());
        polIter = policies.iterator();
        Assert.assertEquals((Object)group2.getPolicyGroupName(), (Object)((CertPolicyGroupDomainReltn)polIter.next()).getCertPolicyGroup().getPolicyGroupName());
    }

    @Test
    public void testGetPolicyGroupsByDomain_multipleAssociationsExist_policyToMultipeDomains_assertPoliciesRetrieved() {
        Domain domain1 = new Domain();
        domain1.setDomainName("Test Domain 1");
        this.dmDao.add(domain1);
        Domain domain2 = new Domain();
        domain2.setDomainName("Test Domain 2");
        this.dmDao.add(domain2);
        CertPolicyGroup group1 = new CertPolicyGroup();
        group1.setPolicyGroupName("Test Group1");
        this.polDao.addPolicyGroup(group1);
        this.polDao.associatePolicyGroupToDomain(domain1.getId().longValue(), group1.getId());
        this.polDao.associatePolicyGroupToDomain(domain2.getId().longValue(), group1.getId());
        Collection policies = this.polDao.getPolicyGroupsByDomain(domain1.getId().longValue());
        Assert.assertEquals((long)1L, (long)policies.size());
        Iterator polIter = policies.iterator();
        Assert.assertEquals((Object)group1.getPolicyGroupName(), (Object)((CertPolicyGroupDomainReltn)polIter.next()).getCertPolicyGroup().getPolicyGroupName());
        policies = this.polDao.getPolicyGroupsByDomain(domain2.getId().longValue());
        Assert.assertEquals((long)1L, (long)policies.size());
        polIter = policies.iterator();
        Assert.assertEquals((Object)group1.getPolicyGroupName(), (Object)((CertPolicyGroupDomainReltn)polIter.next()).getCertPolicyGroup().getPolicyGroupName());
    }

    @Test
    public void testGetPolicyGroupsByDomain_noPoliciesInDomain_assertPoliciesNotRetrieved() {
        Domain domain1 = new Domain();
        domain1.setDomainName("Test Domain 1");
        this.dmDao.add(domain1);
        Collection policies = this.polDao.getPolicyGroupsByDomain(domain1.getId().longValue());
        Assert.assertEquals((long)0L, (long)policies.size());
    }

    @Test
    public void testGetPolicyGroupsByDomain_unknownDomain_assertException() {
        boolean exceptionOccured = false;
        try {
            this.polDao.getPolicyGroupsByDomain(1234L);
        }
        catch (ConfigurationStoreException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testGetPolicyGroupsByDomain_noEntityManager_assertException() {
        CertPolicyDaoImpl dao = new CertPolicyDaoImpl();
        boolean exceptionOccured = false;
        try {
            dao.getPolicyGroupsByDomain(1234L);
        }
        catch (IllegalStateException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testGetPolicyGroupsByDomain_errorInGet_assertException() {
        boolean exceptionOccured = false;
        EntityManager mgr = (EntityManager)Mockito.mock(EntityManager.class);
        Domain domain = (Domain)Mockito.mock(Domain.class);
        DomainDao domainDao = (DomainDao)Mockito.mock(DomainDao.class);
        Mockito.when((Object)domainDao.getDomain(new Long(1234L))).thenReturn((Object)domain);
        CertPolicyGroupDomainReltn reltn = (CertPolicyGroupDomainReltn)Mockito.mock(CertPolicyGroupDomainReltn.class);
        Query findReltnQeury = (Query)Mockito.mock(Query.class);
        Mockito.when((Object)findReltnQeury.getSingleResult()).thenReturn((Object)reltn);
        ((Query)Mockito.doThrow((Throwable)new RuntimeException("Just Passing Through")).when((Object)findReltnQeury)).getResultList();
        Mockito.when((Object)mgr.createQuery("SELECT cpr from CertPolicyGroupDomainReltn cpr where cpr.domain = ?1")).thenReturn((Object)findReltnQeury);
        CertPolicyDaoImpl dao = new CertPolicyDaoImpl();
        dao.setDomainDao(domainDao);
        dao.setEntityManager(mgr);
        CertPolicyDaoImpl spyDao = (CertPolicyDaoImpl)Mockito.spy((Object)dao);
        try {
            spyDao.getPolicyGroupsByDomain(1234L);
        }
        catch (ConfigurationStoreException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        ((DomainDao)Mockito.verify((Object)domainDao, (VerificationMode)Mockito.times((int)1))).getDomain(new Long(1234L));
        ((Query)Mockito.verify((Object)findReltnQeury, (VerificationMode)Mockito.times((int)1))).getResultList();
    }
}

