/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.util.Calendar;
import java.util.Collection;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.config.store.CertPolicyDaoBaseTest;
import org.nhindirect.config.store.CertPolicyGroup;
import org.nhindirect.config.store.ConfigurationStoreException;
import org.nhindirect.config.store.dao.impl.CertPolicyDaoImpl;

public class CertPolicyDaoImpl_addPolicyGroupTest
extends CertPolicyDaoBaseTest {
    @Test
    public void testAddPolicyGroup_addPolicyGroup_assertAdded() {
        Calendar now = Calendar.getInstance(Locale.getDefault());
        CertPolicyGroup group = new CertPolicyGroup();
        group.setPolicyGroupName("Test Group");
        this.polDao.addPolicyGroup(group);
        Collection groups = this.polDao.getPolicyGroups();
        Assert.assertEquals((long)1L, (long)groups.size());
        CertPolicyGroup addedGroup = (CertPolicyGroup)groups.iterator().next();
        Assert.assertEquals((Object)group.getPolicyGroupName(), (Object)addedGroup.getPolicyGroupName());
        Assert.assertTrue((now.getTimeInMillis() <= addedGroup.getCreateTime().getTimeInMillis() ? 1 : 0) != 0);
    }

    @Test
    public void testAddPolicyGroup_addExistingPolicy_assertException() {
        CertPolicyGroup group = new CertPolicyGroup();
        group.setPolicyGroupName("Test Group");
        this.polDao.addPolicyGroup(group);
        Collection groups = this.polDao.getPolicyGroups();
        Assert.assertEquals((long)1L, (long)groups.size());
        boolean exceptionOccured = false;
        try {
            this.polDao.addPolicyGroup(group);
        }
        catch (ConfigurationStoreException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        groups = this.polDao.getPolicyGroups();
        Assert.assertEquals((long)1L, (long)groups.size());
    }

    @Test
    public void testAddPolicyGroup_noEntityManager_assertException() {
        CertPolicyDaoImpl dao = new CertPolicyDaoImpl();
        boolean exceptionOccured = false;
        try {
            dao.addPolicyGroup(new CertPolicyGroup());
        }
        catch (IllegalStateException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }
}

