/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.config.store.CertPolicy;
import org.nhindirect.config.store.CertPolicyDaoBaseTest;
import org.nhindirect.config.store.ConfigurationStoreException;
import org.nhindirect.config.store.dao.impl.CertPolicyDaoImpl;
import org.nhindirect.policy.PolicyLexicon;

public class CertPolicyDaoImpl_addPolicyTest
extends CertPolicyDaoBaseTest {
    @Test
    public void testAddPolicy_addPolicy_assertAdded() {
        Calendar now = Calendar.getInstance(Locale.getDefault());
        CertPolicy policy = new CertPolicy();
        policy.setPolicyName("Test PolicY");
        policy.setLexicon(PolicyLexicon.XML);
        policy.setPolicyData(new byte[]{1, 2, 3});
        this.polDao.addPolicy(policy);
        Collection policies = this.polDao.getPolicies();
        Assert.assertEquals((long)1L, (long)policies.size());
        CertPolicy addedPolicy = (CertPolicy)policies.iterator().next();
        Assert.assertEquals((Object)policy.getPolicyName(), (Object)addedPolicy.getPolicyName());
        Assert.assertEquals((Object)policy.getLexicon(), (Object)addedPolicy.getLexicon());
        Assert.assertTrue((now.getTimeInMillis() <= addedPolicy.getCreateTime().getTimeInMillis() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Arrays.equals(policy.getPolicyData(), addedPolicy.getPolicyData()));
    }

    @Test
    public void testAddPolicy_addExistingPolicy_assertException() {
        CertPolicy policy = new CertPolicy();
        policy.setPolicyName("Test PolicY");
        policy.setLexicon(PolicyLexicon.XML);
        policy.setPolicyData(new byte[]{1, 2, 3});
        this.polDao.addPolicy(policy);
        Collection policies = this.polDao.getPolicies();
        Assert.assertEquals((long)1L, (long)policies.size());
        boolean exceptionOccured = false;
        try {
            this.polDao.addPolicy(policy);
        }
        catch (ConfigurationStoreException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        policies = this.polDao.getPolicies();
        Assert.assertEquals((long)1L, (long)policies.size());
    }

    @Test
    public void testAddPolicy_noEntityManager_assertException() {
        CertPolicyDaoImpl dao = new CertPolicyDaoImpl();
        boolean exceptionOccured = false;
        try {
            dao.addPolicy(new CertPolicy());
        }
        catch (IllegalStateException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }
}

