/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.nhindirect.config.store.CertPolicy;
import org.nhindirect.config.store.CertPolicyDaoBaseTest;
import org.nhindirect.config.store.CertPolicyGroup;
import org.nhindirect.config.store.CertPolicyGroupReltn;
import org.nhindirect.config.store.CertPolicyUse;
import org.nhindirect.config.store.ConfigurationStoreException;
import org.nhindirect.config.store.dao.impl.CertPolicyDaoImpl;
import org.nhindirect.policy.PolicyLexicon;

public class CertPolicyDaoImpl_addPolicyUseToGroupTest
extends CertPolicyDaoBaseTest {
    @Test
    public void testAddPolicyToGroup_associatePolicyAndGroup_assertAssociationAdded() {
        CertPolicy policy = new CertPolicy();
        policy.setPolicyName("Test PolicY");
        policy.setLexicon(PolicyLexicon.XML);
        policy.setPolicyData(new byte[]{1, 2, 3});
        this.polDao.addPolicy(policy);
        CertPolicyGroup group = new CertPolicyGroup();
        group.setPolicyGroupName("Test Group");
        this.polDao.addPolicyGroup(group);
        this.polDao.addPolicyUseToGroup(group.getId(), policy.getId(), CertPolicyUse.PUBLIC_RESOLVER, true, false);
        CertPolicyGroup assocGroup = this.polDao.getPolicyGroupById(group.getId());
        Assert.assertEquals((long)1L, (long)assocGroup.getCertPolicyGroupReltn().size());
        CertPolicyGroupReltn reltn = (CertPolicyGroupReltn)assocGroup.getCertPolicyGroupReltn().iterator().next();
        Assert.assertEquals((long)policy.getId(), (long)reltn.getCertPolicy().getId());
        Assert.assertEquals((long)group.getId(), (long)reltn.getCertPolicyGroup().getId());
        Assert.assertEquals((Object)CertPolicyUse.PUBLIC_RESOLVER, (Object)reltn.getPolicyUse());
        Assert.assertTrue((boolean)reltn.isIncoming());
        Assert.assertFalse((boolean)reltn.isOutgoing());
    }

    @Test
    public void testAddPolicyToGroup_unknownGroup_assertException() {
        boolean exceptionOccured = false;
        try {
            this.polDao.addPolicyUseToGroup(1234L, 5678L, CertPolicyUse.PRIVATE_RESOLVER, true, true);
        }
        catch (ConfigurationStoreException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testAddPolicyToGroup_unknownTrustBundle_assertException() {
        boolean exceptionOccured = false;
        EntityManager mgr = (EntityManager)Mockito.mock(EntityManager.class);
        CertPolicyDaoImpl certDao = new CertPolicyDaoImpl(){

            public CertPolicyGroup getPolicyGroupById(long id) throws ConfigurationStoreException {
                return new CertPolicyGroup();
            }
        };
        Query query = (Query)Mockito.mock(Query.class);
        ((Query)Mockito.doThrow((Throwable)new NoResultException()).when((Object)query)).getSingleResult();
        Mockito.when((Object)mgr.createQuery("SELECT cp from CertPolicy cp WHERE cp.id = ?1")).thenReturn((Object)query);
        certDao.setEntityManager(mgr);
        CertPolicyDaoImpl spyDao = (CertPolicyDaoImpl)Mockito.spy((Object)certDao);
        try {
            spyDao.addPolicyUseToGroup(1234L, 5678L, CertPolicyUse.PRIVATE_RESOLVER, true, true);
        }
        catch (ConfigurationStoreException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        ((CertPolicyDaoImpl)Mockito.verify((Object)spyDao, (VerificationMode)Mockito.times((int)1))).getPolicyGroupById(1234L);
        ((CertPolicyDaoImpl)Mockito.verify((Object)spyDao, (VerificationMode)Mockito.times((int)1))).getPolicyById(5678L);
        ((EntityManager)Mockito.verify((Object)mgr, (VerificationMode)Mockito.never())).persist((Object)((CertPolicyGroupReltn)Matchers.any()));
    }

    @Test
    public void testAddPolicyToGroup_errorInAdd_assertException() {
        boolean exceptionOccured = false;
        EntityManager mgr = (EntityManager)Mockito.mock(EntityManager.class);
        ((EntityManager)Mockito.doThrow((Throwable)new RuntimeException("Just Passing Through")).when((Object)mgr)).persist((Object)((CertPolicyGroupReltn)Matchers.any()));
        CertPolicyDaoImpl certDao = new CertPolicyDaoImpl(){

            public CertPolicy getPolicyById(long id) throws ConfigurationStoreException {
                return new CertPolicy();
            }

            public CertPolicyGroup getPolicyGroupById(long id) throws ConfigurationStoreException {
                return new CertPolicyGroup();
            }
        };
        certDao.setEntityManager(mgr);
        CertPolicyDaoImpl spyDao = (CertPolicyDaoImpl)Mockito.spy((Object)certDao);
        try {
            spyDao.addPolicyUseToGroup(1234L, 5678L, CertPolicyUse.PRIVATE_RESOLVER, true, true);
        }
        catch (ConfigurationStoreException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        ((CertPolicyDaoImpl)Mockito.verify((Object)spyDao, (VerificationMode)Mockito.times((int)1))).getPolicyGroupById(1234L);
        ((CertPolicyDaoImpl)Mockito.verify((Object)spyDao, (VerificationMode)Mockito.times((int)1))).getPolicyById(5678L);
        ((EntityManager)Mockito.verify((Object)mgr, (VerificationMode)Mockito.times((int)1))).persist((Object)((CertPolicyGroupReltn)Matchers.any()));
    }

    @Test
    public void testAddPolicyToGroup_noEntityManager_assertException() {
        CertPolicyDaoImpl dao = new CertPolicyDaoImpl();
        boolean exceptionOccured = false;
        try {
            dao.addPolicyUseToGroup(1234L, 5678L, CertPolicyUse.PRIVATE_RESOLVER, true, true);
        }
        catch (IllegalStateException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }
}

