/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.util.Collection;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.nhindirect.config.store.CertPolicyDaoBaseTest;
import org.nhindirect.config.store.CertPolicyGroup;
import org.nhindirect.config.store.CertPolicyGroupDomainReltn;
import org.nhindirect.config.store.ConfigurationStoreException;
import org.nhindirect.config.store.Domain;
import org.nhindirect.config.store.dao.DomainDao;
import org.nhindirect.config.store.dao.impl.CertPolicyDaoImpl;

public class CertPolicyDaoImpl_associatePolicyGroupToDomainTest
extends CertPolicyDaoBaseTest {
    @Test
    public void testAssociatePolicyGroupToDomain_associateDomainAndGroup_assertAssociationAdded() {
        Domain domain = new Domain();
        domain.setDomainName("Test Domain");
        this.dmDao.add(domain);
        CertPolicyGroup group = new CertPolicyGroup();
        group.setPolicyGroupName("Test Group");
        this.polDao.addPolicyGroup(group);
        this.polDao.associatePolicyGroupToDomain(domain.getId().longValue(), group.getId());
        Collection groupReltn = this.polDao.getPolicyGroupsByDomain(domain.getId().longValue());
        Assert.assertEquals((long)1L, (long)groupReltn.size());
        CertPolicyGroupDomainReltn reltn = (CertPolicyGroupDomainReltn)groupReltn.iterator().next();
        Assert.assertEquals((Object)group, (Object)reltn.getCertPolicyGroup());
        Assert.assertEquals((Object)domain, (Object)reltn.getDomain());
    }

    @Test
    public void testAssociatePolicyGroupToDomain_unknownDomain_assertException() {
        boolean exceptionOccured = false;
        EntityManager mgr = (EntityManager)Mockito.mock(EntityManager.class);
        DomainDao domainDao = (DomainDao)Mockito.mock(DomainDao.class);
        CertPolicyDaoImpl dao = new CertPolicyDaoImpl();
        dao.setDomainDao(domainDao);
        dao.setEntityManager(mgr);
        CertPolicyDaoImpl spyDao = (CertPolicyDaoImpl)Mockito.spy((Object)dao);
        try {
            spyDao.associatePolicyGroupToDomain(1234L, 5678L);
        }
        catch (ConfigurationStoreException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        ((DomainDao)Mockito.verify((Object)domainDao, (VerificationMode)Mockito.times((int)1))).getDomain(new Long(1234L));
        ((CertPolicyDaoImpl)Mockito.verify((Object)spyDao, (VerificationMode)Mockito.never())).getPolicyGroupById(5678L);
    }

    @Test
    public void testAssociatePolicyGroupToDomain_unknownPolicyGroup_assertException() {
        boolean exceptionOccured = false;
        EntityManager mgr = (EntityManager)Mockito.mock(EntityManager.class);
        Domain domain = (Domain)Mockito.mock(Domain.class);
        DomainDao domainDao = (DomainDao)Mockito.mock(DomainDao.class);
        Mockito.when((Object)domainDao.getDomain(new Long(1234L))).thenReturn((Object)domain);
        CertPolicyDaoImpl dao = new CertPolicyDaoImpl();
        Query query = (Query)Mockito.mock(Query.class);
        ((Query)Mockito.doThrow((Throwable)new NoResultException()).when((Object)query)).getSingleResult();
        Mockito.when((Object)mgr.createQuery("SELECT cpg from CertPolicyGroup cpg WHERE cpg.id = ?1")).thenReturn((Object)query);
        dao.setDomainDao(domainDao);
        dao.setEntityManager(mgr);
        CertPolicyDaoImpl spyDao = (CertPolicyDaoImpl)Mockito.spy((Object)dao);
        try {
            spyDao.associatePolicyGroupToDomain(1234L, 5678L);
        }
        catch (ConfigurationStoreException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        ((DomainDao)Mockito.verify((Object)domainDao, (VerificationMode)Mockito.times((int)1))).getDomain(new Long(1234L));
        ((CertPolicyDaoImpl)Mockito.verify((Object)spyDao, (VerificationMode)Mockito.times((int)1))).getPolicyGroupById(5678L);
        ((EntityManager)Mockito.verify((Object)mgr, (VerificationMode)Mockito.never())).persist((Object)((CertPolicyGroupDomainReltn)Matchers.any()));
    }

    @Test
    public void testAssociatePolicyGroupToDomain_errorInAdd_assertException() {
        boolean exceptionOccured = false;
        EntityManager mgr = (EntityManager)Mockito.mock(EntityManager.class);
        ((EntityManager)Mockito.doThrow((Throwable)new RuntimeException("Just Passing Through")).when((Object)mgr)).persist((Object)((CertPolicyGroupDomainReltn)Matchers.any()));
        Domain domain = (Domain)Mockito.mock(Domain.class);
        DomainDao domainDao = (DomainDao)Mockito.mock(DomainDao.class);
        Mockito.when((Object)domainDao.getDomain(new Long(1234L))).thenReturn((Object)domain);
        CertPolicyGroup group = (CertPolicyGroup)Mockito.mock(CertPolicyGroup.class);
        Query query = (Query)Mockito.mock(Query.class);
        Mockito.when((Object)query.getSingleResult()).thenReturn((Object)group);
        Mockito.when((Object)mgr.createQuery("SELECT cpg from CertPolicyGroup cpg WHERE cpg.id = ?1")).thenReturn((Object)query);
        CertPolicyDaoImpl dao = new CertPolicyDaoImpl();
        dao.setDomainDao(domainDao);
        dao.setEntityManager(mgr);
        CertPolicyDaoImpl spyDao = (CertPolicyDaoImpl)Mockito.spy((Object)dao);
        try {
            spyDao.associatePolicyGroupToDomain(1234L, 5678L);
        }
        catch (ConfigurationStoreException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        ((DomainDao)Mockito.verify((Object)domainDao, (VerificationMode)Mockito.times((int)1))).getDomain(Long.valueOf(1234L));
        ((CertPolicyDaoImpl)Mockito.verify((Object)spyDao, (VerificationMode)Mockito.times((int)1))).getPolicyGroupById(5678L);
        ((EntityManager)Mockito.verify((Object)mgr, (VerificationMode)Mockito.times((int)1))).persist((Object)((CertPolicyGroupDomainReltn)Matchers.any()));
    }

    @Test
    public void testAssociatePolicyGroupToDomain_noEntityManager_assertException() {
        CertPolicyDaoImpl dao = new CertPolicyDaoImpl();
        boolean exceptionOccured = false;
        try {
            dao.associatePolicyGroupToDomain(1234L, 5678L);
        }
        catch (IllegalStateException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }
}

