/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.util.Collection;
import java.util.Iterator;
import javax.persistence.EntityManager;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.nhindirect.config.store.CertPolicy;
import org.nhindirect.config.store.CertPolicyDaoBaseTest;
import org.nhindirect.config.store.ConfigurationStoreException;
import org.nhindirect.config.store.TrustBundle;
import org.nhindirect.config.store.dao.impl.CertPolicyDaoImpl;
import org.nhindirect.policy.PolicyLexicon;

public class CertPolicyDaoImpl_deletePoliciesTest
extends CertPolicyDaoBaseTest {
    @Test
    public void testDeletePolicies_singlePolicy_assertPolicyDeleted() {
        CertPolicy policy = new CertPolicy();
        policy.setPolicyName("Test Policy");
        policy.setLexicon(PolicyLexicon.XML);
        policy.setPolicyData(new byte[]{1, 2, 3});
        this.polDao.addPolicy(policy);
        Collection policies = this.polDao.getPolicies();
        Assert.assertEquals((long)1L, (long)policies.size());
        this.polDao.deletePolicies(new long[]{((CertPolicy)policies.iterator().next()).getId()});
        policies = this.polDao.getPolicies();
        Assert.assertEquals((long)0L, (long)policies.size());
    }

    @Test
    public void testDeletePolicies_multiplePolicies_assertSinglePolicyDeleted() {
        CertPolicy policy1 = new CertPolicy();
        policy1.setPolicyName("Test Policy1");
        policy1.setLexicon(PolicyLexicon.XML);
        policy1.setPolicyData(new byte[]{1, 2, 3});
        this.polDao.addPolicy(policy1);
        CertPolicy policy2 = new CertPolicy();
        policy2.setPolicyName("Test Policy2");
        policy2.setLexicon(PolicyLexicon.JAVA_SER);
        policy2.setPolicyData(new byte[]{4, 5, 6});
        this.polDao.addPolicy(policy2);
        Collection policies = this.polDao.getPolicies();
        Assert.assertEquals((long)2L, (long)policies.size());
        this.polDao.deletePolicies(new long[]{((CertPolicy)policies.iterator().next()).getId()});
        policies = this.polDao.getPolicies();
        Assert.assertEquals((long)1L, (long)policies.size());
    }

    @Test
    public void testDeletePolicies_multiplePolicyes_assertAllPoliciesDeleted() {
        CertPolicy policy1 = new CertPolicy();
        policy1.setPolicyName("Test Policy1");
        policy1.setLexicon(PolicyLexicon.XML);
        policy1.setPolicyData(new byte[]{1, 2, 3});
        this.polDao.addPolicy(policy1);
        CertPolicy policy2 = new CertPolicy();
        policy2.setPolicyName("Test Policy2");
        policy2.setLexicon(PolicyLexicon.JAVA_SER);
        policy2.setPolicyData(new byte[]{4, 5, 6});
        this.polDao.addPolicy(policy2);
        Collection policies = this.polDao.getPolicies();
        Assert.assertEquals((long)2L, (long)policies.size());
        Iterator iter = policies.iterator();
        this.polDao.deletePolicies(new long[]{((CertPolicy)iter.next()).getId(), ((CertPolicy)iter.next()).getId()});
        policies = this.polDao.getPolicies();
        Assert.assertEquals((long)0L, (long)policies.size());
    }

    @Test
    public void testDeletePolicies_nullArray_assertNoError() {
        this.polDao.deletePolicies(null);
    }

    @Test
    public void testDeletePolicies_emptyArray_assertNoError() {
        this.polDao.deletePolicies(new long[0]);
    }

    @Test
    public void testDeletePolicies_exceptionInQuery_assertNoException() {
        EntityManager manager = (EntityManager)Mockito.mock(EntityManager.class);
        ((EntityManager)Mockito.doThrow((Throwable)new RuntimeException("Just Passing Through")).when((Object)manager)).remove((Object)((TrustBundle)Matchers.any()));
        CertPolicyDaoImpl dao = new CertPolicyDaoImpl();
        dao.setEntityManager(manager);
        boolean exceptionOccured = false;
        try {
            dao.deletePolicies(new long[]{1234L});
        }
        catch (ConfigurationStoreException ex) {
            exceptionOccured = true;
        }
        Assert.assertFalse((boolean)exceptionOccured);
        ((EntityManager)Mockito.verify((Object)manager, (VerificationMode)Mockito.never())).remove((Object)((CertPolicy)Matchers.any()));
        ((EntityManager)Mockito.verify((Object)manager, (VerificationMode)Mockito.never())).flush();
    }

    @Test
    public void testDeletePolicies_noEntityManager_assertException() {
        CertPolicyDaoImpl dao = new CertPolicyDaoImpl();
        boolean exceptionOccured = false;
        try {
            dao.deletePolicies(new long[]{1234L});
        }
        catch (IllegalStateException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }
}

