/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.util.Collection;
import java.util.Iterator;
import javax.persistence.EntityManager;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.nhindirect.config.store.CertPolicyDaoBaseTest;
import org.nhindirect.config.store.CertPolicyGroup;
import org.nhindirect.config.store.ConfigurationStoreException;
import org.nhindirect.config.store.TrustBundle;
import org.nhindirect.config.store.dao.impl.CertPolicyDaoImpl;

public class CertPolicyDaoImpl_deletePolicyGroupsTest
extends CertPolicyDaoBaseTest {
    @Test
    public void testDeletePolicyGroups_singlePolicyGroup_assertPolicyGroupDeleted() {
        CertPolicyGroup group = new CertPolicyGroup();
        group.setPolicyGroupName("Test Group");
        this.polDao.addPolicyGroup(group);
        Collection groups = this.polDao.getPolicyGroups();
        Assert.assertEquals((long)1L, (long)groups.size());
        this.polDao.deletePolicyGroups(new long[]{((CertPolicyGroup)groups.iterator().next()).getId()});
        groups = this.polDao.getPolicyGroups();
        Assert.assertEquals((long)0L, (long)groups.size());
    }

    @Test
    public void testDeletePolicyGroups_multiplePolicyGroups_assertSinglePolicyGroupDeleted() {
        CertPolicyGroup group1 = new CertPolicyGroup();
        group1.setPolicyGroupName("Test Group1");
        this.polDao.addPolicyGroup(group1);
        CertPolicyGroup group2 = new CertPolicyGroup();
        group2.setPolicyGroupName("Test Group2");
        this.polDao.addPolicyGroup(group2);
        Collection groups = this.polDao.getPolicyGroups();
        Assert.assertEquals((long)2L, (long)groups.size());
        this.polDao.deletePolicyGroups(new long[]{((CertPolicyGroup)groups.iterator().next()).getId()});
        groups = this.polDao.getPolicyGroups();
        Assert.assertEquals((long)1L, (long)groups.size());
    }

    @Test
    public void testDeletePolicyGroups_multiplePolicyGroups_assertAllPolicyGroupsDeleted() {
        CertPolicyGroup group1 = new CertPolicyGroup();
        group1.setPolicyGroupName("Test Group1");
        this.polDao.addPolicyGroup(group1);
        CertPolicyGroup group2 = new CertPolicyGroup();
        group2.setPolicyGroupName("Test Group2");
        this.polDao.addPolicyGroup(group2);
        Collection groups = this.polDao.getPolicyGroups();
        Assert.assertEquals((long)2L, (long)groups.size());
        Iterator iter = groups.iterator();
        this.polDao.deletePolicyGroups(new long[]{((CertPolicyGroup)iter.next()).getId(), ((CertPolicyGroup)iter.next()).getId()});
        groups = this.polDao.getPolicyGroups();
        Assert.assertEquals((long)0L, (long)groups.size());
    }

    @Test
    public void testDeletePolicyGroups_nullArray_assertNoError() {
        this.polDao.deletePolicyGroups(null);
    }

    @Test
    public void testDeletePolicyGroups_emptyArray_assertNoError() {
        this.polDao.deletePolicyGroups(new long[0]);
    }

    @Test
    public void testDeletePolicyGroups_exceptionInQuery_assertNoException() {
        EntityManager manager = (EntityManager)Mockito.mock(EntityManager.class);
        ((EntityManager)Mockito.doThrow((Throwable)new RuntimeException("Just Passing Through")).when((Object)manager)).remove((Object)((TrustBundle)Matchers.any()));
        CertPolicyDaoImpl dao = new CertPolicyDaoImpl();
        dao.setEntityManager(manager);
        boolean exceptionOccured = false;
        try {
            dao.deletePolicyGroups(new long[]{1234L});
        }
        catch (ConfigurationStoreException ex) {
            exceptionOccured = true;
        }
        Assert.assertFalse((boolean)exceptionOccured);
        ((EntityManager)Mockito.verify((Object)manager, (VerificationMode)Mockito.never())).remove((Object)((CertPolicyGroup)Matchers.any()));
        ((EntityManager)Mockito.verify((Object)manager, (VerificationMode)Mockito.never())).flush();
    }

    @Test
    public void testDeletePolicyGroups_noEntityManager_assertException() {
        CertPolicyDaoImpl dao = new CertPolicyDaoImpl();
        boolean exceptionOccured = false;
        try {
            dao.deletePolicyGroups(new long[]{1234L});
        }
        catch (IllegalStateException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }
}

