/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.util.Collection;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.nhindirect.config.store.CertPolicyDaoBaseTest;
import org.nhindirect.config.store.CertPolicyGroup;
import org.nhindirect.config.store.ConfigurationStoreException;
import org.nhindirect.config.store.Domain;
import org.nhindirect.config.store.dao.DomainDao;
import org.nhindirect.config.store.dao.impl.CertPolicyDaoImpl;

public class CertPolicyDaoImpl_disassociatePolicyGroupFromDomainsTest
extends CertPolicyDaoBaseTest {
    @Test
    public void testDisassociatePolicyGroupFromDomains_associateDomainAndPolicy_assertAssociationRemoved() {
        Domain domain = new Domain();
        domain.setDomainName("Test Domain");
        this.dmDao.add(domain);
        CertPolicyGroup group = new CertPolicyGroup();
        group.setPolicyGroupName("Test Group");
        this.polDao.addPolicyGroup(group);
        this.polDao.associatePolicyGroupToDomain(domain.getId().longValue(), group.getId());
        Collection reltn = this.polDao.getPolicyGroupsByDomain(domain.getId().longValue());
        Assert.assertEquals((long)1L, (long)reltn.size());
        this.polDao.disassociatePolicyGroupFromDomains(group.getId());
        reltn = this.polDao.getPolicyGroupsByDomain(domain.getId().longValue());
        Assert.assertEquals((long)0L, (long)reltn.size());
    }

    @Test
    public void testDisassociatePolicyGroupFromDomains_unknownPolicy_assertException() {
        Domain domain = new Domain();
        domain.setDomainName("Test Domain");
        this.dmDao.add(domain);
        CertPolicyGroup group = new CertPolicyGroup();
        group.setPolicyGroupName("Test Group");
        this.polDao.addPolicyGroup(group);
        this.polDao.associatePolicyGroupToDomain(domain.getId().longValue(), group.getId());
        Collection reltn = this.polDao.getPolicyGroupsByDomain(domain.getId().longValue());
        Assert.assertEquals((long)1L, (long)reltn.size());
        boolean exceptionOccured = false;
        try {
            this.polDao.disassociatePolicyGroupFromDomains(746263L);
        }
        catch (ConfigurationStoreException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testDisassociatePolicyGroupFromDomains_noEntityManager_assertException() {
        CertPolicyDaoImpl dao = new CertPolicyDaoImpl();
        boolean exceptionOccured = false;
        try {
            dao.disassociatePolicyGroupFromDomains(1234L);
        }
        catch (IllegalStateException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testDisassociatePolicyGroupFromDomains_unknownErrorInRemove_assertException() {
        boolean exceptionOccured = false;
        EntityManager mgr = (EntityManager)Mockito.mock(EntityManager.class);
        Domain domain = (Domain)Mockito.mock(Domain.class);
        DomainDao domainDao = (DomainDao)Mockito.mock(DomainDao.class);
        Mockito.when((Object)domainDao.getDomain(new Long(1234L))).thenReturn((Object)domain);
        Query deleteQuery = (Query)Mockito.mock(Query.class);
        ((Query)Mockito.doThrow((Throwable)new RuntimeException("Just Passing Through")).when((Object)deleteQuery)).executeUpdate();
        Mockito.when((Object)mgr.createQuery("DELETE from CertPolicyGroupDomainReltn cpr where cpr.certPolicyGroup  = ?1")).thenReturn((Object)deleteQuery);
        CertPolicyGroup group = (CertPolicyGroup)Mockito.mock(CertPolicyGroup.class);
        Query query = (Query)Mockito.mock(Query.class);
        Mockito.when((Object)query.getSingleResult()).thenReturn((Object)group);
        Mockito.when((Object)mgr.createQuery("SELECT cpg from CertPolicyGroup cpg WHERE cpg.id = ?1")).thenReturn((Object)query);
        CertPolicyDaoImpl dao = new CertPolicyDaoImpl();
        dao.setDomainDao(domainDao);
        dao.setEntityManager(mgr);
        CertPolicyDaoImpl spyDao = (CertPolicyDaoImpl)Mockito.spy((Object)dao);
        try {
            spyDao.disassociatePolicyGroupFromDomains(1234L);
        }
        catch (ConfigurationStoreException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        ((Query)Mockito.verify((Object)query, (VerificationMode)Mockito.times((int)1))).getSingleResult();
        ((Query)Mockito.verify((Object)deleteQuery, (VerificationMode)Mockito.times((int)1))).executeUpdate();
    }
}

