/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import javax.persistence.EntityManager;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.nhindirect.config.store.CertPolicy;
import org.nhindirect.config.store.CertPolicyDaoBaseTest;
import org.nhindirect.config.store.ConfigurationStoreException;
import org.nhindirect.config.store.dao.impl.CertPolicyDaoImpl;
import org.nhindirect.policy.PolicyLexicon;

public class CertPolicyDaoImpl_getPoliciesTest
extends CertPolicyDaoBaseTest {
    @Test
    public void testGetPolicies_emptyPolicyStore_assertNoPoliciesRetrieved() {
        Collection policies = this.polDao.getPolicies();
        Assert.assertTrue((boolean)policies.isEmpty());
    }

    @Test
    public void testGetPolicies_singleEntryInPolicyStore_assertPoliciesRetrieved() {
        Calendar now = Calendar.getInstance(Locale.getDefault());
        CertPolicy policy = new CertPolicy();
        policy.setPolicyName("Test Policy");
        policy.setLexicon(PolicyLexicon.XML);
        policy.setPolicyData(new byte[]{1, 2, 3});
        this.polDao.addPolicy(policy);
        Collection policies = this.polDao.getPolicies();
        Assert.assertEquals((long)1L, (long)policies.size());
        CertPolicy addedPolicy = (CertPolicy)policies.iterator().next();
        Assert.assertEquals((Object)"Test Policy", (Object)addedPolicy.getPolicyName());
        Assert.assertEquals((Object)PolicyLexicon.XML, (Object)addedPolicy.getLexicon());
        Assert.assertTrue((now.getTimeInMillis() <= addedPolicy.getCreateTime().getTimeInMillis() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{1, 2, 3}, addedPolicy.getPolicyData()));
    }

    @Test
    public void testGetPolicies_multipeEntriesInPolicyStore_assertPoliciesRetrieved() {
        Calendar now = Calendar.getInstance(Locale.getDefault());
        CertPolicy policy1 = new CertPolicy();
        policy1.setPolicyName("Test Policy1");
        policy1.setLexicon(PolicyLexicon.XML);
        policy1.setPolicyData(new byte[]{1, 2, 3});
        this.polDao.addPolicy(policy1);
        CertPolicy policy2 = new CertPolicy();
        policy2.setPolicyName("Test Policy2");
        policy2.setLexicon(PolicyLexicon.JAVA_SER);
        policy2.setPolicyData(new byte[]{4, 5, 6});
        this.polDao.addPolicy(policy2);
        Collection policies = this.polDao.getPolicies();
        Assert.assertEquals((long)2L, (long)policies.size());
        Iterator iter = policies.iterator();
        CertPolicy addedPolicy = (CertPolicy)iter.next();
        Assert.assertEquals((Object)policy1.getPolicyName(), (Object)addedPolicy.getPolicyName());
        Assert.assertEquals((Object)policy1.getLexicon(), (Object)addedPolicy.getLexicon());
        Assert.assertTrue((now.getTimeInMillis() <= addedPolicy.getCreateTime().getTimeInMillis() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Arrays.equals(policy1.getPolicyData(), addedPolicy.getPolicyData()));
        addedPolicy = (CertPolicy)iter.next();
        Assert.assertEquals((Object)policy2.getPolicyName(), (Object)addedPolicy.getPolicyName());
        Assert.assertEquals((Object)policy2.getLexicon(), (Object)addedPolicy.getLexicon());
        Assert.assertTrue((now.getTimeInMillis() <= addedPolicy.getCreateTime().getTimeInMillis() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Arrays.equals(policy2.getPolicyData(), addedPolicy.getPolicyData()));
    }

    @Test
    public void testGetPolices_exceptionInQuery_assertException() {
        EntityManager manager = (EntityManager)Mockito.mock(EntityManager.class);
        ((EntityManager)Mockito.doThrow((Throwable)new RuntimeException("Just Passing Through")).when((Object)manager)).createQuery((String)Matchers.any());
        CertPolicyDaoImpl dao = new CertPolicyDaoImpl();
        dao.setEntityManager(manager);
        boolean exceptionOccured = false;
        try {
            dao.getPolicies();
        }
        catch (ConfigurationStoreException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testGetPolices_noEntityManager_assertException() {
        CertPolicyDaoImpl dao = new CertPolicyDaoImpl();
        boolean exceptionOccured = false;
        try {
            dao.getPolicies();
        }
        catch (IllegalStateException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }
}

