/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;
import javax.persistence.EntityManager;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.nhindirect.config.store.CertPolicy;
import org.nhindirect.config.store.CertPolicyDaoBaseTest;
import org.nhindirect.config.store.ConfigurationStoreException;
import org.nhindirect.config.store.dao.impl.CertPolicyDaoImpl;
import org.nhindirect.policy.PolicyLexicon;

public class CertPolicyDaoImpl_getPolicyByNameTest
extends CertPolicyDaoBaseTest {
    @Test
    public void testGetPolicyByName_emptyStore_assertNoPolicyReturned() {
        Assert.assertNull((Object)this.polDao.getPolicyByName("Test Policy"));
    }

    @Test
    public void testGetPolicyByName_singlePolicyInStore_nameNotInStore_assertNoPolicyReturned() {
        CertPolicy policy = new CertPolicy();
        policy.setPolicyName("Test Policy");
        policy.setLexicon(PolicyLexicon.XML);
        policy.setPolicyData(new byte[]{1, 2, 3});
        this.polDao.addPolicy(policy);
        Assert.assertNull((Object)this.polDao.getPolicyByName("Test Policy X"));
    }

    @Test
    public void testGetPolicyByName_singlePolicyInStore_assertPolicyReturned() {
        Calendar now = Calendar.getInstance(Locale.getDefault());
        CertPolicy policy = new CertPolicy();
        policy.setPolicyName("Test PolicY");
        policy.setLexicon(PolicyLexicon.XML);
        policy.setPolicyData(new byte[]{1, 2, 3});
        this.polDao.addPolicy(policy);
        CertPolicy addedPolicy = this.polDao.getPolicyByName("Test PolicY");
        Assert.assertEquals((Object)policy.getPolicyName(), (Object)addedPolicy.getPolicyName());
        Assert.assertEquals((Object)policy.getLexicon(), (Object)addedPolicy.getLexicon());
        Assert.assertTrue((now.getTimeInMillis() <= addedPolicy.getCreateTime().getTimeInMillis() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Arrays.equals(policy.getPolicyData(), addedPolicy.getPolicyData()));
    }

    @Test
    public void testGetPolicyByName_exceptionInQuery_assertException() {
        EntityManager manager = (EntityManager)Mockito.mock(EntityManager.class);
        ((EntityManager)Mockito.doThrow((Throwable)new RuntimeException("Just Passing Through")).when((Object)manager)).createQuery((String)Matchers.any());
        CertPolicyDaoImpl dao = new CertPolicyDaoImpl();
        dao.setEntityManager(manager);
        boolean exceptionOccured = false;
        try {
            dao.getPolicyByName("any");
        }
        catch (ConfigurationStoreException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testGetPolicyByName_noEntityManager_assertException() {
        CertPolicyDaoImpl dao = new CertPolicyDaoImpl();
        boolean exceptionOccured = false;
        try {
            dao.getPolicyByName("any");
        }
        catch (IllegalStateException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }
}

