/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.util.Calendar;
import java.util.Locale;
import javax.persistence.EntityManager;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.nhindirect.config.store.CertPolicyDaoBaseTest;
import org.nhindirect.config.store.CertPolicyGroup;
import org.nhindirect.config.store.ConfigurationStoreException;
import org.nhindirect.config.store.dao.impl.CertPolicyDaoImpl;

public class CertPolicyDaoImpl_getPolicyGroupByIdTest
extends CertPolicyDaoBaseTest {
    @Test
    public void testGetPolicyGroupById_emptyStore_assertNoPolicyGroupReturned() {
        Assert.assertNull((Object)this.polDao.getPolicyGroupById(1234L));
    }

    @Test
    public void testGetPolicyGroupById_singlePolicyGroupInStore_idNotInStore_assertNoPolicyGroupReturned() {
        CertPolicyGroup group = new CertPolicyGroup();
        group.setPolicyGroupName("Test Group");
        this.polDao.addPolicyGroup(group);
        Assert.assertNull((Object)this.polDao.getPolicyGroupById(1234L));
    }

    @Test
    public void testGetPolicyGroupById_singlePolicyGroupInStore_assertPolicyGroupReturned() {
        Calendar now = Calendar.getInstance(Locale.getDefault());
        CertPolicyGroup group = new CertPolicyGroup();
        group.setPolicyGroupName("Test Group");
        this.polDao.addPolicyGroup(group);
        CertPolicyGroup addedGroup = this.polDao.getPolicyGroupById(group.getId());
        Assert.assertEquals((Object)group.getPolicyGroupName(), (Object)addedGroup.getPolicyGroupName());
        Assert.assertTrue((now.getTimeInMillis() <= addedGroup.getCreateTime().getTimeInMillis() ? 1 : 0) != 0);
    }

    @Test
    public void testGetPolicyGroupById_exceptionInQuery_assertException() {
        EntityManager manager = (EntityManager)Mockito.mock(EntityManager.class);
        ((EntityManager)Mockito.doThrow((Throwable)new RuntimeException("Just Passing Through")).when((Object)manager)).createQuery((String)Matchers.any());
        CertPolicyDaoImpl dao = new CertPolicyDaoImpl();
        dao.setEntityManager(manager);
        boolean exceptionOccured = false;
        try {
            dao.getPolicyGroupById(1234L);
        }
        catch (ConfigurationStoreException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testGetPolicyGroupById_noEntityManager_assertException() {
        CertPolicyDaoImpl dao = new CertPolicyDaoImpl();
        boolean exceptionOccured = false;
        try {
            dao.getPolicyGroupById(1234L);
        }
        catch (IllegalStateException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }
}

