/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.util.Collection;
import java.util.Iterator;
import javax.persistence.EntityManager;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.nhindirect.config.store.CertPolicyDaoBaseTest;
import org.nhindirect.config.store.CertPolicyGroup;
import org.nhindirect.config.store.CertPolicyGroupDomainReltn;
import org.nhindirect.config.store.ConfigurationStoreException;
import org.nhindirect.config.store.Domain;
import org.nhindirect.config.store.dao.impl.CertPolicyDaoImpl;

public class CertPolicyDaoImpl_getPolicyGroupDomainReltnsTest
extends CertPolicyDaoBaseTest {
    @Test
    public void testGetPolicyGroupsDomainReltns_emptyReltnStore_assertNoReltnsRetrieved() {
        Collection groups = this.polDao.getPolicyGroupDomainReltns();
        Assert.assertTrue((boolean)groups.isEmpty());
    }

    @Test
    public void testGetPolicyGroupsDomainReltns_singleEntryInReltns_assertReltnRetrieved() {
        Domain domain = new Domain();
        domain.setDomainName("Test Domain");
        this.dmDao.add(domain);
        CertPolicyGroup group = new CertPolicyGroup();
        group.setPolicyGroupName("Test Group");
        this.polDao.addPolicyGroup(group);
        this.polDao.associatePolicyGroupToDomain(domain.getId().longValue(), group.getId());
        Collection reltns = this.polDao.getPolicyGroupDomainReltns();
        Assert.assertEquals((long)1L, (long)reltns.size());
        CertPolicyGroupDomainReltn reltn = (CertPolicyGroupDomainReltn)reltns.iterator().next();
        Assert.assertEquals((Object)group, (Object)reltn.getCertPolicyGroup());
        Assert.assertEquals((Object)domain, (Object)reltn.getDomain());
    }

    @Test
    public void testGetPolicyGroupsDomainReltns_multipeEntriesReltns_assertReltnsRetrieved() {
        Domain domain = new Domain();
        domain.setDomainName("Test Domain");
        this.dmDao.add(domain);
        CertPolicyGroup group1 = new CertPolicyGroup();
        group1.setPolicyGroupName("Test Group 1");
        CertPolicyGroup group2 = new CertPolicyGroup();
        group2.setPolicyGroupName("Test Group 2");
        this.polDao.addPolicyGroup(group1);
        this.polDao.addPolicyGroup(group2);
        this.polDao.associatePolicyGroupToDomain(domain.getId().longValue(), group1.getId());
        this.polDao.associatePolicyGroupToDomain(domain.getId().longValue(), group2.getId());
        Collection reltns = this.polDao.getPolicyGroupDomainReltns();
        Assert.assertEquals((long)2L, (long)reltns.size());
        Iterator iter = reltns.iterator();
        CertPolicyGroupDomainReltn reltn = (CertPolicyGroupDomainReltn)iter.next();
        Assert.assertEquals((Object)group1, (Object)reltn.getCertPolicyGroup());
        Assert.assertEquals((Object)domain, (Object)reltn.getDomain());
        reltn = (CertPolicyGroupDomainReltn)iter.next();
        Assert.assertEquals((Object)group2, (Object)reltn.getCertPolicyGroup());
        Assert.assertEquals((Object)domain, (Object)reltn.getDomain());
    }

    @Test
    public void testGetPolicyGroups_exceptionInQuery_assertException() {
        EntityManager manager = (EntityManager)Mockito.mock(EntityManager.class);
        ((EntityManager)Mockito.doThrow((Throwable)new RuntimeException("Just Passing Through")).when((Object)manager)).createQuery((String)Matchers.any());
        CertPolicyDaoImpl dao = new CertPolicyDaoImpl();
        dao.setEntityManager(manager);
        boolean exceptionOccured = false;
        try {
            dao.getPolicyGroupDomainReltns();
        }
        catch (ConfigurationStoreException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testGetPolicyGroups_noEntityManager_assertException() {
        CertPolicyDaoImpl dao = new CertPolicyDaoImpl();
        boolean exceptionOccured = false;
        try {
            dao.getPolicyGroupDomainReltns();
        }
        catch (IllegalStateException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }
}

