/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import javax.persistence.EntityManager;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.nhindirect.config.store.CertPolicyDaoBaseTest;
import org.nhindirect.config.store.CertPolicyGroup;
import org.nhindirect.config.store.ConfigurationStoreException;
import org.nhindirect.config.store.dao.impl.CertPolicyDaoImpl;

public class CertPolicyDaoImpl_getPolicyGroupsTest
extends CertPolicyDaoBaseTest {
    @Test
    public void testGetPolicies_emptyPolicyGroupStore_assertNoPolicGroupsRetrieved() {
        Collection groups = this.polDao.getPolicyGroups();
        Assert.assertTrue((boolean)groups.isEmpty());
    }

    @Test
    public void testGetPolicies_singleEntryInPolicyGroupStore_assertPolicyGroupRetrieved() {
        Calendar now = Calendar.getInstance(Locale.getDefault());
        CertPolicyGroup group = new CertPolicyGroup();
        group.setPolicyGroupName("Test Group");
        this.polDao.addPolicyGroup(group);
        Collection groups = this.polDao.getPolicyGroups();
        Assert.assertEquals((long)1L, (long)groups.size());
        CertPolicyGroup addedGroup = (CertPolicyGroup)groups.iterator().next();
        Assert.assertEquals((Object)group.getPolicyGroupName(), (Object)addedGroup.getPolicyGroupName());
        Assert.assertTrue((now.getTimeInMillis() <= addedGroup.getCreateTime().getTimeInMillis() ? 1 : 0) != 0);
    }

    @Test
    public void testGetPolicies_multipeEntriesInPolicyGroupStore_assertPolicyGroupsRetrieved() {
        Calendar now = Calendar.getInstance(Locale.getDefault());
        CertPolicyGroup group1 = new CertPolicyGroup();
        group1.setPolicyGroupName("Test Group1");
        this.polDao.addPolicyGroup(group1);
        CertPolicyGroup group2 = new CertPolicyGroup();
        group2.setPolicyGroupName("Test Group2");
        this.polDao.addPolicyGroup(group2);
        Collection groups = this.polDao.getPolicyGroups();
        Assert.assertEquals((long)2L, (long)groups.size());
        Iterator iter = groups.iterator();
        CertPolicyGroup addedGroup = (CertPolicyGroup)iter.next();
        Assert.assertEquals((Object)group1.getPolicyGroupName(), (Object)addedGroup.getPolicyGroupName());
        Assert.assertTrue((now.getTimeInMillis() <= addedGroup.getCreateTime().getTimeInMillis() ? 1 : 0) != 0);
        addedGroup = (CertPolicyGroup)iter.next();
        Assert.assertEquals((Object)group2.getPolicyGroupName(), (Object)addedGroup.getPolicyGroupName());
        Assert.assertTrue((now.getTimeInMillis() <= addedGroup.getCreateTime().getTimeInMillis() ? 1 : 0) != 0);
    }

    @Test
    public void testGetPolicyGroups_exceptionInQuery_assertException() {
        EntityManager manager = (EntityManager)Mockito.mock(EntityManager.class);
        ((EntityManager)Mockito.doThrow((Throwable)new RuntimeException("Just Passing Through")).when((Object)manager)).createQuery((String)Matchers.any());
        CertPolicyDaoImpl dao = new CertPolicyDaoImpl();
        dao.setEntityManager(manager);
        boolean exceptionOccured = false;
        try {
            dao.getPolicyGroups();
        }
        catch (ConfigurationStoreException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testGetPolicyGroups_noEntityManager_assertException() {
        CertPolicyDaoImpl dao = new CertPolicyDaoImpl();
        boolean exceptionOccured = false;
        try {
            dao.getPolicyGroups();
        }
        catch (IllegalStateException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }
}

