/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import javax.persistence.EntityManager;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.nhindirect.config.store.CertPolicy;
import org.nhindirect.config.store.CertPolicyDaoBaseTest;
import org.nhindirect.config.store.CertPolicyGroup;
import org.nhindirect.config.store.CertPolicyGroupReltn;
import org.nhindirect.config.store.CertPolicyUse;
import org.nhindirect.config.store.ConfigurationStoreException;
import org.nhindirect.config.store.dao.impl.CertPolicyDaoImpl;
import org.nhindirect.policy.PolicyLexicon;

public class CertPolicyDaoImpl_removePolicyUseFromGroupTest
extends CertPolicyDaoBaseTest {
    @Test
    public void testRemovePolicyFromGroup_addedPolicyToGroup_assertAssociationRemoved() {
        CertPolicyGroup group = new CertPolicyGroup();
        group.setPolicyGroupName("Test Group");
        this.polDao.addPolicyGroup(group);
        CertPolicy policy = new CertPolicy();
        policy.setPolicyName("Test PolicY");
        policy.setLexicon(PolicyLexicon.XML);
        policy.setPolicyData(new byte[]{1, 2, 3});
        this.polDao.addPolicy(policy);
        this.polDao.addPolicyUseToGroup(group.getId(), policy.getId(), CertPolicyUse.PUBLIC_RESOLVER, true, false);
        CertPolicyGroup assocGroup = this.polDao.getPolicyGroupById(group.getId());
        Assert.assertEquals((long)1L, (long)assocGroup.getCertPolicyGroupReltn().size());
        this.polDao.removePolicyUseFromGroup(((CertPolicyGroupReltn)group.getCertPolicyGroupReltn().iterator().next()).getId());
    }

    @Test
    public void testRemovePolicyFromGroup_noEntityManager_assertException() {
        CertPolicyDaoImpl certDao = new CertPolicyDaoImpl();
        boolean exceptionOccured = false;
        try {
            certDao.removePolicyUseFromGroup(1234L);
        }
        catch (IllegalStateException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testRemovePolicyFromGroup_errorInQuery_assertException() {
        EntityManager manager = (EntityManager)Mockito.mock(EntityManager.class);
        ((EntityManager)Mockito.doThrow((Throwable)new RuntimeException("Just Passing Through")).when((Object)manager)).createQuery("SELECT cpr from CertPolicyGroupReltn cpr WHERE cpr.id = ?1");
        CertPolicyDaoImpl dao = new CertPolicyDaoImpl();
        dao.setEntityManager(manager);
        boolean exceptionOccured = false;
        try {
            dao.removePolicyUseFromGroup(1234L);
        }
        catch (ConfigurationStoreException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }
}

