/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import javax.persistence.EntityManager;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.nhindirect.config.store.CertPolicyDaoBaseTest;
import org.nhindirect.config.store.CertPolicyGroup;
import org.nhindirect.config.store.ConfigurationStoreException;
import org.nhindirect.config.store.dao.impl.CertPolicyDaoImpl;

public class CertPolicyDaoImpl_updateGroupAttributesTest
extends CertPolicyDaoBaseTest {
    @Test
    public void testUpdateGroupAttributes_updateName_assertUpdated() {
        CertPolicyGroup group = new CertPolicyGroup();
        group.setPolicyGroupName("Test Group");
        this.polDao.addPolicyGroup(group);
        CertPolicyGroup addedGroup = this.polDao.getPolicyGroupById(group.getId());
        Assert.assertNotNull((Object)addedGroup);
        this.polDao.updateGroupAttributes(group.getId(), "Test Group 2");
        CertPolicyGroup updatedGroup = this.polDao.getPolicyGroupById(group.getId());
        Assert.assertEquals((Object)"Test Group 2", (Object)updatedGroup.getPolicyGroupName());
    }

    @Test
    public void testUpdateGroupAttributes_updateName_nullName_assertNotUpdated() {
        CertPolicyGroup group = new CertPolicyGroup();
        group.setPolicyGroupName("Test Group");
        this.polDao.addPolicyGroup(group);
        CertPolicyGroup addedGroup = this.polDao.getPolicyGroupById(group.getId());
        Assert.assertNotNull((Object)addedGroup);
        this.polDao.updateGroupAttributes(group.getId(), null);
        CertPolicyGroup updatedGroup = this.polDao.getPolicyGroupById(group.getId());
        Assert.assertEquals((Object)group.getPolicyGroupName(), (Object)updatedGroup.getPolicyGroupName());
    }

    @Test
    public void testUpdateGroupAttributes_updateName_emptyName_assertNotUpdated() {
        CertPolicyGroup group = new CertPolicyGroup();
        group.setPolicyGroupName("Test Group");
        this.polDao.addPolicyGroup(group);
        CertPolicyGroup addedGroup = this.polDao.getPolicyGroupById(group.getId());
        Assert.assertNotNull((Object)addedGroup);
        this.polDao.updateGroupAttributes(group.getId(), "");
        CertPolicyGroup updatedGroup = this.polDao.getPolicyGroupById(group.getId());
        Assert.assertEquals((Object)group.getPolicyGroupName(), (Object)updatedGroup.getPolicyGroupName());
    }

    @Test
    public void testUpdateGroupAttributes_policyGroupDoesntExist_assertException() throws Exception {
        boolean exceptionOccured = false;
        try {
            this.polDao.updateGroupAttributes(12345L, "");
        }
        catch (ConfigurationStoreException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testUpdateGroupAttributes_exceptionInQuery_assertException() throws Exception {
        EntityManager manager = (EntityManager)Mockito.mock(EntityManager.class);
        ((EntityManager)Mockito.doThrow((Throwable)new RuntimeException("Just Passing Through")).when((Object)manager)).createQuery((String)Matchers.any());
        CertPolicyDaoImpl dao = new CertPolicyDaoImpl();
        dao.setEntityManager(manager);
        boolean exceptionOccured = false;
        try {
            dao.updateGroupAttributes(12345L, "");
        }
        catch (ConfigurationStoreException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void ttestUpdateGroupAttributes_noEntityManager_assertException() throws Exception {
        CertPolicyDaoImpl dao = new CertPolicyDaoImpl();
        boolean exceptionOccured = false;
        try {
            dao.updateGroupAttributes(12345L, "");
        }
        catch (IllegalStateException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }
}

