/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.util.Arrays;
import javax.persistence.EntityManager;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.nhindirect.config.store.CertPolicy;
import org.nhindirect.config.store.CertPolicyDaoBaseTest;
import org.nhindirect.config.store.ConfigurationStoreException;
import org.nhindirect.config.store.dao.impl.CertPolicyDaoImpl;
import org.nhindirect.policy.PolicyLexicon;

public class CertPolicyDaoImpl_updatePolicyAttributesTest
extends CertPolicyDaoBaseTest {
    @Test
    public void testUpdatePolicyAttributes_updateName_assertUpdated() {
        CertPolicy policy = new CertPolicy();
        policy.setPolicyName("Test PolicY");
        policy.setLexicon(PolicyLexicon.XML);
        policy.setPolicyData(new byte[]{1, 2, 3});
        this.polDao.addPolicy(policy);
        CertPolicy addedPolicy = this.polDao.getPolicyById(policy.getId());
        Assert.assertNotNull((Object)addedPolicy);
        this.polDao.updatePolicyAttributes(policy.getId(), "Test Pol", policy.getLexicon(), policy.getPolicyData());
        CertPolicy updatedPolicy = this.polDao.getPolicyById(policy.getId());
        Assert.assertEquals((Object)"Test Pol", (Object)updatedPolicy.getPolicyName());
        Assert.assertEquals((Object)policy.getLexicon(), (Object)updatedPolicy.getLexicon());
        Assert.assertTrue((boolean)Arrays.equals(policy.getPolicyData(), updatedPolicy.getPolicyData()));
    }

    @Test
    public void testUpdatePolicyAttributes_updateName_nullName_assertNotUpdated() {
        CertPolicy policy = new CertPolicy();
        policy.setPolicyName("Test PolicY");
        policy.setLexicon(PolicyLexicon.XML);
        policy.setPolicyData(new byte[]{1, 2, 3});
        this.polDao.addPolicy(policy);
        CertPolicy addedPolicy = this.polDao.getPolicyById(policy.getId());
        Assert.assertNotNull((Object)addedPolicy);
        this.polDao.updatePolicyAttributes(policy.getId(), null, policy.getLexicon(), policy.getPolicyData());
        CertPolicy updatedPolicy = this.polDao.getPolicyById(policy.getId());
        Assert.assertEquals((Object)policy.getPolicyName(), (Object)updatedPolicy.getPolicyName());
        Assert.assertEquals((Object)policy.getLexicon(), (Object)updatedPolicy.getLexicon());
        Assert.assertTrue((boolean)Arrays.equals(policy.getPolicyData(), updatedPolicy.getPolicyData()));
    }

    @Test
    public void testUpdatePolicyAttributes_updateName_emptyName_assertNotUpdated() {
        CertPolicy policy = new CertPolicy();
        policy.setPolicyName("Test PolicY");
        policy.setLexicon(PolicyLexicon.XML);
        policy.setPolicyData(new byte[]{1, 2, 3});
        this.polDao.addPolicy(policy);
        CertPolicy addedPolicy = this.polDao.getPolicyById(policy.getId());
        Assert.assertNotNull((Object)addedPolicy);
        this.polDao.updatePolicyAttributes(policy.getId(), "", policy.getLexicon(), policy.getPolicyData());
        CertPolicy updatedPolicy = this.polDao.getPolicyById(policy.getId());
        Assert.assertEquals((Object)policy.getPolicyName(), (Object)updatedPolicy.getPolicyName());
        Assert.assertEquals((Object)policy.getLexicon(), (Object)updatedPolicy.getLexicon());
        Assert.assertTrue((boolean)Arrays.equals(policy.getPolicyData(), updatedPolicy.getPolicyData()));
    }

    @Test
    public void testUpdatePolicyAttributes_updateData_assertUpdated() {
        CertPolicy policy = new CertPolicy();
        policy.setPolicyName("Test PolicY");
        policy.setLexicon(PolicyLexicon.XML);
        policy.setPolicyData(new byte[]{1, 2, 3});
        this.polDao.addPolicy(policy);
        CertPolicy addedPolicy = this.polDao.getPolicyById(policy.getId());
        Assert.assertNotNull((Object)addedPolicy);
        this.polDao.updatePolicyAttributes(policy.getId(), policy.getPolicyName(), policy.getLexicon(), new byte[]{4, 5, 6});
        CertPolicy updatedPolicy = this.polDao.getPolicyById(policy.getId());
        Assert.assertEquals((Object)policy.getPolicyName(), (Object)updatedPolicy.getPolicyName());
        Assert.assertEquals((Object)policy.getLexicon(), (Object)updatedPolicy.getLexicon());
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{4, 5, 6}, updatedPolicy.getPolicyData()));
    }

    @Test
    public void testUpdatePolicyAttributes_updateData_nullData_assertNotUpdated() {
        CertPolicy policy = new CertPolicy();
        policy.setPolicyName("Test PolicY");
        policy.setLexicon(PolicyLexicon.XML);
        policy.setPolicyData(new byte[]{1, 2, 3});
        this.polDao.addPolicy(policy);
        CertPolicy addedPolicy = this.polDao.getPolicyById(policy.getId());
        Assert.assertNotNull((Object)addedPolicy);
        this.polDao.updatePolicyAttributes(policy.getId(), policy.getPolicyName(), policy.getLexicon(), null);
        CertPolicy updatedPolicy = this.polDao.getPolicyById(policy.getId());
        Assert.assertEquals((Object)policy.getPolicyName(), (Object)updatedPolicy.getPolicyName());
        Assert.assertEquals((Object)policy.getLexicon(), (Object)updatedPolicy.getLexicon());
        Assert.assertTrue((boolean)Arrays.equals(policy.getPolicyData(), updatedPolicy.getPolicyData()));
    }

    @Test
    public void testUpdatePolicyAttributes_updateData_emptyData_assertNotUpdated() {
        CertPolicy policy = new CertPolicy();
        policy.setPolicyName("Test PolicY");
        policy.setLexicon(PolicyLexicon.XML);
        policy.setPolicyData(new byte[]{1, 2, 3});
        this.polDao.addPolicy(policy);
        CertPolicy addedPolicy = this.polDao.getPolicyById(policy.getId());
        Assert.assertNotNull((Object)addedPolicy);
        this.polDao.updatePolicyAttributes(policy.getId(), policy.getPolicyName(), policy.getLexicon(), new byte[0]);
        CertPolicy updatedPolicy = this.polDao.getPolicyById(policy.getId());
        Assert.assertEquals((Object)policy.getPolicyName(), (Object)updatedPolicy.getPolicyName());
        Assert.assertEquals((Object)policy.getLexicon(), (Object)updatedPolicy.getLexicon());
        Assert.assertTrue((boolean)Arrays.equals(policy.getPolicyData(), updatedPolicy.getPolicyData()));
    }

    @Test
    public void testUpdatePolicyAttributes_updateLexicon_assertUpdated() {
        CertPolicy policy = new CertPolicy();
        policy.setPolicyName("Test PolicY");
        policy.setLexicon(PolicyLexicon.XML);
        policy.setPolicyData(new byte[]{1, 2, 3});
        this.polDao.addPolicy(policy);
        CertPolicy addedPolicy = this.polDao.getPolicyById(policy.getId());
        Assert.assertNotNull((Object)addedPolicy);
        this.polDao.updatePolicyAttributes(policy.getId(), policy.getPolicyName(), PolicyLexicon.JAVA_SER, policy.getPolicyData());
        CertPolicy updatedPolicy = this.polDao.getPolicyById(policy.getId());
        Assert.assertEquals((Object)policy.getPolicyName(), (Object)updatedPolicy.getPolicyName());
        Assert.assertEquals((Object)PolicyLexicon.JAVA_SER, (Object)updatedPolicy.getLexicon());
        Assert.assertTrue((boolean)Arrays.equals(policy.getPolicyData(), updatedPolicy.getPolicyData()));
    }

    @Test
    public void testUpdatePolicyAttributes_updateLexicon_nullLexicon_assertNotUpdated() {
        CertPolicy policy = new CertPolicy();
        policy.setPolicyName("Test PolicY");
        policy.setLexicon(PolicyLexicon.XML);
        policy.setPolicyData(new byte[]{1, 2, 3});
        this.polDao.addPolicy(policy);
        CertPolicy addedPolicy = this.polDao.getPolicyById(policy.getId());
        Assert.assertNotNull((Object)addedPolicy);
        this.polDao.updatePolicyAttributes(policy.getId(), policy.getPolicyName(), null, policy.getPolicyData());
        CertPolicy updatedPolicy = this.polDao.getPolicyById(policy.getId());
        Assert.assertEquals((Object)policy.getPolicyName(), (Object)updatedPolicy.getPolicyName());
        Assert.assertEquals((Object)policy.getLexicon(), (Object)updatedPolicy.getLexicon());
        Assert.assertTrue((boolean)Arrays.equals(policy.getPolicyData(), updatedPolicy.getPolicyData()));
    }

    @Test
    public void testUpdatePolicyAttributes_policyDoesntExist_assertException() throws Exception {
        boolean exceptionOccured = false;
        try {
            this.polDao.updatePolicyAttributes(12345L, "", null, null);
        }
        catch (ConfigurationStoreException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testUpdatePolicyAttributes_exceptionInQuery_assertException() throws Exception {
        EntityManager manager = (EntityManager)Mockito.mock(EntityManager.class);
        ((EntityManager)Mockito.doThrow((Throwable)new RuntimeException("Just Passing Through")).when((Object)manager)).createQuery((String)Matchers.any());
        CertPolicyDaoImpl dao = new CertPolicyDaoImpl();
        dao.setEntityManager(manager);
        boolean exceptionOccured = false;
        try {
            dao.updatePolicyAttributes(12345L, "", null, null);
        }
        catch (ConfigurationStoreException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void ttestUpdatePolicyAttributes_noEntityManager_assertException() throws Exception {
        CertPolicyDaoImpl dao = new CertPolicyDaoImpl();
        boolean exceptionOccured = false;
        try {
            dao.updatePolicyAttributes(12345L, "", null, null);
        }
        catch (IllegalStateException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }
}

