/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.io.File;
import javax.persistence.EntityManager;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.nhindirect.common.crypto.KeyStoreProtectionManager;
import org.nhindirect.common.crypto.impl.BootstrappedKeyStoreProtectionManager;
import org.nhindirect.config.model.exceptions.CertificateConversionException;
import org.nhindirect.config.model.utils.CertUtils;
import org.nhindirect.config.store.Certificate;
import org.nhindirect.config.store.CertificateDaoTest;
import org.nhindirect.config.store.dao.impl.CertificateDaoImpl;

public class CertificateDaoImp_saveWithProtectionMgr {
    private Certificate persistedCert;
    private static final String certBasePath = "src/test/resources/certs/";

    private static byte[] loadCertificateData(String certFileName) throws Exception {
        File fl = new File(certBasePath + certFileName);
        return FileUtils.readFileToByteArray((File)fl);
    }

    protected Certificate populateCert(String certFile, String keyFile) throws Exception {
        byte[] certData = keyFile != null && !keyFile.isEmpty() ? CertificateDaoTest.loadPkcs12FromCertAndKey(certFile, keyFile) : CertificateDaoImp_saveWithProtectionMgr.loadCertificateData(certFile);
        Certificate cert = new Certificate();
        cert.setData(certData);
        cert.setOwner("gm2552@cerner.com");
        return cert;
    }

    @Test
    public void testStripP12ProtectionTest_NoP12ProtectionWithManager_assertP12Returned() throws Exception {
        EntityManager manager = (EntityManager)Mockito.mock(EntityManager.class);
        ((EntityManager)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) {
                CertificateDaoImp_saveWithProtectionMgr.this.persistedCert = (Certificate)invocation.getArguments()[0];
                return "";
            }
        }).when((Object)manager)).persist(Matchers.any());
        BootstrappedKeyStoreProtectionManager mgr = new BootstrappedKeyStoreProtectionManager();
        mgr.setKeyStoreProtectionKey("12345");
        mgr.setPrivateKeyProtectionKey("67890");
        CertificateDaoImpl daoImpl = new CertificateDaoImpl();
        daoImpl.setKeyStoreProtectionManager((KeyStoreProtectionManager)mgr);
        daoImpl.setEntityManager(manager);
        daoImpl.save(this.populateCert("gm2552.der", "gm2552Key.der"));
        assert (this.persistedCert.getData() != null);
        boolean exceptionOccured = false;
        try {
            CertUtils.toCertContainer((byte[])this.persistedCert.getData());
        }
        catch (CertificateConversionException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }
}

