/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.io.File;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nhindirect.config.model.utils.CertUtils;
import org.nhindirect.config.store.Certificate;
import org.nhindirect.config.store.dao.CertificateDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"file:src/test/resources/configStore-keyProtMgr-test.xml"})
@TransactionConfiguration(transactionManager="transactionManager", defaultRollback=true)
@Transactional
public class CertificateDao_saveTest {
    private static final String derbyHomeLoc = "/target/data";
    @Autowired
    private CertificateDao certificateDao;

    protected void cleanDatabase() throws Exception {
        List certificates = this.certificateDao.list((String)null);
        if (certificates != null && certificates.size() > 0) {
            for (Certificate cert : certificates) {
                this.certificateDao.delete(cert.getOwner());
            }
        }
        certificates = this.certificateDao.list((String)null);
        Assert.assertEquals((long)0L, (long)certificates.size());
    }

    @Test
    public void saveWithCertAndPrivKeyData() throws Exception {
        this.cleanDatabase();
        byte[] certData = FileUtils.readFileToByteArray((File)new File("./src/test/resources/certs/gm2552.der"));
        byte[] keyData = FileUtils.readFileToByteArray((File)new File("./src/test/resources/certs/gm2552Key.der"));
        Certificate addCert = new Certificate();
        addCert.setData(CertUtils.certAndWrappedKeyToRawByteFormat((byte[])keyData, (X509Certificate)CertUtils.toX509Certificate((byte[])certData)));
        addCert.setOwner("gm2552@cerner.com");
        this.certificateDao.save(addCert);
        List certificates = this.certificateDao.list((String)null);
        Assert.assertEquals((long)1L, (long)certificates.size());
        Certificate cert = (Certificate)certificates.iterator().next();
        Assert.assertTrue((boolean)cert.isPrivateKey());
        CertUtils.CertContainer container = CertUtils.toCertContainer((byte[])certData);
        Assert.assertEquals((Object)container.getCert(), (Object)CertUtils.toCertContainer((byte[])cert.getData()).getCert());
    }

    static {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            File baseLocation = new File("dummy.txt");
            String fullDerbyHome = baseLocation.getAbsolutePath().substring(0, baseLocation.getAbsolutePath().lastIndexOf(File.separator)) + derbyHomeLoc;
            System.setProperty("derby.system.home", fullDerbyHome);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

