/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.io.File;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nhindirect.config.model.utils.CertUtils;
import org.nhindirect.config.store.Certificate;
import org.nhindirect.config.store.CertificateDaoTest;
import org.nhindirect.config.store.dao.CertificateDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"file:src/test/resources/configStore-test.xml"})
@TransactionConfiguration(transactionManager="transactionManager", defaultRollback=true)
@Transactional
public class CertificateDao_stripP12ProtectionNoManagerTest {
    private static final String derbyHomeLoc = "/target/data";
    private static final String certBasePath = "src/test/resources/certs/";
    @Autowired
    private CertificateDao certificateDao;

    private static byte[] loadCertificateData(String certFileName) throws Exception {
        File fl = new File(certBasePath + certFileName);
        return FileUtils.readFileToByteArray((File)fl);
    }

    protected void cleanDatabase() throws Exception {
        List certificates = this.certificateDao.list((String)null);
        if (certificates != null && certificates.size() > 0) {
            for (Certificate cert : certificates) {
                this.certificateDao.delete(cert.getOwner());
            }
        }
        certificates = this.certificateDao.list((String)null);
        Assert.assertEquals((long)0L, (long)certificates.size());
    }

    protected Certificate populateCert(String certFile, String keyFile) throws Exception {
        this.cleanDatabase();
        byte[] certData = keyFile != null && !keyFile.isEmpty() ? CertificateDaoTest.loadPkcs12FromCertAndKey(certFile, keyFile) : CertificateDao_stripP12ProtectionNoManagerTest.loadCertificateData(certFile);
        Certificate cert = new Certificate();
        cert.setData(certData);
        cert.setOwner("gm2552@cerner.com");
        this.certificateDao.save(cert);
        return cert;
    }

    @Test
    public void testStripP12ProtectionTest_NoP12ProtectionOrManager_assertP12Returned() throws Exception {
        this.populateCert("gm2552.der", "gm2552Key.der");
        List certificates = this.certificateDao.list((String)null);
        Assert.assertEquals((long)1L, (long)certificates.size());
        Certificate cert = (Certificate)certificates.iterator().next();
        Assert.assertTrue((boolean)cert.isPrivateKey());
        byte[] certData = CertificateDaoTest.loadPkcs12FromCertAndKey("gm2552.der", "gm2552Key.der");
        CertUtils.CertContainer container = CertUtils.toCertContainer((byte[])certData);
        Assert.assertEquals((Object)container.getCert(), (Object)CertUtils.toCertContainer((byte[])cert.getData()).getCert());
    }

    @Test
    public void testStripP12ProtectionTest_X509CertAndNoManager_assertX509Returned() throws Exception {
        this.populateCert("gm2552.der", null);
        List certificates = this.certificateDao.list((String)null);
        Assert.assertEquals((long)1L, (long)certificates.size());
        Certificate cert = (Certificate)certificates.iterator().next();
        Assert.assertFalse((boolean)cert.isPrivateKey());
        byte[] certData = CertificateDao_stripP12ProtectionNoManagerTest.loadCertificateData("gm2552.der");
        CertUtils.CertContainer container = CertUtils.toCertContainer((byte[])certData);
        Assert.assertEquals((Object)container.getCert(), (Object)CertUtils.toCertContainer((byte[])cert.getData()).getCert());
    }

    @Test
    public void testStripP12ProtectionTest_X509CertAndWrappedData_noMager_assertX509Returned() throws Exception {
        this.cleanDatabase();
        byte[] certData = CertificateDao_stripP12ProtectionNoManagerTest.loadCertificateData("gm2552.der");
        byte[] keyData = CertificateDao_stripP12ProtectionNoManagerTest.loadCertificateData("gm2552Key.der");
        Certificate addCert = new Certificate();
        addCert.setData(CertUtils.certAndWrappedKeyToRawByteFormat((byte[])keyData, (X509Certificate)CertUtils.toX509Certificate((byte[])certData)));
        addCert.setOwner("gm2552@cerner.com");
        this.certificateDao.save(addCert);
        List certificates = this.certificateDao.list((String)null);
        Assert.assertEquals((long)1L, (long)certificates.size());
        Certificate cert = (Certificate)certificates.iterator().next();
        Assert.assertTrue((boolean)cert.isPrivateKey());
        CertUtils.CertContainer container = CertUtils.toCertContainer((byte[])certData);
        Assert.assertEquals((Object)container.getCert(), (Object)CertUtils.toCertContainer((byte[])cert.getData()).getCert());
    }

    static {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            File baseLocation = new File("dummy.txt");
            String fullDerbyHome = baseLocation.getAbsolutePath().substring(0, baseLocation.getAbsolutePath().lastIndexOf(File.separator)) + derbyHomeLoc;
            System.setProperty("derby.system.home", fullDerbyHome);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

