/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nhindirect.config.store.ConfigurationStoreException;
import org.nhindirect.config.store.DNSRecord;
import org.nhindirect.config.store.dao.DNSDao;
import org.nhindirect.config.store.util.DNSRecordUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"file:src/test/resources/configStore-test.xml"})
@TransactionConfiguration(transactionManager="transactionManager", defaultRollback=true)
@Transactional
public class DNSDaoTest {
    private static final String derbyHomeLoc = "/target/data";
    private static final String certBasePath = "src/test/resources/certs/";
    @Autowired
    private DNSDao dnsDao;

    private byte[] loadCertificateData(String certFileName) throws Exception {
        File fl = new File(certBasePath + certFileName);
        return FileUtils.readFileToByteArray((File)fl);
    }

    @Test
    public void testCleanDatabase() throws Exception {
        Collection records = this.dnsDao.get(255);
        if (records != null && records.size() > 0) {
            for (DNSRecord record : records) {
                this.dnsDao.remove(record.getId());
            }
        }
        records = this.dnsDao.get(255);
        Assert.assertEquals((long)0L, (long)records.size());
    }

    @Test
    public void testAddCertRecord() throws Exception {
        this.testCleanDatabase();
        byte[] certData = this.loadCertificateData("gm2552.der");
        Assert.assertNotNull((Object)certData);
        ByteArrayInputStream bais = new ByteArrayInputStream(certData);
        X509Certificate cert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(bais);
        DNSRecord record1 = DNSRecordUtils.createX509CERTRecord((String)"gm2552@securehealthemail.com", (long)86400L, (X509Certificate)cert);
        this.dnsDao.add(Arrays.asList(record1));
        Collection records = this.dnsDao.get(37);
        Assert.assertEquals((long)1L, (long)records.size());
        Assert.assertEquals((Object)record1, records.iterator().next());
    }

    @Test
    public void testAddSingleARecords() throws Exception {
        this.testCleanDatabase();
        DNSRecord record = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.1");
        this.dnsDao.add(Arrays.asList(record));
        Collection records = this.dnsDao.get(record.getName());
        Assert.assertEquals((long)1L, (long)records.size());
        DNSRecord compareRec = (DNSRecord)records.iterator().next();
        Assert.assertEquals((Object)record.getName(), (Object)compareRec.getName());
        Assert.assertEquals((long)1L, (long)compareRec.getType());
    }

    @Test
    public void testMultipleARecords() throws Exception {
        this.testCleanDatabase();
        DNSRecord record1 = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.1");
        DNSRecord record2 = DNSRecordUtils.createARecord((String)"example2.domain.com", (long)86400L, (String)"74.22.43.123");
        DNSRecord record3 = DNSRecordUtils.createARecord((String)"sample.domain.com", (long)86400L, (String)"81.142.48.20");
        this.dnsDao.add(Arrays.asList(record1, record2, record3));
        Collection records = this.dnsDao.get(record1.getName());
        Assert.assertEquals((long)1L, (long)records.size());
        DNSRecord compareRec = (DNSRecord)records.iterator().next();
        Assert.assertEquals((Object)record1.getName(), (Object)compareRec.getName());
        Assert.assertEquals((long)1L, (long)compareRec.getType());
        records = this.dnsDao.get(255);
        Assert.assertEquals((long)3L, (long)records.size());
        Assert.assertTrue((boolean)records.contains(record1));
        Assert.assertTrue((boolean)records.contains(record2));
        Assert.assertTrue((boolean)records.contains(record3));
        records = this.dnsDao.get(1);
        Assert.assertEquals((long)3L, (long)records.size());
        Assert.assertTrue((boolean)records.contains(record1));
        Assert.assertTrue((boolean)records.contains(record2));
        Assert.assertTrue((boolean)records.contains(record3));
        records = this.dnsDao.get(33);
        Assert.assertEquals((long)0L, (long)records.size());
    }

    @Test
    public void testAddRecord_invalidType() throws Exception {
        this.testCleanDatabase();
        DNSRecord record = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.1");
        record.setType(255);
        boolean exceptionOccured = false;
        try {
            this.dnsDao.add(Arrays.asList(record));
        }
        catch (ConfigurationStoreException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testAddRecord_recordAlreadyExistsWithRdata() throws Exception {
        this.testCleanDatabase();
        DNSRecord record1 = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.1");
        this.dnsDao.add(Arrays.asList(record1));
        DNSRecord record2 = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.1");
        boolean exceptionOccured = false;
        try {
            this.dnsDao.add(Arrays.asList(record2));
        }
        catch (ConfigurationStoreException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testMultipleARecords_differentRdata() throws Exception {
        this.testCleanDatabase();
        DNSRecord record1 = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.1");
        this.dnsDao.add(Arrays.asList(record1));
        DNSRecord record2 = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.2");
        this.dnsDao.add(Arrays.asList(record2));
        Collection records = this.dnsDao.get(record1.getName());
        Assert.assertEquals((long)2L, (long)records.size());
        records.contains(record1);
        records.contains(record2);
    }

    @Test
    public void testGetByType() throws Exception {
        this.testCleanDatabase();
        DNSRecord record1 = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.1");
        DNSRecord record2 = DNSRecordUtils.createARecord((String)"example2.domain.com", (long)86400L, (String)"127.0.0.1");
        DNSRecord record3 = DNSRecordUtils.createSRVRecord((String)"_ldap_cerner._tcp.cerner.com", (String)"example.domain.com", (long)86400L, (int)3506, (int)1, (int)1);
        this.dnsDao.add(Arrays.asList(record1, record2, record3));
        Collection records = this.dnsDao.get(1);
        Assert.assertEquals((long)2L, (long)records.size());
        Assert.assertTrue((boolean)records.contains(record1));
        Assert.assertTrue((boolean)records.contains(record2));
        records = this.dnsDao.get(33);
        Assert.assertEquals((long)1L, (long)records.size());
        Assert.assertTrue((boolean)records.contains(record3));
        records = this.dnsDao.get(255);
        Assert.assertEquals((long)3L, (long)records.size());
        Assert.assertTrue((boolean)records.contains(record1));
        Assert.assertTrue((boolean)records.contains(record2));
        Assert.assertTrue((boolean)records.contains(record3));
    }

    @Test
    public void testGetByName() throws Exception {
        this.testCleanDatabase();
        DNSRecord record1 = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.1");
        DNSRecord record2 = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.2");
        DNSRecord record3 = DNSRecordUtils.createARecord((String)"example2.domain.com", (long)86400L, (String)"127.0.0.3");
        DNSRecord record4 = DNSRecordUtils.createSRVRecord((String)"_ldap_cerner._tcp.cerner.com", (String)"example.domain.com", (long)86400L, (int)3506, (int)1, (int)1);
        DNSRecord record5 = DNSRecordUtils.createSRVRecord((String)"_ldap_cerner._tcp.cerner.com", (String)"example2.domain.com", (long)86400L, (int)3506, (int)1, (int)1);
        this.dnsDao.add(Arrays.asList(record1, record2, record3, record4, record5));
        Collection records = this.dnsDao.get(record1.getName());
        Assert.assertEquals((long)2L, (long)records.size());
        Assert.assertTrue((boolean)records.contains(record1));
        Assert.assertTrue((boolean)records.contains(record2));
        records = this.dnsDao.get(record3.getName());
        Assert.assertEquals((long)1L, (long)records.size());
        Assert.assertTrue((boolean)records.contains(record3));
        records = this.dnsDao.get(record4.getName());
        Assert.assertEquals((long)2L, (long)records.size());
        Assert.assertTrue((boolean)records.contains(record4));
        Assert.assertTrue((boolean)records.contains(record5));
        records = this.dnsDao.get("bogus.com.");
        Assert.assertEquals((long)0L, (long)records.size());
    }

    @Test
    public void testGetByRecord() throws Exception {
        this.testCleanDatabase();
        DNSRecord record1 = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.1");
        DNSRecord record2 = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.2");
        DNSRecord record3 = DNSRecordUtils.createARecord((String)"example2.domain.com", (long)86400L, (String)"127.0.0.3");
        DNSRecord record4 = DNSRecordUtils.createSRVRecord((String)"_ldap_cerner._tcp.cerner.com", (String)"example.domain.com", (long)86400L, (int)3506, (int)1, (int)1);
        DNSRecord record5 = DNSRecordUtils.createSRVRecord((String)"_ldap_cerner._tcp.cerner.com", (String)"example2.domain.com", (long)86400L, (int)3506, (int)1, (int)1);
        this.dnsDao.add(Arrays.asList(record1, record2, record3, record4, record5));
        Collection records = this.dnsDao.get(record3.getName());
        Assert.assertEquals((long)1L, (long)records.size());
        DNSRecord checkRec = this.dnsDao.get(((DNSRecord)records.iterator().next()).getId());
        Assert.assertNotNull((Object)checkRec);
        Assert.assertEquals((Object)checkRec, (Object)record3);
        records = this.dnsDao.get(255);
        Assert.assertEquals((long)5L, (long)records.size());
        long[] ids = new long[records.size()];
        int cnt = 0;
        for (DNSRecord record : records) {
            ids[cnt++] = record.getId();
        }
        records = this.dnsDao.get(ids);
        Assert.assertEquals((long)5L, (long)records.size());
        Assert.assertTrue((boolean)records.contains(record1));
        Assert.assertTrue((boolean)records.contains(record2));
        Assert.assertTrue((boolean)records.contains(record3));
        Assert.assertTrue((boolean)records.contains(record4));
        Assert.assertTrue((boolean)records.contains(record5));
    }

    @Test
    public void testGetCount() throws Exception {
        this.testCleanDatabase();
        Assert.assertEquals((long)0L, (long)this.dnsDao.count());
        DNSRecord record1 = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.1");
        DNSRecord record2 = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.2");
        DNSRecord record3 = DNSRecordUtils.createARecord((String)"example2.domain.com", (long)86400L, (String)"127.0.0.3");
        DNSRecord record4 = DNSRecordUtils.createSRVRecord((String)"_ldap_cerner._tcp.cerner.com", (String)"example.domain.com", (long)86400L, (int)3506, (int)1, (int)1);
        DNSRecord record5 = DNSRecordUtils.createSRVRecord((String)"_ldap_cerner._tcp.cerner.com", (String)"example2.domain.com", (long)86400L, (int)3506, (int)1, (int)1);
        this.dnsDao.add(Arrays.asList(record1, record2, record3, record4, record5));
        Assert.assertEquals((long)5L, (long)this.dnsDao.count());
    }

    @Test
    public void testRemoveByRecords() throws Exception {
        this.testCleanDatabase();
        Assert.assertEquals((long)0L, (long)this.dnsDao.count());
        DNSRecord record1 = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.1");
        DNSRecord record2 = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.2");
        DNSRecord record3 = DNSRecordUtils.createARecord((String)"example2.domain.com", (long)86400L, (String)"127.0.0.3");
        DNSRecord record4 = DNSRecordUtils.createSRVRecord((String)"_ldap_cerner._tcp.cerner.com", (String)"example.domain.com", (long)86400L, (int)3506, (int)1, (int)1);
        DNSRecord record5 = DNSRecordUtils.createSRVRecord((String)"_ldap_cerner._tcp.cerner.com", (String)"example2.domain.com", (long)86400L, (int)3506, (int)1, (int)1);
        this.dnsDao.add(Arrays.asList(record1, record2, record3, record4, record5));
        Assert.assertEquals((long)5L, (long)this.dnsDao.count());
        this.dnsDao.remove(Arrays.asList(record1, record2, record3));
        Collection records = this.dnsDao.get(255);
        Assert.assertEquals((long)2L, (long)records.size());
        Assert.assertTrue((boolean)records.contains(record4));
        Assert.assertTrue((boolean)records.contains(record5));
        this.dnsDao.remove(Arrays.asList(record4, record5));
        records = this.dnsDao.get(255);
        Assert.assertEquals((long)0L, (long)records.size());
    }

    @Test
    public void testRemoveByIds() throws Exception {
        this.testCleanDatabase();
        Assert.assertEquals((long)0L, (long)this.dnsDao.count());
        DNSRecord record1 = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.1");
        DNSRecord record2 = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.2");
        DNSRecord record3 = DNSRecordUtils.createARecord((String)"example2.domain.com", (long)86400L, (String)"127.0.0.3");
        DNSRecord record4 = DNSRecordUtils.createSRVRecord((String)"_ldap_cerner._tcp.cerner.com", (String)"example.domain.com", (long)86400L, (int)3506, (int)1, (int)1);
        DNSRecord record5 = DNSRecordUtils.createSRVRecord((String)"_ldap_cerner._tcp.cerner.com", (String)"example2.domain.com", (long)86400L, (int)3506, (int)1, (int)1);
        this.dnsDao.add(Arrays.asList(record1, record2, record3, record4, record5));
        Assert.assertEquals((long)5L, (long)this.dnsDao.count());
        Collection records = this.dnsDao.get(record3.getName());
        Assert.assertEquals((long)1L, (long)records.size());
        this.dnsDao.remove(((DNSRecord)records.iterator().next()).getId());
        records = this.dnsDao.get(255);
        Assert.assertEquals((long)4L, (long)this.dnsDao.count());
        Assert.assertTrue((boolean)records.contains(record1));
        Assert.assertTrue((boolean)records.contains(record2));
        Assert.assertTrue((boolean)records.contains(record4));
        Assert.assertTrue((boolean)records.contains(record5));
        long[] ids = new long[records.size()];
        int cnt = 0;
        for (DNSRecord record : records) {
            ids[cnt++] = record.getId();
        }
        this.dnsDao.remove(ids);
        records = this.dnsDao.get(255);
        Assert.assertEquals((long)0L, (long)records.size());
    }

    @Test
    public void testRemoveByIds_noqualifying() throws Exception {
        this.testCleanDatabase();
        Assert.assertEquals((long)0L, (long)this.dnsDao.count());
        this.dnsDao.remove(876343L);
        Assert.assertEquals((long)0L, (long)this.dnsDao.count());
    }

    @Test
    public void testRemoveByRecords_noqualifying() throws Exception {
        this.testCleanDatabase();
        Assert.assertEquals((long)0L, (long)this.dnsDao.count());
        DNSRecord record1 = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.1");
        this.dnsDao.remove(Arrays.asList(record1));
        Assert.assertEquals((long)0L, (long)this.dnsDao.count());
    }

    @Test
    public void testUpdateRecord() throws Exception {
        this.testCleanDatabase();
        Assert.assertEquals((long)0L, (long)this.dnsDao.count());
        DNSRecord record1 = DNSRecordUtils.createMXRecord((String)"example.domain.com", (String)"127.0.0.1", (long)86400L, (int)1);
        this.dnsDao.add(Arrays.asList(record1));
        Collection records = this.dnsDao.get(255);
        Assert.assertEquals((long)1L, (long)records.size());
        DNSRecord checkRecord = (DNSRecord)records.iterator().next();
        Assert.assertEquals((Object)record1, (Object)checkRecord);
        checkRecord.setName("example2.domain.com.");
        this.dnsDao.update(checkRecord.getId(), checkRecord);
        records = this.dnsDao.get(255);
        Assert.assertEquals((long)1L, (long)records.size());
        DNSRecord modRecord = (DNSRecord)records.iterator().next();
        Assert.assertEquals((Object)checkRecord, (Object)modRecord);
    }

    @Test
    public void testUpdateRecord_recordDoesNotExist() throws Exception {
        this.testCleanDatabase();
        Assert.assertEquals((long)0L, (long)this.dnsDao.count());
        DNSRecord record1 = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.1");
        boolean exceptionOccured = false;
        try {
            this.dnsDao.update(123432L, record1);
        }
        catch (ConfigurationStoreException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testUpdateRecord_illegalAnyType() throws Exception {
        this.testCleanDatabase();
        Assert.assertEquals((long)0L, (long)this.dnsDao.count());
        DNSRecord record1 = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.1");
        this.dnsDao.add(Arrays.asList(record1));
        Collection records = this.dnsDao.get(255);
        Assert.assertEquals((long)1L, (long)records.size());
        DNSRecord checkRecord = (DNSRecord)records.iterator().next();
        Assert.assertEquals((Object)record1, (Object)checkRecord);
        checkRecord.setType(255);
        boolean exceptionOccured = false;
        try {
            this.dnsDao.update(checkRecord.getId(), checkRecord);
        }
        catch (ConfigurationStoreException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    static {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            File baseLocation = new File("dummy.txt");
            String fullDerbyHome = baseLocation.getAbsolutePath().substring(0, baseLocation.getAbsolutePath().lastIndexOf(File.separator)) + derbyHomeLoc;
            System.setProperty("derby.system.home", fullDerbyHome);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

