/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nhindirect.config.store.Address;
import org.nhindirect.config.store.Domain;
import org.nhindirect.config.store.EntityStatus;
import org.nhindirect.config.store.dao.DomainDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"file:src/test/resources/configStore-test.xml"})
@TransactionConfiguration(transactionManager="transactionManager", defaultRollback=true)
@Transactional
public class DomainDaoTest {
    @Autowired
    protected ApplicationContext ctx;
    public static final String derbyHomeLoc = "/target/data";
    private static final Log log;
    @Autowired
    private DomainDao domainDao;

    @Test
    public void testCleanDatabase() {
        List domains = this.domainDao.searchDomain(null, null);
        if (domains != null) {
            for (Domain dom : domains) {
                this.domainDao.delete(dom.getDomainName());
            }
        }
        domains = this.domainDao.searchDomain(null, null);
        Assert.assertEquals((long)0L, (long)domains.size());
    }

    @Test
    public void testAddDomain() {
        this.testCleanDatabase();
        Domain domain = new Domain("health.testdomain.com");
        domain.setStatus(EntityStatus.ENABLED);
        this.domainDao.add(domain);
        Assert.assertEquals((long)this.domainDao.count(), (long)1L);
    }

    @Test
    public void testGetByDomain() {
        this.testCleanDatabase();
        Domain domain = new Domain("health.testdomain.com");
        domain.setStatus(EntityStatus.ENABLED);
        this.domainDao.add(domain);
        Domain testDomain = this.domainDao.getDomainByName("Health.testdomain.com");
        log.info((Object)("Newly added Domain ID is: " + testDomain.getId()));
        log.info((Object)("Newly added Domain Status is: " + testDomain.getStatus()));
        Assert.assertTrue((boolean)testDomain.getDomainName().equals("health.testdomain.com"));
    }

    @Test
    public void testUpdateDomain() {
        this.testCleanDatabase();
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SS Z");
        Domain domain = new Domain("health.testdomain.com");
        domain.setStatus(EntityStatus.ENABLED);
        this.domainDao.add(domain);
        Domain testDomain = this.domainDao.getDomainByName("health.testdomain.com");
        log.info((Object)("Newly added Domain ID is: " + testDomain.getId()));
        log.info((Object)("Newly added Domain Status is: " + testDomain.getStatus()));
        log.info((Object)("Newly added Domain Update Time is: " + fmt.format(new Date(testDomain.getUpdateTime().getTimeInMillis()))));
        Assert.assertTrue((boolean)testDomain.getDomainName().equals("health.testdomain.com"));
        testDomain.setStatus(EntityStatus.DISABLED);
        this.domainDao.update(testDomain);
        domain = this.domainDao.getDomainByName("health.testdomain.com");
        log.info((Object)("Updated Domain ID is: " + domain.getId()));
        log.info((Object)("Updated Status is: " + domain.getStatus()));
        log.info((Object)("Updated Update Time is: " + fmt.format(new Date(domain.getUpdateTime().getTimeInMillis()))));
        Assert.assertTrue((boolean)domain.getStatus().equals((Object)EntityStatus.DISABLED));
    }

    @Test
    public void testGetDomain() {
        this.testCleanDatabase();
        Domain domain = new Domain("health.testdomain.com");
        domain.setStatus(EntityStatus.NEW);
        this.domainDao.add(domain);
        domain = new Domain("health.newdomain.com");
        domain.setStatus(EntityStatus.NEW);
        this.domainDao.add(domain);
        ArrayList<String> names = new ArrayList<String>();
        names.add("health.testdomain.com");
        Assert.assertEquals((long)this.domainDao.getDomains(names, EntityStatus.NEW).size(), (long)1L);
        Assert.assertEquals((long)this.domainDao.getDomains(null, EntityStatus.NEW).size(), (long)2L);
        Assert.assertEquals((long)this.domainDao.getDomains(names, null).size(), (long)1L);
        Assert.assertEquals((long)this.domainDao.getDomains(names, EntityStatus.ENABLED).size(), (long)0L);
        Assert.assertEquals((long)this.domainDao.getDomains(names, EntityStatus.DISABLED).size(), (long)0L);
        Assert.assertEquals((long)this.domainDao.getDomains(null, null).size(), (long)2L);
        names.clear();
        names.add("health.baddomain.com");
        Assert.assertEquals((long)this.domainDao.getDomains(names, null).size(), (long)0L);
    }

    @Test
    public void testDeleteDomain() {
        this.testCleanDatabase();
        Domain domain = new Domain("health.newdomain.com");
        domain.setPostMasterEmail("postmaster@health.newdomain.com");
        domain.setStatus(EntityStatus.NEW);
        this.domainDao.add(domain);
        Assert.assertEquals((long)1L, (long)this.domainDao.count());
        this.domainDao.delete("health.testdomain.com");
        Assert.assertEquals((long)1L, (long)this.domainDao.count());
        this.domainDao.delete("health.newdomain.com");
        Assert.assertEquals((long)0L, (long)this.domainDao.count());
    }

    @Test
    public void testSearchDomain() {
        this.testCleanDatabase();
        log.debug((Object)"Enter");
        Domain domain = new Domain("health.newdomain.com");
        domain.setStatus(EntityStatus.NEW);
        this.domainDao.add(domain);
        domain = new Domain("healthy.domain.com");
        domain.setStatus(EntityStatus.NEW);
        this.domainDao.add(domain);
        String name = "heal*";
        List result = this.domainDao.searchDomain(name, null);
        Assert.assertEquals((long)2L, (long)result.size());
        name = "*.com";
        result = this.domainDao.searchDomain(name, null);
        Assert.assertEquals((long)2L, (long)result.size());
        result = this.domainDao.searchDomain(null, null);
        Assert.assertEquals((long)2L, (long)result.size());
        name = "*.org";
        result = this.domainDao.searchDomain(name, null);
        Assert.assertEquals((long)0L, (long)result.size());
        log.debug((Object)"Exit");
    }

    @Test
    public void testAddDomainsWithAddresses() {
        this.testCleanDatabase();
        Domain domain = new Domain("health.newdomain.com");
        domain.setStatus(EntityStatus.NEW);
        domain.getAddresses().add(new Address(domain, "test1@health.newdomain.com", "Test1"));
        domain.getAddresses().add(new Address(domain, "test2@health.newdomain.com", "Test2"));
        domain.setPostMasterEmail("postmaster@health.newdomain.com");
        this.domainDao.add(domain);
        Domain test = this.domainDao.getDomainByName("health.newdomain.com");
        Assert.assertEquals((Object)"postmaster@health.newdomain.com", (Object)test.getPostMasterEmail());
        Assert.assertEquals((long)3L, (long)test.getAddresses().size());
        log.info((Object)domain.toString());
        log.info((Object)test.toString());
        for (Address testAddress : test.getAddresses()) {
            log.info((Object)testAddress.toString());
        }
    }

    @Test
    public void testDeleteDomainsWithAddresses() {
        Domain domain = new Domain("health.newdomain.com");
        domain.setStatus(EntityStatus.NEW);
        domain.getAddresses().add(new Address(domain, "test1@health.newdomain.com", "Test1"));
        domain.getAddresses().add(new Address(domain, "test2@health.newdomain.com", "Test2"));
        domain.setPostMasterEmail("postmaster@health.newdomain.com");
        this.domainDao.add(domain);
        Domain test = this.domainDao.getDomainByName("health.newdomain.com");
        Assert.assertEquals((Object)"postmaster@health.newdomain.com", (Object)test.getPostMasterEmail());
        Assert.assertEquals((long)3L, (long)test.getAddresses().size());
        this.domainDao.delete("health.newdomain.com");
        test = this.domainDao.getDomainByName("health.newdomain.com");
        Assert.assertEquals(null, (Object)test);
        domain = new Domain("health.domain.com");
        domain.setStatus(EntityStatus.NEW);
        domain.getAddresses().add(new Address(domain, "test1@health.domain.com", "Test1"));
        domain.getAddresses().add(new Address(domain, "test2@health.domain.com", "Test2"));
        domain.setPostMasterEmail("postmaster@health.domain.com");
        this.domainDao.add(domain);
        test = this.domainDao.getDomainByName("health.domain.com");
        Long id = test.getId();
        this.domainDao.delete(id);
        test = this.domainDao.getDomain(id);
        Assert.assertEquals(null, (Object)test);
    }

    static {
        try {
            File baseLocation = new File("dummy.txt");
            String fullDerbyHome = baseLocation.getAbsolutePath().substring(0, baseLocation.getAbsolutePath().lastIndexOf(File.separator)) + derbyHomeLoc;
            System.setProperty("derby.system.home", fullDerbyHome);
        }
        catch (Exception exception) {
            // empty catch block
        }
        log = LogFactory.getLog(DomainDaoTest.class);
    }
}

