/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.util.Collection;
import java.util.Iterator;
import javax.persistence.EntityManager;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.nhindirect.config.store.ConfigurationStoreException;
import org.nhindirect.config.store.TrustBundle;
import org.nhindirect.config.store.TrustBundleDaoBaseTest;
import org.nhindirect.config.store.dao.impl.TrustBundleDaoImpl;

public class TrustBundlDaoImpl_deleteTrustBundlesTest
extends TrustBundleDaoBaseTest {
    @Test
    public void testDeleteTrustBundlesTest_singleBundle_assertBundleDeleted() {
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        this.tbDao.addTrustBundle(bundle);
        Collection bundles = this.tbDao.getTrustBundles();
        Assert.assertEquals((long)1L, (long)bundles.size());
        this.tbDao.deleteTrustBundles(new long[]{((TrustBundle)bundles.iterator().next()).getId()});
        bundles = this.tbDao.getTrustBundles();
        Assert.assertEquals((long)0L, (long)bundles.size());
    }

    @Test
    public void testDeleteTrustBundlesTest_multipleBundles_assertSingleBundleDeleted() {
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        this.tbDao.addTrustBundle(bundle);
        bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle2");
        bundle.setBundleURL("http://testBundle/bundle2.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("67890");
        this.tbDao.addTrustBundle(bundle);
        Collection bundles = this.tbDao.getTrustBundles();
        Assert.assertEquals((long)2L, (long)bundles.size());
        this.tbDao.deleteTrustBundles(new long[]{((TrustBundle)bundles.iterator().next()).getId()});
        bundles = this.tbDao.getTrustBundles();
        Assert.assertEquals((long)1L, (long)bundles.size());
    }

    @Test
    public void testDeleteTrustBundlesTest_multipleBundles_assertAllBundlesDeleted() {
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        this.tbDao.addTrustBundle(bundle);
        bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle2");
        bundle.setBundleURL("http://testBundle/bundle2.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("67890");
        this.tbDao.addTrustBundle(bundle);
        Collection bundles = this.tbDao.getTrustBundles();
        Assert.assertEquals((long)2L, (long)bundles.size());
        Iterator iter = bundles.iterator();
        this.tbDao.deleteTrustBundles(new long[]{((TrustBundle)iter.next()).getId(), ((TrustBundle)iter.next()).getId()});
        bundles = this.tbDao.getTrustBundles();
        Assert.assertEquals((long)0L, (long)bundles.size());
    }

    @Test
    public void testDeleteTrustBundlesTest_nullArray_assertNoError() {
        this.tbDao.deleteTrustBundles(null);
    }

    @Test
    public void testDeleteTrustBundlesTest_emptyArray_assertNoError() {
        this.tbDao.deleteTrustBundles(new long[0]);
    }

    @Test
    public void testDeleteTrustBundlesTest_exceptionInQuery_assertNoException() {
        EntityManager manager = (EntityManager)Mockito.mock(EntityManager.class);
        ((EntityManager)Mockito.doThrow((Throwable)new RuntimeException("Just Passing Through")).when((Object)manager)).remove((Object)((TrustBundle)Matchers.any()));
        TrustBundleDaoImpl dao = new TrustBundleDaoImpl();
        dao.setEntityManager(manager);
        boolean exceptionOccured = false;
        try {
            dao.deleteTrustBundles(new long[]{1234L});
        }
        catch (ConfigurationStoreException ex) {
            exceptionOccured = true;
        }
        Assert.assertFalse((boolean)exceptionOccured);
        ((EntityManager)Mockito.verify((Object)manager, (VerificationMode)Mockito.never())).remove((Object)((TrustBundle)Matchers.any()));
        ((EntityManager)Mockito.verify((Object)manager, (VerificationMode)Mockito.never())).flush();
    }

    @Test
    public void testDeleteTrustBundlesTest_noEntityManager_assertException() {
        TrustBundleDaoImpl dao = new TrustBundleDaoImpl();
        boolean exceptionOccured = false;
        try {
            dao.deleteTrustBundles(new long[]{1234L});
        }
        catch (IllegalStateException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }
}

