/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.io.File;
import java.security.Provider;
import java.security.Security;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.nhindirect.config.store.Domain;
import org.nhindirect.config.store.TrustBundle;
import org.nhindirect.config.store.dao.DomainDao;
import org.nhindirect.config.store.dao.TrustBundleDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"file:src/test/resources/configStore-test.xml"})
@TransactionConfiguration(transactionManager="transactionManager", defaultRollback=true)
@Transactional
public abstract class TrustBundleDaoBaseTest {
    @Autowired
    protected TrustBundleDao tbDao;
    @Autowired
    protected DomainDao dmDao;
    private static final String derbyHomeLoc = "/target/data";
    protected static final String certBasePath = "src/test/resources/certs/";

    protected static byte[] loadCertificateData(String certFileName) throws Exception {
        File fl = new File(certBasePath + certFileName);
        return FileUtils.readFileToByteArray((File)fl);
    }

    @Before
    public void setUp() {
        this.clearBundles();
        this.clearDomains();
    }

    protected void clearBundles() {
        Collection bundles = this.tbDao.getTrustBundles();
        Assert.assertNotNull((Object)bundles);
        if (!bundles.isEmpty()) {
            long[] ids = new long[bundles.size()];
            int idx = 0;
            for (TrustBundle bundle : bundles) {
                ids[idx++] = bundle.getId();
            }
            this.tbDao.deleteTrustBundles(ids);
        }
        bundles = this.tbDao.getTrustBundles();
        Assert.assertTrue((boolean)bundles.isEmpty());
    }

    protected void clearDomains() {
        List domains = this.dmDao.searchDomain(null, null);
        if (domains != null) {
            for (Domain dom : domains) {
                this.dmDao.delete(dom.getDomainName());
            }
        }
        domains = this.dmDao.searchDomain(null, null);
        Assert.assertEquals((long)0L, (long)domains.size());
    }

    static {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            File baseLocation = new File("dummy.txt");
            String fullDerbyHome = baseLocation.getAbsolutePath().substring(0, baseLocation.getAbsolutePath().lastIndexOf(File.separator)) + derbyHomeLoc;
            System.setProperty("derby.system.home", fullDerbyHome);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

