/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.config.store.ConfigurationStoreException;
import org.nhindirect.config.store.Thumbprint;
import org.nhindirect.config.store.TrustBundle;
import org.nhindirect.config.store.TrustBundleAnchor;
import org.nhindirect.config.store.TrustBundleDaoBaseTest;
import org.nhindirect.config.store.dao.impl.TrustBundleDaoImpl;

public class TrustBundleDaoImpl_addTrustBundleTest
extends TrustBundleDaoBaseTest {
    @Test
    public void testAddTrustBundle_addBundle_noAnchors_assertAdded() {
        Calendar now = Calendar.getInstance(Locale.getDefault());
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        this.tbDao.addTrustBundle(bundle);
        Collection bundles = this.tbDao.getTrustBundles();
        Assert.assertEquals((long)1L, (long)bundles.size());
        TrustBundle addedBundle = (TrustBundle)bundles.iterator().next();
        Assert.assertEquals((Object)"Test Bundle", (Object)addedBundle.getBundleName());
        Assert.assertEquals((Object)"http://testBundle/bundle.p7b", (Object)addedBundle.getBundleURL());
        Assert.assertEquals((Object)"12345", (Object)addedBundle.getCheckSum());
        Assert.assertEquals((long)5L, (long)addedBundle.getRefreshInterval());
        Assert.assertTrue((now.getTimeInMillis() <= addedBundle.getCreateTime().getTimeInMillis() ? 1 : 0) != 0);
        Assert.assertNull((Object)addedBundle.getLastRefreshAttempt());
        Assert.assertNull((Object)addedBundle.getLastSuccessfulRefresh());
        Assert.assertNull((Object)addedBundle.getLastRefreshError());
        Assert.assertNull((Object)addedBundle.getSigningCertificateData());
        Assert.assertTrue((boolean)addedBundle.getTrustBundleAnchors().isEmpty());
    }

    @Test
    public void testAddTrustBundle_addBundle_withAnchors_assertAdded() throws Exception {
        Calendar now = Calendar.getInstance(Locale.getDefault());
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        TrustBundleAnchor anchor = new TrustBundleAnchor();
        anchor.setData(TrustBundleDaoImpl_addTrustBundleTest.loadCertificateData("secureHealthEmailCACert.der"));
        anchor.setTrustBundle(bundle);
        bundle.setTrustBundleAnchors(Arrays.asList(anchor));
        this.tbDao.addTrustBundle(bundle);
        Collection bundles = this.tbDao.getTrustBundles();
        Assert.assertEquals((long)1L, (long)bundles.size());
        TrustBundle addedBundle = (TrustBundle)bundles.iterator().next();
        Assert.assertEquals((Object)"Test Bundle", (Object)addedBundle.getBundleName());
        Assert.assertEquals((Object)"http://testBundle/bundle.p7b", (Object)addedBundle.getBundleURL());
        Assert.assertEquals((Object)"12345", (Object)addedBundle.getCheckSum());
        Assert.assertEquals((long)5L, (long)addedBundle.getRefreshInterval());
        Assert.assertTrue((now.getTimeInMillis() <= addedBundle.getCreateTime().getTimeInMillis() ? 1 : 0) != 0);
        Assert.assertNull((Object)addedBundle.getLastRefreshAttempt());
        Assert.assertNull((Object)addedBundle.getLastSuccessfulRefresh());
        Assert.assertNull((Object)addedBundle.getLastRefreshError());
        Assert.assertNull((Object)addedBundle.getSigningCertificateData());
        Assert.assertEquals((long)1L, (long)addedBundle.getTrustBundleAnchors().size());
        TrustBundleAnchor addedAnchor = (TrustBundleAnchor)addedBundle.getTrustBundleAnchors().iterator().next();
        Assert.assertNotNull((Object)addedAnchor.toCertificate());
        Assert.assertEquals((Object)anchor.toCertificate(), (Object)addedAnchor.toCertificate());
        Assert.assertEquals((Object)Thumbprint.toThumbprint((X509Certificate)anchor.toCertificate()).toString(), (Object)addedAnchor.getThumbprint());
        Assert.assertEquals((Object)anchor.toCertificate().getNotAfter(), (Object)addedAnchor.getValidEndDate().getTime());
        Assert.assertEquals((Object)anchor.toCertificate().getNotBefore(), (Object)addedAnchor.getValidStartDate().getTime());
        Assert.assertEquals((Object)anchor.getTrustBundle().getBundleName(), (Object)bundle.getBundleName());
        Assert.assertEquals((long)anchor.getTrustBundle().getId(), (long)addedBundle.getId());
    }

    @Test
    public void testAddTrustBundle_addExistingBundle_assertException() {
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        this.tbDao.addTrustBundle(bundle);
        Collection bundles = this.tbDao.getTrustBundles();
        Assert.assertEquals((long)1L, (long)bundles.size());
        boolean exceptionOccured = false;
        try {
            this.tbDao.addTrustBundle(bundle);
        }
        catch (ConfigurationStoreException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        bundles = this.tbDao.getTrustBundles();
        Assert.assertEquals((long)1L, (long)bundles.size());
    }

    @Test
    public void testAddTrustBundle_noEntityManager_assertException() {
        TrustBundleDaoImpl dao = new TrustBundleDaoImpl();
        boolean exceptionOccured = false;
        try {
            dao.addTrustBundle(new TrustBundle());
        }
        catch (IllegalStateException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }
}

