/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.util.Collection;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.nhindirect.config.store.ConfigurationStoreException;
import org.nhindirect.config.store.Domain;
import org.nhindirect.config.store.TrustBundle;
import org.nhindirect.config.store.TrustBundleDaoBaseTest;
import org.nhindirect.config.store.TrustBundleDomainReltn;
import org.nhindirect.config.store.dao.DomainDao;
import org.nhindirect.config.store.dao.impl.TrustBundleDaoImpl;

public class TrustBundleDaoImpl_associateTrustBundleToDomainTest
extends TrustBundleDaoBaseTest {
    @Test
    public void testAssociateTrustBundleToDomain_associateDomainAndBundle_assertAssociationAdded() {
        Domain domain = new Domain();
        domain.setDomainName("Test Domain");
        this.dmDao.add(domain);
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://test/url/bundle");
        bundle.setCheckSum("1234");
        this.tbDao.addTrustBundle(bundle);
        this.tbDao.associateTrustBundleToDomain(domain.getId().longValue(), bundle.getId(), true, false);
        Collection bundleReltn = this.tbDao.getTrustBundlesByDomain(domain.getId().longValue());
        Assert.assertEquals((long)1L, (long)bundleReltn.size());
        TrustBundleDomainReltn reltn = (TrustBundleDomainReltn)bundleReltn.iterator().next();
        Assert.assertTrue((boolean)reltn.isIncoming());
        Assert.assertFalse((boolean)reltn.isOutgoing());
    }

    @Test
    public void testAssociateTrustBundleToDomain_unknownDomain_assertException() {
        boolean exceptionOccured = false;
        EntityManager mgr = (EntityManager)Mockito.mock(EntityManager.class);
        DomainDao domainDao = (DomainDao)Mockito.mock(DomainDao.class);
        TrustBundleDaoImpl dao = new TrustBundleDaoImpl();
        dao.setDomainDao(domainDao);
        dao.setEntityManager(mgr);
        TrustBundleDaoImpl spyDao = (TrustBundleDaoImpl)Mockito.spy((Object)dao);
        try {
            spyDao.associateTrustBundleToDomain(1234L, 5678L, true, true);
        }
        catch (ConfigurationStoreException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        ((DomainDao)Mockito.verify((Object)domainDao, (VerificationMode)Mockito.times((int)1))).getDomain(new Long(1234L));
        ((TrustBundleDaoImpl)Mockito.verify((Object)spyDao, (VerificationMode)Mockito.never())).getTrustBundleById(5678L);
    }

    @Test
    public void testAssociateTrustBundleToDomain_unknownTrustBundle_assertException() {
        boolean exceptionOccured = false;
        EntityManager mgr = (EntityManager)Mockito.mock(EntityManager.class);
        Domain domain = (Domain)Mockito.mock(Domain.class);
        DomainDao domainDao = (DomainDao)Mockito.mock(DomainDao.class);
        Mockito.when((Object)domainDao.getDomain(new Long(1234L))).thenReturn((Object)domain);
        TrustBundleDaoImpl dao = new TrustBundleDaoImpl();
        Query query = (Query)Mockito.mock(Query.class);
        ((Query)Mockito.doThrow((Throwable)new NoResultException()).when((Object)query)).getSingleResult();
        Mockito.when((Object)mgr.createQuery("SELECT tb from TrustBundle tb WHERE tb.id = ?1")).thenReturn((Object)query);
        dao.setDomainDao(domainDao);
        dao.setEntityManager(mgr);
        TrustBundleDaoImpl spyDao = (TrustBundleDaoImpl)Mockito.spy((Object)dao);
        try {
            spyDao.associateTrustBundleToDomain(1234L, 5678L, true, true);
        }
        catch (ConfigurationStoreException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        ((DomainDao)Mockito.verify((Object)domainDao, (VerificationMode)Mockito.times((int)1))).getDomain(new Long(1234L));
        ((TrustBundleDaoImpl)Mockito.verify((Object)spyDao, (VerificationMode)Mockito.times((int)1))).getTrustBundleById(5678L);
        ((EntityManager)Mockito.verify((Object)mgr, (VerificationMode)Mockito.never())).persist((Object)((TrustBundleDomainReltn)Matchers.any()));
    }

    @Test
    public void testAssociateTrustBundleToDomain_errorInAdd_assertException() {
        boolean exceptionOccured = false;
        EntityManager mgr = (EntityManager)Mockito.mock(EntityManager.class);
        ((EntityManager)Mockito.doThrow((Throwable)new RuntimeException("Just Passing Through")).when((Object)mgr)).persist((Object)((TrustBundleDomainReltn)Matchers.any()));
        Domain domain = (Domain)Mockito.mock(Domain.class);
        DomainDao domainDao = (DomainDao)Mockito.mock(DomainDao.class);
        Mockito.when((Object)domainDao.getDomain(new Long(1234L))).thenReturn((Object)domain);
        TrustBundle bundle = (TrustBundle)Mockito.mock(TrustBundle.class);
        Query query = (Query)Mockito.mock(Query.class);
        Mockito.when((Object)query.getSingleResult()).thenReturn((Object)bundle);
        Mockito.when((Object)mgr.createQuery("SELECT tb from TrustBundle tb WHERE tb.id = ?1")).thenReturn((Object)query);
        TrustBundleDaoImpl dao = new TrustBundleDaoImpl();
        dao.setDomainDao(domainDao);
        dao.setEntityManager(mgr);
        TrustBundleDaoImpl spyDao = (TrustBundleDaoImpl)Mockito.spy((Object)dao);
        try {
            spyDao.associateTrustBundleToDomain(1234L, 5678L, true, true);
        }
        catch (ConfigurationStoreException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        ((DomainDao)Mockito.verify((Object)domainDao, (VerificationMode)Mockito.times((int)1))).getDomain(new Long(1234L));
        ((TrustBundleDaoImpl)Mockito.verify((Object)spyDao, (VerificationMode)Mockito.times((int)1))).getTrustBundleById(5678L);
        ((EntityManager)Mockito.verify((Object)mgr, (VerificationMode)Mockito.times((int)1))).persist((Object)((TrustBundleDomainReltn)Matchers.any()));
    }

    @Test
    public void testAssociateTrustBundleToDomain_noEntityManager_assertException() {
        TrustBundleDaoImpl dao = new TrustBundleDaoImpl();
        boolean exceptionOccured = false;
        try {
            dao.associateTrustBundleToDomain(1234L, 5678L, true, true);
        }
        catch (IllegalStateException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }
}

