/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.util.Collection;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.nhindirect.config.store.ConfigurationStoreException;
import org.nhindirect.config.store.Domain;
import org.nhindirect.config.store.TrustBundle;
import org.nhindirect.config.store.TrustBundleDaoBaseTest;
import org.nhindirect.config.store.TrustBundleDomainReltn;
import org.nhindirect.config.store.dao.DomainDao;
import org.nhindirect.config.store.dao.impl.TrustBundleDaoImpl;

public class TrustBundleDaoImpl_disassociateTrustBundleFromDomainTest
extends TrustBundleDaoBaseTest {
    @Test
    public void testDisassociateTrustBundleFromDomain_associateDomainAndBundle_assertAssociationRemoved() {
        Domain domain = new Domain();
        domain.setDomainName("Test Domain");
        this.dmDao.add(domain);
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://test/url/bundle");
        bundle.setCheckSum("1234");
        this.tbDao.addTrustBundle(bundle);
        this.tbDao.associateTrustBundleToDomain(domain.getId().longValue(), bundle.getId(), true, true);
        Collection bundles = this.tbDao.getTrustBundlesByDomain(domain.getId().longValue());
        Assert.assertEquals((long)1L, (long)bundles.size());
        this.tbDao.disassociateTrustBundleFromDomain(domain.getId().longValue(), bundle.getId());
        bundles = this.tbDao.getTrustBundlesByDomain(domain.getId().longValue());
        Assert.assertEquals((long)0L, (long)bundles.size());
    }

    @Test
    public void testDisassociateTrustBundleFromDomain_unknownDomain_assertException() {
        boolean exceptionOccured = false;
        EntityManager mgr = (EntityManager)Mockito.mock(EntityManager.class);
        DomainDao domainDao = (DomainDao)Mockito.mock(DomainDao.class);
        TrustBundleDaoImpl dao = new TrustBundleDaoImpl();
        dao.setDomainDao(domainDao);
        dao.setEntityManager(mgr);
        TrustBundleDaoImpl spyDao = (TrustBundleDaoImpl)Mockito.spy((Object)dao);
        try {
            spyDao.disassociateTrustBundleFromDomain(1234L, 5678L);
        }
        catch (ConfigurationStoreException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        ((DomainDao)Mockito.verify((Object)domainDao, (VerificationMode)Mockito.times((int)1))).getDomain(new Long(1234L));
        ((TrustBundleDaoImpl)Mockito.verify((Object)spyDao, (VerificationMode)Mockito.never())).getTrustBundleById(5678L);
    }

    @Test
    public void testDisassociateTrustBundleFromDomain_unknownTrustBundle_assertException() {
        boolean exceptionOccured = false;
        EntityManager mgr = (EntityManager)Mockito.mock(EntityManager.class);
        Domain domain = (Domain)Mockito.mock(Domain.class);
        DomainDao domainDao = (DomainDao)Mockito.mock(DomainDao.class);
        Mockito.when((Object)domainDao.getDomain(new Long(1234L))).thenReturn((Object)domain);
        TrustBundleDaoImpl dao = new TrustBundleDaoImpl();
        Query query = (Query)Mockito.mock(Query.class);
        ((Query)Mockito.doThrow((Throwable)new NoResultException()).when((Object)query)).getSingleResult();
        Mockito.when((Object)mgr.createQuery("SELECT tb from TrustBundle tb WHERE tb.id = ?1")).thenReturn((Object)query);
        dao.setDomainDao(domainDao);
        dao.setEntityManager(mgr);
        TrustBundleDaoImpl spyDao = (TrustBundleDaoImpl)Mockito.spy((Object)dao);
        try {
            spyDao.disassociateTrustBundleFromDomain(1234L, 5678L);
        }
        catch (ConfigurationStoreException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        ((DomainDao)Mockito.verify((Object)domainDao, (VerificationMode)Mockito.times((int)1))).getDomain(new Long(1234L));
        ((TrustBundleDaoImpl)Mockito.verify((Object)spyDao, (VerificationMode)Mockito.times((int)1))).getTrustBundleById(5678L);
        ((EntityManager)Mockito.verify((Object)mgr, (VerificationMode)Mockito.never())).remove((Object)((TrustBundleDomainReltn)Matchers.any()));
    }

    @Test
    public void testDisassociateTrustBundleFromDomain_associationNotMade_assertException() {
        boolean exceptionOccured = false;
        Domain domain = new Domain();
        domain.setDomainName("Test Domain");
        this.dmDao.add(domain);
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://test/url/bundle");
        bundle.setCheckSum("1234");
        this.tbDao.addTrustBundle(bundle);
        Collection bundles = this.tbDao.getTrustBundlesByDomain(domain.getId().longValue());
        Assert.assertEquals((long)0L, (long)bundles.size());
        try {
            this.tbDao.disassociateTrustBundleFromDomain(domain.getId().longValue(), bundle.getId());
        }
        catch (ConfigurationStoreException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testDisassociateTrustBundleFromDomain_noEntityManager_assertException() {
        TrustBundleDaoImpl dao = new TrustBundleDaoImpl();
        boolean exceptionOccured = false;
        try {
            dao.disassociateTrustBundleFromDomain(1234L, 5678L);
        }
        catch (IllegalStateException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testDisassociateTrustBundleFromDomain_unknownErrorInRemove_assertException() {
        boolean exceptionOccured = false;
        EntityManager mgr = (EntityManager)Mockito.mock(EntityManager.class);
        ((EntityManager)Mockito.doThrow((Throwable)new RuntimeException("Just Passing Through")).when((Object)mgr)).remove((Object)((TrustBundleDomainReltn)Matchers.any()));
        Domain domain = (Domain)Mockito.mock(Domain.class);
        DomainDao domainDao = (DomainDao)Mockito.mock(DomainDao.class);
        Mockito.when((Object)domainDao.getDomain(new Long(1234L))).thenReturn((Object)domain);
        TrustBundle bundle = (TrustBundle)Mockito.mock(TrustBundle.class);
        Query query = (Query)Mockito.mock(Query.class);
        Mockito.when((Object)query.getSingleResult()).thenReturn((Object)bundle);
        Mockito.when((Object)mgr.createQuery("SELECT tb from TrustBundle tb WHERE tb.id = ?1")).thenReturn((Object)query);
        TrustBundleDomainReltn reltn = (TrustBundleDomainReltn)Mockito.mock(TrustBundleDomainReltn.class);
        Query findReltnQeury = (Query)Mockito.mock(Query.class);
        Mockito.when((Object)findReltnQeury.getSingleResult()).thenReturn((Object)reltn);
        Mockito.when((Object)mgr.createQuery("SELECT tbd from TrustBundleDomainReltn tbd where tbd.domain  = ?1  and tbd.trustBundle = ?2 ")).thenReturn((Object)findReltnQeury);
        TrustBundleDaoImpl dao = new TrustBundleDaoImpl();
        dao.setDomainDao(domainDao);
        dao.setEntityManager(mgr);
        TrustBundleDaoImpl spyDao = (TrustBundleDaoImpl)Mockito.spy((Object)dao);
        try {
            spyDao.disassociateTrustBundleFromDomain(1234L, 5678L);
        }
        catch (ConfigurationStoreException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        ((DomainDao)Mockito.verify((Object)domainDao, (VerificationMode)Mockito.times((int)1))).getDomain(new Long(1234L));
        ((TrustBundleDaoImpl)Mockito.verify((Object)spyDao, (VerificationMode)Mockito.times((int)1))).getTrustBundleById(5678L);
        ((EntityManager)Mockito.verify((Object)mgr, (VerificationMode)Mockito.times((int)1))).remove((Object)((TrustBundleDomainReltn)Matchers.any()));
    }
}

