/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.util.Collection;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.nhindirect.config.store.ConfigurationStoreException;
import org.nhindirect.config.store.Domain;
import org.nhindirect.config.store.TrustBundle;
import org.nhindirect.config.store.TrustBundleDaoBaseTest;
import org.nhindirect.config.store.dao.DomainDao;
import org.nhindirect.config.store.dao.impl.TrustBundleDaoImpl;

public class TrustBundleDaoImpl_disassociateTrustBundlesFromDomainTest
extends TrustBundleDaoBaseTest {
    @Test
    public void testDisassociateTrustBundlesFromDomain_associateDomainAndBundle_assertAssociationRemoved() {
        Domain domain = new Domain();
        domain.setDomainName("Test Domain");
        this.dmDao.add(domain);
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://test/url/bundle");
        bundle.setCheckSum("1234");
        this.tbDao.addTrustBundle(bundle);
        this.tbDao.associateTrustBundleToDomain(domain.getId().longValue(), bundle.getId(), true, true);
        Collection bundles = this.tbDao.getTrustBundlesByDomain(domain.getId().longValue());
        Assert.assertEquals((long)1L, (long)bundles.size());
        this.tbDao.disassociateTrustBundlesFromDomain(domain.getId().longValue());
        bundles = this.tbDao.getTrustBundlesByDomain(domain.getId().longValue());
        Assert.assertEquals((long)0L, (long)bundles.size());
    }

    @Test
    public void testDisassociateTrustBundlesFromDomain_unknownDomain_assertException() {
        boolean exceptionOccured = false;
        EntityManager mgr = (EntityManager)Mockito.mock(EntityManager.class);
        DomainDao domainDao = (DomainDao)Mockito.mock(DomainDao.class);
        TrustBundleDaoImpl dao = new TrustBundleDaoImpl();
        dao.setDomainDao(domainDao);
        dao.setEntityManager(mgr);
        TrustBundleDaoImpl spyDao = (TrustBundleDaoImpl)Mockito.spy((Object)dao);
        try {
            spyDao.disassociateTrustBundlesFromDomain(1234L);
        }
        catch (ConfigurationStoreException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        ((DomainDao)Mockito.verify((Object)domainDao, (VerificationMode)Mockito.times((int)1))).getDomain(new Long(1234L));
    }

    @Test
    public void testDisassociateTrustBundlesFromDomain_noEntityManager_assertException() {
        TrustBundleDaoImpl dao = new TrustBundleDaoImpl();
        boolean exceptionOccured = false;
        try {
            dao.disassociateTrustBundlesFromDomain(1234L);
        }
        catch (IllegalStateException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testDisassociateTrustBundlesFromDomain_unknownErrorInRemove_assertException() {
        boolean exceptionOccured = false;
        EntityManager mgr = (EntityManager)Mockito.mock(EntityManager.class);
        Domain domain = (Domain)Mockito.mock(Domain.class);
        DomainDao domainDao = (DomainDao)Mockito.mock(DomainDao.class);
        Mockito.when((Object)domainDao.getDomain(new Long(1234L))).thenReturn((Object)domain);
        Query deleteQuery = (Query)Mockito.mock(Query.class);
        ((Query)Mockito.doThrow((Throwable)new RuntimeException("Just Passing Through")).when((Object)deleteQuery)).executeUpdate();
        Mockito.when((Object)mgr.createQuery("DELETE from TrustBundleDomainReltn tbd where tbd.domain  = ?1")).thenReturn((Object)deleteQuery);
        TrustBundleDaoImpl dao = new TrustBundleDaoImpl();
        dao.setDomainDao(domainDao);
        dao.setEntityManager(mgr);
        TrustBundleDaoImpl spyDao = (TrustBundleDaoImpl)Mockito.spy((Object)dao);
        try {
            spyDao.disassociateTrustBundlesFromDomain(1234L);
        }
        catch (ConfigurationStoreException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        ((DomainDao)Mockito.verify((Object)domainDao, (VerificationMode)Mockito.times((int)1))).getDomain(new Long(1234L));
        ((Query)Mockito.verify((Object)deleteQuery, (VerificationMode)Mockito.times((int)1))).executeUpdate();
    }
}

