/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import javax.persistence.EntityManager;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.nhindirect.config.store.ConfigurationStoreException;
import org.nhindirect.config.store.Thumbprint;
import org.nhindirect.config.store.TrustBundle;
import org.nhindirect.config.store.TrustBundleAnchor;
import org.nhindirect.config.store.TrustBundleDaoBaseTest;
import org.nhindirect.config.store.dao.impl.TrustBundleDaoImpl;

public class TrustBundleDaoImpl_getBundlesTest
extends TrustBundleDaoBaseTest {
    @Test
    public void testGetTrustBundles_emptyBundleStore_assertNotBundlesRetrieved() {
        Collection bundles = this.tbDao.getTrustBundles();
        Assert.assertTrue((boolean)bundles.isEmpty());
    }

    @Test
    public void testGetTrustBundles_singleEntryInBundleStore_noAnchors_assertBundlesRetrieved() {
        Calendar now = Calendar.getInstance(Locale.getDefault());
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        this.tbDao.addTrustBundle(bundle);
        Collection bundles = this.tbDao.getTrustBundles();
        Assert.assertEquals((long)1L, (long)bundles.size());
        TrustBundle addedBundle = (TrustBundle)bundles.iterator().next();
        Assert.assertEquals((Object)"Test Bundle", (Object)addedBundle.getBundleName());
        Assert.assertEquals((Object)"http://testBundle/bundle.p7b", (Object)addedBundle.getBundleURL());
        Assert.assertEquals((Object)"12345", (Object)addedBundle.getCheckSum());
        Assert.assertEquals((long)5L, (long)addedBundle.getRefreshInterval());
        Assert.assertTrue((now.getTimeInMillis() <= addedBundle.getCreateTime().getTimeInMillis() ? 1 : 0) != 0);
        Assert.assertNull((Object)addedBundle.getLastRefreshAttempt());
        Assert.assertNull((Object)addedBundle.getLastSuccessfulRefresh());
        Assert.assertNull((Object)addedBundle.getLastRefreshError());
        Assert.assertNull((Object)addedBundle.getSigningCertificateData());
        Assert.assertTrue((boolean)addedBundle.getTrustBundleAnchors().isEmpty());
    }

    @Test
    public void testGetTrustBundles_singleEntryInBundleStore_signingCert_noAnchors_assertBundlesRetrieved() throws Exception {
        Calendar now = Calendar.getInstance(Locale.getDefault());
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setSigningCertificateData(TrustBundleDaoImpl_getBundlesTest.loadCertificateData("secureHealthEmailCACert.der"));
        bundle.setCheckSum("12345");
        this.tbDao.addTrustBundle(bundle);
        Collection bundles = this.tbDao.getTrustBundles();
        Assert.assertEquals((long)1L, (long)bundles.size());
        TrustBundle addedBundle = (TrustBundle)bundles.iterator().next();
        Assert.assertEquals((Object)"Test Bundle", (Object)addedBundle.getBundleName());
        Assert.assertEquals((Object)"http://testBundle/bundle.p7b", (Object)addedBundle.getBundleURL());
        Assert.assertEquals((Object)"12345", (Object)addedBundle.getCheckSum());
        Assert.assertEquals((Object)"12345", (Object)addedBundle.getCheckSum());
        Assert.assertEquals((long)5L, (long)addedBundle.getRefreshInterval());
        Assert.assertTrue((now.getTimeInMillis() <= addedBundle.getCreateTime().getTimeInMillis() ? 1 : 0) != 0);
        Assert.assertNull((Object)addedBundle.getLastRefreshAttempt());
        Assert.assertNull((Object)addedBundle.getLastSuccessfulRefresh());
        Assert.assertNull((Object)addedBundle.getLastRefreshError());
        Assert.assertNotNull((Object)addedBundle.getSigningCertificateData());
        Assert.assertTrue((boolean)addedBundle.getTrustBundleAnchors().isEmpty());
        Assert.assertNotNull((Object)addedBundle.toSigningCertificate());
    }

    @Test
    public void testGetTrustBundles_multipeEntriesInBundleStore_noAnchors_assertBundlesRetrieved() {
        Calendar now = Calendar.getInstance(Locale.getDefault());
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle1");
        bundle.setBundleURL("http://testBundle/bundle1.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        this.tbDao.addTrustBundle(bundle);
        bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle2");
        bundle.setBundleURL("http://testBundle/bundle2.p7b");
        bundle.setRefreshInterval(6);
        bundle.setCheckSum("67890");
        this.tbDao.addTrustBundle(bundle);
        Collection bundles = this.tbDao.getTrustBundles();
        Assert.assertEquals((long)2L, (long)bundles.size());
        Iterator iter = bundles.iterator();
        TrustBundle addedBundle = (TrustBundle)iter.next();
        Assert.assertEquals((Object)"Test Bundle1", (Object)addedBundle.getBundleName());
        Assert.assertEquals((Object)"http://testBundle/bundle1.p7b", (Object)addedBundle.getBundleURL());
        Assert.assertEquals((Object)"12345", (Object)addedBundle.getCheckSum());
        Assert.assertEquals((long)5L, (long)addedBundle.getRefreshInterval());
        Assert.assertTrue((now.getTimeInMillis() <= addedBundle.getCreateTime().getTimeInMillis() ? 1 : 0) != 0);
        Assert.assertNull((Object)addedBundle.getLastRefreshAttempt());
        Assert.assertNull((Object)addedBundle.getLastSuccessfulRefresh());
        Assert.assertNull((Object)addedBundle.getLastRefreshError());
        Assert.assertNull((Object)addedBundle.getSigningCertificateData());
        Assert.assertTrue((boolean)addedBundle.getTrustBundleAnchors().isEmpty());
        addedBundle = (TrustBundle)iter.next();
        Assert.assertEquals((Object)"Test Bundle2", (Object)addedBundle.getBundleName());
        Assert.assertEquals((Object)"http://testBundle/bundle2.p7b", (Object)addedBundle.getBundleURL());
        Assert.assertEquals((Object)"67890", (Object)addedBundle.getCheckSum());
        Assert.assertEquals((long)6L, (long)addedBundle.getRefreshInterval());
        Assert.assertTrue((now.getTimeInMillis() <= addedBundle.getCreateTime().getTimeInMillis() ? 1 : 0) != 0);
        Assert.assertNull((Object)addedBundle.getLastRefreshAttempt());
        Assert.assertNull((Object)addedBundle.getLastSuccessfulRefresh());
        Assert.assertNull((Object)addedBundle.getLastRefreshError());
        Assert.assertNull((Object)addedBundle.getSigningCertificateData());
        Assert.assertTrue((boolean)addedBundle.getTrustBundleAnchors().isEmpty());
    }

    @Test
    public void testGetTrustBundles_singleEntryInBundleStore_singleAnchor_assertBundlesRetrieved() throws Exception {
        Calendar now = Calendar.getInstance(Locale.getDefault());
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        TrustBundleAnchor anchor = new TrustBundleAnchor();
        anchor.setData(TrustBundleDaoImpl_getBundlesTest.loadCertificateData("secureHealthEmailCACert.der"));
        anchor.setTrustBundle(bundle);
        bundle.setTrustBundleAnchors(Arrays.asList(anchor));
        this.tbDao.addTrustBundle(bundle);
        Collection bundles = this.tbDao.getTrustBundles();
        Assert.assertEquals((long)1L, (long)bundles.size());
        TrustBundle addedBundle = (TrustBundle)bundles.iterator().next();
        Assert.assertEquals((Object)"Test Bundle", (Object)addedBundle.getBundleName());
        Assert.assertEquals((Object)"http://testBundle/bundle.p7b", (Object)addedBundle.getBundleURL());
        Assert.assertEquals((Object)"12345", (Object)addedBundle.getCheckSum());
        Assert.assertEquals((long)5L, (long)addedBundle.getRefreshInterval());
        Assert.assertTrue((now.getTimeInMillis() <= addedBundle.getCreateTime().getTimeInMillis() ? 1 : 0) != 0);
        Assert.assertNull((Object)addedBundle.getLastRefreshAttempt());
        Assert.assertNull((Object)addedBundle.getLastSuccessfulRefresh());
        Assert.assertNull((Object)addedBundle.getLastRefreshError());
        Assert.assertNull((Object)addedBundle.getSigningCertificateData());
        Assert.assertEquals((long)1L, (long)addedBundle.getTrustBundleAnchors().size());
        TrustBundleAnchor addedAnchor = (TrustBundleAnchor)addedBundle.getTrustBundleAnchors().iterator().next();
        Assert.assertNotNull((Object)addedAnchor.toCertificate());
        Assert.assertEquals((Object)anchor.toCertificate(), (Object)addedAnchor.toCertificate());
        Assert.assertEquals((Object)Thumbprint.toThumbprint((X509Certificate)anchor.toCertificate()).toString(), (Object)addedAnchor.getThumbprint());
        Assert.assertEquals((Object)anchor.toCertificate().getNotAfter(), (Object)addedAnchor.getValidEndDate().getTime());
        Assert.assertEquals((Object)anchor.toCertificate().getNotBefore(), (Object)addedAnchor.getValidStartDate().getTime());
        Assert.assertEquals((Object)anchor.getTrustBundle().getBundleName(), (Object)bundle.getBundleName());
        Assert.assertEquals((long)anchor.getTrustBundle().getId(), (long)addedBundle.getId());
    }

    @Test
    public void testGetTrustBundles_exceptionInQuery_assertException() {
        EntityManager manager = (EntityManager)Mockito.mock(EntityManager.class);
        ((EntityManager)Mockito.doThrow((Throwable)new RuntimeException("Just Passing Through")).when((Object)manager)).createQuery((String)Matchers.any());
        TrustBundleDaoImpl dao = new TrustBundleDaoImpl();
        dao.setEntityManager(manager);
        boolean exceptionOccured = false;
        try {
            dao.getTrustBundles();
        }
        catch (ConfigurationStoreException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testGetTrustBundles_noEntityManager_assertException() {
        TrustBundleDaoImpl dao = new TrustBundleDaoImpl();
        boolean exceptionOccured = false;
        try {
            dao.getTrustBundles();
        }
        catch (IllegalStateException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }
}

