/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.util.Collection;
import java.util.Iterator;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.nhindirect.config.store.ConfigurationStoreException;
import org.nhindirect.config.store.Domain;
import org.nhindirect.config.store.TrustBundle;
import org.nhindirect.config.store.TrustBundleDaoBaseTest;
import org.nhindirect.config.store.TrustBundleDomainReltn;
import org.nhindirect.config.store.dao.DomainDao;
import org.nhindirect.config.store.dao.impl.TrustBundleDaoImpl;

public class TrustBundleDaoImpl_getTrustBundlesByDomainTest
extends TrustBundleDaoBaseTest {
    @Test
    public void testGetTrustBundlesByDomain_associationsExist_assertBundlesRetrieved() {
        Domain domain = new Domain();
        domain.setDomainName("Test Domain");
        this.dmDao.add(domain);
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://test/url/bundle");
        bundle.setCheckSum("1234");
        this.tbDao.addTrustBundle(bundle);
        this.tbDao.associateTrustBundleToDomain(domain.getId().longValue(), bundle.getId(), true, true);
        Collection bundles = this.tbDao.getTrustBundlesByDomain(domain.getId().longValue());
        Assert.assertEquals((long)1L, (long)bundles.size());
    }

    @Test
    public void testGetTrustBundlesByDomain_multipleAssociationsExist_assertBundlesRetrieved() {
        Domain domain = new Domain();
        domain.setDomainName("Test Domain");
        this.dmDao.add(domain);
        TrustBundle bundle1 = new TrustBundle();
        bundle1.setBundleName("Test Bundle1");
        bundle1.setBundleURL("http://test/url/bundle1");
        bundle1.setCheckSum("1234");
        this.tbDao.addTrustBundle(bundle1);
        TrustBundle bundle2 = new TrustBundle();
        bundle2.setBundleName("Test Bundle2");
        bundle2.setBundleURL("http://test/url/bundle2");
        bundle2.setCheckSum("1234");
        this.tbDao.addTrustBundle(bundle2);
        this.tbDao.associateTrustBundleToDomain(domain.getId().longValue(), bundle1.getId(), true, true);
        this.tbDao.associateTrustBundleToDomain(domain.getId().longValue(), bundle2.getId(), true, true);
        Collection bundles = this.tbDao.getTrustBundlesByDomain(domain.getId().longValue());
        Assert.assertEquals((long)2L, (long)bundles.size());
        Iterator bundleIter = bundles.iterator();
        Assert.assertEquals((Object)bundle1.getBundleName(), (Object)((TrustBundleDomainReltn)bundleIter.next()).getTrustBundle().getBundleName());
        Assert.assertEquals((Object)bundle2.getBundleName(), (Object)((TrustBundleDomainReltn)bundleIter.next()).getTrustBundle().getBundleName());
    }

    @Test
    public void testGetTrustBundlesByDomain_multipleAssociationsExist_oneToEachDomain_assertBundlesRetrieved() {
        Domain domain1 = new Domain();
        domain1.setDomainName("Test Domain 1");
        this.dmDao.add(domain1);
        Domain domain2 = new Domain();
        domain2.setDomainName("Test Domain 2");
        this.dmDao.add(domain2);
        TrustBundle bundle1 = new TrustBundle();
        bundle1.setBundleName("Test Bundle1");
        bundle1.setBundleURL("http://test/url/bundle1");
        bundle1.setCheckSum("1234");
        this.tbDao.addTrustBundle(bundle1);
        TrustBundle bundle2 = new TrustBundle();
        bundle2.setBundleName("Test Bundle2");
        bundle2.setBundleURL("http://test/url/bundle2");
        bundle2.setCheckSum("1234");
        this.tbDao.addTrustBundle(bundle2);
        this.tbDao.associateTrustBundleToDomain(domain1.getId().longValue(), bundle1.getId(), true, true);
        this.tbDao.associateTrustBundleToDomain(domain2.getId().longValue(), bundle2.getId(), true, true);
        Collection bundles = this.tbDao.getTrustBundlesByDomain(domain1.getId().longValue());
        Assert.assertEquals((long)1L, (long)bundles.size());
        Iterator bundleIter = bundles.iterator();
        Assert.assertEquals((Object)bundle1.getBundleName(), (Object)((TrustBundleDomainReltn)bundleIter.next()).getTrustBundle().getBundleName());
        bundles = this.tbDao.getTrustBundlesByDomain(domain2.getId().longValue());
        Assert.assertEquals((long)1L, (long)bundles.size());
        bundleIter = bundles.iterator();
        Assert.assertEquals((Object)bundle2.getBundleName(), (Object)((TrustBundleDomainReltn)bundleIter.next()).getTrustBundle().getBundleName());
    }

    @Test
    public void testGetTrustBundlesByDomain_multipleAssociationsExist_bundleToMultipeDomains_assertBundlesRetrieved() {
        Domain domain1 = new Domain();
        domain1.setDomainName("Test Domain 1");
        this.dmDao.add(domain1);
        Domain domain2 = new Domain();
        domain2.setDomainName("Test Domain 2");
        this.dmDao.add(domain2);
        TrustBundle bundle1 = new TrustBundle();
        bundle1.setBundleName("Test Bundle1");
        bundle1.setBundleURL("http://test/url/bundle1");
        bundle1.setCheckSum("1234");
        this.tbDao.addTrustBundle(bundle1);
        this.tbDao.associateTrustBundleToDomain(domain1.getId().longValue(), bundle1.getId(), true, true);
        this.tbDao.associateTrustBundleToDomain(domain2.getId().longValue(), bundle1.getId(), true, true);
        Collection bundles = this.tbDao.getTrustBundlesByDomain(domain1.getId().longValue());
        Assert.assertEquals((long)1L, (long)bundles.size());
        Iterator bundleIter = bundles.iterator();
        Assert.assertEquals((Object)bundle1.getBundleName(), (Object)((TrustBundleDomainReltn)bundleIter.next()).getTrustBundle().getBundleName());
        bundles = this.tbDao.getTrustBundlesByDomain(domain2.getId().longValue());
        Assert.assertEquals((long)1L, (long)bundles.size());
        bundleIter = bundles.iterator();
        Assert.assertEquals((Object)bundle1.getBundleName(), (Object)((TrustBundleDomainReltn)bundleIter.next()).getTrustBundle().getBundleName());
    }

    @Test
    public void testGetTrustBundlesByDomain_noBundlesInDomain_assertBundlesNotRetrieved() {
        Domain domain1 = new Domain();
        domain1.setDomainName("Test Domain 1");
        this.dmDao.add(domain1);
        Collection bundles = this.tbDao.getTrustBundlesByDomain(domain1.getId().longValue());
        Assert.assertEquals((long)0L, (long)bundles.size());
    }

    @Test
    public void testGetTrustBundlesByDomain_unknownDomain_assertException() {
        boolean exceptionOccured = false;
        try {
            this.tbDao.getTrustBundlesByDomain(1234L);
        }
        catch (ConfigurationStoreException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testGetTrustBundlesByDomain_noEntityManager_assertException() {
        TrustBundleDaoImpl dao = new TrustBundleDaoImpl();
        boolean exceptionOccured = false;
        try {
            dao.getTrustBundlesByDomain(1234L);
        }
        catch (IllegalStateException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testGetTrustBundlesByDomain_errorInGet_assertException() {
        boolean exceptionOccured = false;
        EntityManager mgr = (EntityManager)Mockito.mock(EntityManager.class);
        Domain domain = (Domain)Mockito.mock(Domain.class);
        DomainDao domainDao = (DomainDao)Mockito.mock(DomainDao.class);
        Mockito.when((Object)domainDao.getDomain(new Long(1234L))).thenReturn((Object)domain);
        TrustBundleDomainReltn reltn = (TrustBundleDomainReltn)Mockito.mock(TrustBundleDomainReltn.class);
        Query findReltnQeury = (Query)Mockito.mock(Query.class);
        Mockito.when((Object)findReltnQeury.getSingleResult()).thenReturn((Object)reltn);
        ((Query)Mockito.doThrow((Throwable)new RuntimeException("Just Passing Through")).when((Object)findReltnQeury)).getResultList();
        Mockito.when((Object)mgr.createQuery("SELECT tbd from TrustBundleDomainReltn tbd where tbd.domain = ?1")).thenReturn((Object)findReltnQeury);
        TrustBundleDaoImpl dao = new TrustBundleDaoImpl();
        dao.setDomainDao(domainDao);
        dao.setEntityManager(mgr);
        TrustBundleDaoImpl spyDao = (TrustBundleDaoImpl)Mockito.spy((Object)dao);
        try {
            spyDao.getTrustBundlesByDomain(1234L);
        }
        catch (ConfigurationStoreException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        ((DomainDao)Mockito.verify((Object)domainDao, (VerificationMode)Mockito.times((int)1))).getDomain(new Long(1234L));
        ((Query)Mockito.verify((Object)findReltnQeury, (VerificationMode)Mockito.times((int)1))).getResultList();
    }
}

