/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.util.Calendar;
import java.util.Locale;
import javax.persistence.EntityManager;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.nhindirect.config.store.BundleRefreshError;
import org.nhindirect.config.store.ConfigurationStoreException;
import org.nhindirect.config.store.TrustBundle;
import org.nhindirect.config.store.TrustBundleDaoBaseTest;
import org.nhindirect.config.store.dao.impl.TrustBundleDaoImpl;

public class TrustBundleDaoImpl_updateLastUpdateErrorTest
extends TrustBundleDaoBaseTest {
    @Test
    public void testUpdateLastUpdateError_updateUpdate_assertErrorUpdate() {
        Calendar now = Calendar.getInstance(Locale.getDefault());
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        this.tbDao.addTrustBundle(bundle);
        this.tbDao.updateLastUpdateError(bundle.getId(), now, BundleRefreshError.SUCCESS);
        TrustBundle updatedBundle = this.tbDao.getTrustBundleById(bundle.getId());
        Assert.assertEquals((Object)BundleRefreshError.SUCCESS, (Object)updatedBundle.getLastRefreshError());
        Assert.assertEquals((Object)now, (Object)updatedBundle.getLastRefreshAttempt());
        this.tbDao.updateLastUpdateError(bundle.getId(), now, BundleRefreshError.NOT_FOUND);
        updatedBundle = this.tbDao.getTrustBundleById(bundle.getId());
        Assert.assertEquals((Object)BundleRefreshError.NOT_FOUND, (Object)updatedBundle.getLastRefreshError());
    }

    @Test
    public void testUpdateLastUpdateError_bundleDoesntExist_assertException() {
        Calendar now = Calendar.getInstance(Locale.getDefault());
        boolean exceptionOccured = false;
        try {
            this.tbDao.updateLastUpdateError(1234L, now, BundleRefreshError.NOT_FOUND);
        }
        catch (ConfigurationStoreException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testUpdateLastUpdateError_exceptionInQuery_assertException() {
        Calendar now = Calendar.getInstance(Locale.getDefault());
        EntityManager manager = (EntityManager)Mockito.mock(EntityManager.class);
        ((EntityManager)Mockito.doThrow((Throwable)new RuntimeException("Just Passing Through")).when((Object)manager)).createQuery((String)Matchers.any());
        TrustBundleDaoImpl dao = new TrustBundleDaoImpl();
        dao.setEntityManager(manager);
        boolean exceptionOccured = false;
        try {
            this.tbDao.updateLastUpdateError(1234L, now, BundleRefreshError.NOT_FOUND);
        }
        catch (ConfigurationStoreException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testUpdateLastUpdateError_noEntityManager_assertException() {
        Calendar now = Calendar.getInstance(Locale.getDefault());
        TrustBundleDaoImpl dao = new TrustBundleDaoImpl();
        boolean exceptionOccured = false;
        try {
            dao.updateLastUpdateError(1234L, now, BundleRefreshError.NOT_FOUND);
        }
        catch (IllegalStateException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }
}

