/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Locale;
import javax.persistence.EntityManager;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.nhindirect.config.store.ConfigurationStoreException;
import org.nhindirect.config.store.TrustBundle;
import org.nhindirect.config.store.TrustBundleAnchor;
import org.nhindirect.config.store.TrustBundleDaoBaseTest;
import org.nhindirect.config.store.dao.impl.TrustBundleDaoImpl;

public class TrustBundleDaoImpl_updateTrustBundleAnchorsTest
extends TrustBundleDaoBaseTest {
    @Test
    public void testUpdateTrustBundleAnchors_addNewAnchors_assertNewAnchors() throws Exception {
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        this.tbDao.addTrustBundle(bundle);
        TrustBundleAnchor anchor = new TrustBundleAnchor();
        anchor.setData(TrustBundleDaoImpl_updateTrustBundleAnchorsTest.loadCertificateData("secureHealthEmailCACert.der"));
        anchor.setTrustBundle(bundle);
        this.tbDao.updateTrustBundleAnchors(bundle.getId(), Calendar.getInstance(Locale.getDefault()), Arrays.asList(anchor), "6789");
        TrustBundle addedBundle = this.tbDao.getTrustBundleById(bundle.getId());
        Assert.assertEquals((long)1L, (long)addedBundle.getTrustBundleAnchors().size());
        TrustBundleAnchor addedAnchor = (TrustBundleAnchor)addedBundle.getTrustBundleAnchors().iterator().next();
        Assert.assertEquals((Object)anchor.toCertificate(), (Object)addedAnchor.toCertificate());
    }

    @Test
    public void testUpdateTrustBundleAnchors_addAdditionalAnchors_assertNewAnchors() throws Exception {
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        TrustBundleAnchor anchor = new TrustBundleAnchor();
        anchor.setData(TrustBundleDaoImpl_updateTrustBundleAnchorsTest.loadCertificateData("secureHealthEmailCACert.der"));
        anchor.setTrustBundle(bundle);
        bundle.setTrustBundleAnchors(Arrays.asList(anchor));
        this.tbDao.addTrustBundle(bundle);
        TrustBundleAnchor additionalAnchor = new TrustBundleAnchor();
        additionalAnchor.setData(TrustBundleDaoImpl_updateTrustBundleAnchorsTest.loadCertificateData("umesh.der"));
        additionalAnchor.setTrustBundle(bundle);
        this.tbDao.updateTrustBundleAnchors(bundle.getId(), Calendar.getInstance(Locale.getDefault()), Arrays.asList(anchor, additionalAnchor), "6789");
        TrustBundle addedBundle = this.tbDao.getTrustBundleById(bundle.getId());
        Assert.assertEquals((Object)"6789", (Object)addedBundle.getCheckSum());
        Assert.assertEquals((long)2L, (long)addedBundle.getTrustBundleAnchors().size());
        Iterator iter = addedBundle.getTrustBundleAnchors().iterator();
        TrustBundleAnchor addedAnchor = (TrustBundleAnchor)iter.next();
        Assert.assertEquals((Object)anchor.toCertificate(), (Object)addedAnchor.toCertificate());
        addedAnchor = (TrustBundleAnchor)iter.next();
        Assert.assertEquals((Object)additionalAnchor.toCertificate(), (Object)addedAnchor.toCertificate());
    }

    @Test
    public void testUpdateTrustBundleAnchors_addSwapAnchors_assertNewAnchors() throws Exception {
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        TrustBundleAnchor anchor = new TrustBundleAnchor();
        anchor.setData(TrustBundleDaoImpl_updateTrustBundleAnchorsTest.loadCertificateData("secureHealthEmailCACert.der"));
        anchor.setTrustBundle(bundle);
        bundle.setTrustBundleAnchors(Arrays.asList(anchor));
        this.tbDao.addTrustBundle(bundle);
        TrustBundle addedBundle = this.tbDao.getTrustBundleById(bundle.getId());
        Assert.assertEquals((long)1L, (long)addedBundle.getTrustBundleAnchors().size());
        TrustBundleAnchor newAnchor = new TrustBundleAnchor();
        newAnchor.setData(TrustBundleDaoImpl_updateTrustBundleAnchorsTest.loadCertificateData("umesh.der"));
        newAnchor.setTrustBundle(bundle);
        this.tbDao.updateTrustBundleAnchors(bundle.getId(), Calendar.getInstance(Locale.getDefault()), Arrays.asList(newAnchor), "6789");
        addedBundle = this.tbDao.getTrustBundleById(bundle.getId());
        Assert.assertEquals((long)1L, (long)addedBundle.getTrustBundleAnchors().size());
        TrustBundleAnchor addedAnchor = (TrustBundleAnchor)addedBundle.getTrustBundleAnchors().iterator().next();
        Assert.assertEquals((Object)newAnchor.toCertificate(), (Object)addedAnchor.toCertificate());
    }

    @Test
    public void testUpdateTrustBundleAnchors_bundleDoenstExist_assertException() throws Exception {
        boolean exceptionOccured = false;
        try {
            this.tbDao.updateTrustBundleAnchors(1234L, Calendar.getInstance(Locale.getDefault()), new ArrayList(), "6789");
        }
        catch (ConfigurationStoreException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testUpdateTrustBundleAnchors_exceptionInQuery_assertException() {
        EntityManager manager = (EntityManager)Mockito.mock(EntityManager.class);
        ((EntityManager)Mockito.doThrow((Throwable)new RuntimeException("Just Passing Through")).when((Object)manager)).createQuery((String)Matchers.any());
        TrustBundleDaoImpl dao = new TrustBundleDaoImpl();
        dao.setEntityManager(manager);
        boolean exceptionOccured = false;
        try {
            dao.updateTrustBundleAnchors(1234L, Calendar.getInstance(Locale.getDefault()), new ArrayList(), "6789");
        }
        catch (ConfigurationStoreException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testUpdateTrustBundleAnchors_noEntityManager_assertException() {
        TrustBundleDaoImpl dao = new TrustBundleDaoImpl();
        boolean exceptionOccured = false;
        try {
            dao.updateTrustBundleAnchors(1234L, Calendar.getInstance(Locale.getDefault()), new ArrayList(), "6789");
        }
        catch (IllegalStateException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }
}

