/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import javax.persistence.EntityManager;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.nhindirect.config.store.ConfigurationStoreException;
import org.nhindirect.config.store.TrustBundle;
import org.nhindirect.config.store.TrustBundleAnchor;
import org.nhindirect.config.store.TrustBundleDaoBaseTest;
import org.nhindirect.config.store.dao.impl.TrustBundleDaoImpl;

public class TrustBundleDaoImpl_updateTrustBundleAttributesTest
extends TrustBundleDaoBaseTest {
    @Test
    public void testTrustBundleAttributes_updateCert_assertCertUpdated() throws Exception {
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        this.tbDao.addTrustBundle(bundle);
        TrustBundleAnchor anchor = new TrustBundleAnchor();
        anchor.setData(TrustBundleDaoImpl_updateTrustBundleAttributesTest.loadCertificateData("secureHealthEmailCACert.der"));
        this.tbDao.updateTrustBundleAttributes(bundle.getId(), bundle.getBundleName(), bundle.getBundleURL(), anchor.toCertificate(), bundle.getRefreshInterval());
        TrustBundle updatedBundle = this.tbDao.getTrustBundleById(bundle.getId());
        Assert.assertEquals((Object)bundle.getBundleName(), (Object)updatedBundle.getBundleName());
        Assert.assertEquals((Object)bundle.getBundleURL(), (Object)updatedBundle.getBundleURL());
        Assert.assertEquals((long)bundle.getRefreshInterval(), (long)updatedBundle.getRefreshInterval());
        Assert.assertEquals((long)bundle.getTrustBundleAnchors().size(), (long)updatedBundle.getTrustBundleAnchors().size());
        Assert.assertEquals((Object)anchor.toCertificate(), (Object)updatedBundle.toSigningCertificate());
    }

    @Test
    public void testTrustBundleAttributes_updateCert_setNull_assertCertNull() throws Exception {
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        bundle.setSigningCertificateData(TrustBundleDaoImpl_updateTrustBundleAttributesTest.loadCertificateData("secureHealthEmailCACert.der"));
        this.tbDao.addTrustBundle(bundle);
        this.tbDao.updateTrustBundleSigningCertificate(bundle.getId(), null);
        TrustBundle updatedBundle = this.tbDao.getTrustBundleById(bundle.getId());
        Assert.assertEquals((Object)bundle.getBundleName(), (Object)updatedBundle.getBundleName());
        Assert.assertEquals((Object)bundle.getBundleURL(), (Object)updatedBundle.getBundleURL());
        Assert.assertEquals((long)bundle.getRefreshInterval(), (long)updatedBundle.getRefreshInterval());
        Assert.assertEquals((long)bundle.getTrustBundleAnchors().size(), (long)updatedBundle.getTrustBundleAnchors().size());
        Assert.assertNull((Object)updatedBundle.getSigningCertificateData());
    }

    @Test
    public void testUpdateTrustBundleSigningCertificate_updateBundleName_assertNameUpdate() throws Exception {
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        this.tbDao.addTrustBundle(bundle);
        this.tbDao.updateTrustBundleAttributes(bundle.getId(), "New Test Bundle Name", bundle.getBundleURL(), null, bundle.getRefreshInterval());
        TrustBundle updatedBundle = this.tbDao.getTrustBundleById(bundle.getId());
        Assert.assertEquals((Object)"New Test Bundle Name", (Object)updatedBundle.getBundleName());
        Assert.assertEquals((Object)bundle.getBundleURL(), (Object)updatedBundle.getBundleURL());
        Assert.assertEquals((long)bundle.getRefreshInterval(), (long)updatedBundle.getRefreshInterval());
        Assert.assertNull((Object)updatedBundle.getSigningCertificateData());
        Assert.assertEquals((long)bundle.getTrustBundleAnchors().size(), (long)updatedBundle.getTrustBundleAnchors().size());
    }

    @Test
    public void testUpdateTrustBundleSigningCertificate_updateBundleName_nullName_assertNameNotUpdate() throws Exception {
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        this.tbDao.addTrustBundle(bundle);
        this.tbDao.updateTrustBundleAttributes(bundle.getId(), null, bundle.getBundleURL(), null, bundle.getRefreshInterval());
        TrustBundle updatedBundle = this.tbDao.getTrustBundleById(bundle.getId());
        Assert.assertEquals((Object)bundle.getBundleName(), (Object)updatedBundle.getBundleName());
        Assert.assertEquals((Object)bundle.getBundleURL(), (Object)updatedBundle.getBundleURL());
        Assert.assertEquals((long)bundle.getRefreshInterval(), (long)updatedBundle.getRefreshInterval());
        Assert.assertNull((Object)updatedBundle.getSigningCertificateData());
        Assert.assertEquals((long)bundle.getTrustBundleAnchors().size(), (long)updatedBundle.getTrustBundleAnchors().size());
    }

    @Test
    public void testUpdateTrustBundleSigningCertificate_updateBundleName_emptyName_assertNameNotUpdate() throws Exception {
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        this.tbDao.addTrustBundle(bundle);
        this.tbDao.updateTrustBundleAttributes(bundle.getId(), "", bundle.getBundleURL(), null, bundle.getRefreshInterval());
        TrustBundle updatedBundle = this.tbDao.getTrustBundleById(bundle.getId());
        Assert.assertEquals((Object)bundle.getBundleName(), (Object)updatedBundle.getBundleName());
        Assert.assertEquals((Object)bundle.getBundleURL(), (Object)updatedBundle.getBundleURL());
        Assert.assertEquals((long)bundle.getRefreshInterval(), (long)updatedBundle.getRefreshInterval());
        Assert.assertNull((Object)updatedBundle.getSigningCertificateData());
        Assert.assertEquals((long)bundle.getTrustBundleAnchors().size(), (long)updatedBundle.getTrustBundleAnchors().size());
    }

    @Test
    public void testUpdateTrustBundleSigningCertificate_updateBundleURL_assertURLUpdate() throws Exception {
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        this.tbDao.addTrustBundle(bundle);
        this.tbDao.updateTrustBundleAttributes(bundle.getId(), bundle.getBundleName(), "http://testBundle/bundle.p7b333", null, bundle.getRefreshInterval());
        TrustBundle updatedBundle = this.tbDao.getTrustBundleById(bundle.getId());
        Assert.assertEquals((Object)bundle.getBundleName(), (Object)bundle.getBundleName());
        Assert.assertEquals((Object)"http://testBundle/bundle.p7b333", (Object)updatedBundle.getBundleURL());
        Assert.assertEquals((long)bundle.getRefreshInterval(), (long)updatedBundle.getRefreshInterval());
        Assert.assertNull((Object)updatedBundle.getSigningCertificateData());
        Assert.assertEquals((long)bundle.getTrustBundleAnchors().size(), (long)updatedBundle.getTrustBundleAnchors().size());
    }

    @Test
    public void testUpdateTrustBundleSigningCertificate_updateBundleURL_nullURL_assertUrlNotUpdate() throws Exception {
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        this.tbDao.addTrustBundle(bundle);
        this.tbDao.updateTrustBundleAttributes(bundle.getId(), bundle.getBundleName(), null, null, bundle.getRefreshInterval());
        TrustBundle updatedBundle = this.tbDao.getTrustBundleById(bundle.getId());
        Assert.assertEquals((Object)bundle.getBundleName(), (Object)updatedBundle.getBundleName());
        Assert.assertEquals((Object)bundle.getBundleURL(), (Object)updatedBundle.getBundleURL());
        Assert.assertEquals((long)bundle.getRefreshInterval(), (long)updatedBundle.getRefreshInterval());
        Assert.assertNull((Object)updatedBundle.getSigningCertificateData());
        Assert.assertEquals((long)bundle.getTrustBundleAnchors().size(), (long)updatedBundle.getTrustBundleAnchors().size());
    }

    @Test
    public void testUpdateTrustBundleSigningCertificate_updateBundleURL_emptyURL_assertUrlNotUpdate() throws Exception {
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        this.tbDao.addTrustBundle(bundle);
        this.tbDao.updateTrustBundleAttributes(bundle.getId(), bundle.getBundleName(), "", null, bundle.getRefreshInterval());
        TrustBundle updatedBundle = this.tbDao.getTrustBundleById(bundle.getId());
        Assert.assertEquals((Object)bundle.getBundleName(), (Object)updatedBundle.getBundleName());
        Assert.assertEquals((Object)bundle.getBundleURL(), (Object)updatedBundle.getBundleURL());
        Assert.assertEquals((long)bundle.getRefreshInterval(), (long)updatedBundle.getRefreshInterval());
        Assert.assertNull((Object)updatedBundle.getSigningCertificateData());
        Assert.assertEquals((long)bundle.getTrustBundleAnchors().size(), (long)updatedBundle.getTrustBundleAnchors().size());
    }

    @Test
    public void testUpdateTrustBundleSigningCertificate_updateBundleRefreshInterval_assertIntervalUpdate() throws Exception {
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        this.tbDao.addTrustBundle(bundle);
        this.tbDao.updateTrustBundleAttributes(bundle.getId(), bundle.getBundleName(), bundle.getBundleURL(), null, 7);
        TrustBundle updatedBundle = this.tbDao.getTrustBundleById(bundle.getId());
        Assert.assertEquals((Object)bundle.getBundleName(), (Object)updatedBundle.getBundleName());
        Assert.assertEquals((Object)bundle.getBundleURL(), (Object)updatedBundle.getBundleURL());
        Assert.assertEquals((long)7L, (long)updatedBundle.getRefreshInterval());
        Assert.assertNull((Object)updatedBundle.getSigningCertificateData());
        Assert.assertEquals((long)bundle.getTrustBundleAnchors().size(), (long)updatedBundle.getTrustBundleAnchors().size());
    }

    @Test
    public void testUpdateTrustBundleAttributes_bundleDoesntExist_assertException() throws Exception {
        boolean exceptionOccured = false;
        try {
            TrustBundleAnchor anchor = new TrustBundleAnchor();
            anchor.setData(TrustBundleDaoImpl_updateTrustBundleAttributesTest.loadCertificateData("secureHealthEmailCACert.der"));
            this.tbDao.updateTrustBundleSigningCertificate(1234L, anchor.toCertificate());
        }
        catch (ConfigurationStoreException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testUpdateTrustBundleAttributes_exceptionInQuery_assertException() throws Exception {
        EntityManager manager = (EntityManager)Mockito.mock(EntityManager.class);
        ((EntityManager)Mockito.doThrow((Throwable)new RuntimeException("Just Passing Through")).when((Object)manager)).createQuery((String)Matchers.any());
        TrustBundleDaoImpl dao = new TrustBundleDaoImpl();
        dao.setEntityManager(manager);
        boolean exceptionOccured = false;
        try {
            TrustBundleAnchor anchor = new TrustBundleAnchor();
            anchor.setData(TrustBundleDaoImpl_updateTrustBundleAttributesTest.loadCertificateData("secureHealthEmailCACert.der"));
            this.tbDao.updateTrustBundleSigningCertificate(1234L, anchor.toCertificate());
        }
        catch (ConfigurationStoreException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testUpdateTrustBundleAttributes_noEntityManager_assertException() throws Exception {
        TrustBundleDaoImpl dao = new TrustBundleDaoImpl();
        boolean exceptionOccured = false;
        try {
            TrustBundleAnchor anchor = new TrustBundleAnchor();
            anchor.setData(TrustBundleDaoImpl_updateTrustBundleAttributesTest.loadCertificateData("secureHealthEmailCACert.der"));
            dao.updateTrustBundleSigningCertificate(1234L, anchor.toCertificate());
        }
        catch (IllegalStateException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }
}

