/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import javax.persistence.EntityManager;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.nhindirect.config.store.ConfigurationStoreException;
import org.nhindirect.config.store.TrustBundle;
import org.nhindirect.config.store.TrustBundleAnchor;
import org.nhindirect.config.store.TrustBundleDaoBaseTest;
import org.nhindirect.config.store.dao.impl.TrustBundleDaoImpl;

public class TrustBundleDaoImpl_updateTrustBundleSigningCertificateTest
extends TrustBundleDaoBaseTest {
    @Test
    public void testUpdateTrustBundleSigningCertificate_updateSigningCert_assertCertUpdated() throws Exception {
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        this.tbDao.addTrustBundle(bundle);
        TrustBundleAnchor anchor = new TrustBundleAnchor();
        anchor.setData(TrustBundleDaoImpl_updateTrustBundleSigningCertificateTest.loadCertificateData("secureHealthEmailCACert.der"));
        this.tbDao.updateTrustBundleSigningCertificate(bundle.getId(), anchor.toCertificate());
        TrustBundle updatedBundle = this.tbDao.getTrustBundleById(bundle.getId());
        Assert.assertEquals((Object)anchor.toCertificate(), (Object)updatedBundle.toSigningCertificate());
    }

    @Test
    public void testUpdateTrustBundleSigningCertificate_updateCert_setNull_assertBundleUpdate() throws Exception {
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        bundle.setSigningCertificateData(TrustBundleDaoImpl_updateTrustBundleSigningCertificateTest.loadCertificateData("secureHealthEmailCACert.der"));
        this.tbDao.addTrustBundle(bundle);
        this.tbDao.updateTrustBundleSigningCertificate(bundle.getId(), null);
        TrustBundle updatedBundle = this.tbDao.getTrustBundleById(bundle.getId());
        Assert.assertNull((Object)updatedBundle.getSigningCertificateData());
    }

    @Test
    public void testUpdateTrustBundleSigningCertificate_bundleDoesntExist_assertException() throws Exception {
        boolean exceptionOccured = false;
        try {
            TrustBundleAnchor anchor = new TrustBundleAnchor();
            anchor.setData(TrustBundleDaoImpl_updateTrustBundleSigningCertificateTest.loadCertificateData("secureHealthEmailCACert.der"));
            this.tbDao.updateTrustBundleSigningCertificate(1234L, anchor.toCertificate());
        }
        catch (ConfigurationStoreException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testUpdateTrustBundleSigningCertificate_exceptionInQuery_assertException() throws Exception {
        EntityManager manager = (EntityManager)Mockito.mock(EntityManager.class);
        ((EntityManager)Mockito.doThrow((Throwable)new RuntimeException("Just Passing Through")).when((Object)manager)).createQuery((String)Matchers.any());
        TrustBundleDaoImpl dao = new TrustBundleDaoImpl();
        dao.setEntityManager(manager);
        boolean exceptionOccured = false;
        try {
            TrustBundleAnchor anchor = new TrustBundleAnchor();
            anchor.setData(TrustBundleDaoImpl_updateTrustBundleSigningCertificateTest.loadCertificateData("secureHealthEmailCACert.der"));
            this.tbDao.updateTrustBundleSigningCertificate(1234L, anchor.toCertificate());
        }
        catch (ConfigurationStoreException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testUpdateTrustBundleSigningCertificate_noEntityManager_assertException() throws Exception {
        TrustBundleDaoImpl dao = new TrustBundleDaoImpl();
        boolean exceptionOccured = false;
        try {
            TrustBundleAnchor anchor = new TrustBundleAnchor();
            anchor.setData(TrustBundleDaoImpl_updateTrustBundleSigningCertificateTest.loadCertificateData("secureHealthEmailCACert.der"));
            dao.updateTrustBundleSigningCertificate(1234L, anchor.toCertificate());
        }
        catch (IllegalStateException ex) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }
}

