/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store.dao.impl;

import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.config.store.CertPolicy;
import org.nhindirect.config.store.CertPolicyGroup;
import org.nhindirect.config.store.CertPolicyGroupDomainReltn;
import org.nhindirect.config.store.CertPolicyGroupReltn;
import org.nhindirect.config.store.CertPolicyUse;
import org.nhindirect.config.store.ConfigurationStoreException;
import org.nhindirect.config.store.Domain;
import org.nhindirect.config.store.dao.CertPolicyDao;
import org.nhindirect.config.store.dao.DomainDao;
import org.nhindirect.policy.PolicyLexicon;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class CertPolicyDaoImpl
implements CertPolicyDao {
    @PersistenceContext
    @Autowired
    private EntityManager entityManager;
    protected DomainDao domainDao;
    private static final Log log = LogFactory.getLog(CertPolicyDaoImpl.class);

    @Autowired
    public void setDomainDao(DomainDao domainDao) {
        this.domainDao = domainDao;
    }

    protected void validateState() throws ConfigurationStoreException {
        if (this.entityManager == null) {
            throw new IllegalStateException("entityManger has not been initialized");
        }
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    @Transactional(readOnly=true)
    public Collection<CertPolicy> getPolicies() throws ConfigurationStoreException {
        this.validateState();
        try {
            Query select = this.entityManager.createQuery("SELECT cp from CertPolicy cp");
            List rs = select.getResultList();
            if (rs.size() == 0) {
                return Collections.emptyList();
            }
            return rs;
        }
        catch (Exception e) {
            throw new ConfigurationStoreException("Failed to execute certificate policy DAO query.", e);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public CertPolicy getPolicyByName(String policyName) throws ConfigurationStoreException {
        this.validateState();
        try {
            Query select = this.entityManager.createQuery("SELECT cp from CertPolicy cp WHERE UPPER(cp.policyName) = ?1");
            select.setParameter(1, (Object)policyName.toUpperCase(Locale.getDefault()));
            CertPolicy rs = (CertPolicy)select.getSingleResult();
            return rs;
        }
        catch (NoResultException e) {
            return null;
        }
        catch (Exception e) {
            throw new ConfigurationStoreException("Failed to execute certificate policy DAO query.", e);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public CertPolicy getPolicyById(long id) throws ConfigurationStoreException {
        this.validateState();
        try {
            Query select = this.entityManager.createQuery("SELECT cp from CertPolicy cp WHERE cp.id = ?1");
            select.setParameter(1, (Object)id);
            CertPolicy rs = (CertPolicy)select.getSingleResult();
            return rs;
        }
        catch (NoResultException e) {
            return null;
        }
        catch (Exception e) {
            throw new ConfigurationStoreException("Failed to execute certificate policy DAO query.", e);
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void addPolicy(CertPolicy policy) throws ConfigurationStoreException {
        this.validateState();
        try {
            CertPolicy existingPolicy = this.getPolicyByName(policy.getPolicyName());
            if (existingPolicy != null) {
                throw new ConfigurationStoreException("Certificate policy " + policy.getPolicyName() + " already exists");
            }
            policy.setCreateTime(Calendar.getInstance(Locale.getDefault()));
            this.entityManager.persist((Object)policy);
            this.entityManager.flush();
        }
        catch (ConfigurationStoreException cse) {
            throw cse;
        }
        catch (Exception e) {
            throw new ConfigurationStoreException("Failed to add certificate policy " + policy.getPolicyName(), e);
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void deletePolicies(long[] policyIds) throws ConfigurationStoreException {
        this.validateState();
        if (policyIds == null || policyIds.length == 0) {
            return;
        }
        for (long id : policyIds) {
            try {
                CertPolicy bundle = this.getPolicyById(id);
                this.removePolicyUseFromGroups(id);
                this.entityManager.remove((Object)bundle);
                this.entityManager.flush();
            }
            catch (ConfigurationStoreException e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Transactional(readOnly=false)
    public void removePolicyUseFromGroups(long policyId) throws ConfigurationStoreException {
        this.validateState();
        CertPolicy policy = this.getPolicyById(policyId);
        if (policy == null) {
            throw new ConfigurationStoreException("Certificate policy with id " + policyId + " does not exist");
        }
        try {
            Query delete = this.entityManager.createQuery("DELETE from CertPolicyGroupReltn cpr where cpr.certPolicy  = ?1");
            delete.setParameter(1, (Object)policy);
            delete.executeUpdate();
            this.entityManager.flush();
        }
        catch (Exception e) {
            throw new ConfigurationStoreException("Failed to remove policy id " + policyId + " from all groups", e);
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void updatePolicyAttributes(long id, String policyName, PolicyLexicon lexicon, byte[] policyData) throws ConfigurationStoreException {
        this.validateState();
        try {
            CertPolicy existingPolicy = this.getPolicyById(id);
            if (existingPolicy == null) {
                throw new ConfigurationStoreException("Policy does not exist");
            }
            if (policyData != null && policyData.length > 0) {
                existingPolicy.setPolicyData(policyData);
            }
            if (policyName != null && !policyName.isEmpty()) {
                existingPolicy.setPolicyName(policyName);
            }
            if (lexicon != null) {
                existingPolicy.setLexicon(lexicon);
            }
            this.entityManager.persist((Object)existingPolicy);
            this.entityManager.flush();
        }
        catch (ConfigurationStoreException cse) {
            throw cse;
        }
        catch (Exception e) {
            throw new ConfigurationStoreException("Failed to update certificate policy attributes.", e);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public Collection<CertPolicyGroup> getPolicyGroups() throws ConfigurationStoreException {
        this.validateState();
        try {
            Query select = this.entityManager.createQuery("SELECT cpg from CertPolicyGroup cpg");
            List rs = select.getResultList();
            if (rs.size() == 0) {
                return Collections.emptyList();
            }
            for (CertPolicyGroup group : rs) {
                group.getCertPolicyGroupReltn().size();
            }
            return rs;
        }
        catch (Exception e) {
            throw new ConfigurationStoreException("Failed to execute certificate policy group DAO query.", e);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public CertPolicyGroup getPolicyGroupByName(String policyGroupName) throws ConfigurationStoreException {
        this.validateState();
        try {
            Query select = this.entityManager.createQuery("SELECT cpg from CertPolicyGroup cpg WHERE UPPER(cpg.policyGroupName) = ?1");
            select.setParameter(1, (Object)policyGroupName.toUpperCase(Locale.getDefault()));
            CertPolicyGroup rs = (CertPolicyGroup)select.getSingleResult();
            rs.getCertPolicyGroupReltn().size();
            return rs;
        }
        catch (NoResultException e) {
            return null;
        }
        catch (Exception e) {
            throw new ConfigurationStoreException("Failed to execute certificate policy group DAO query.", e);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public CertPolicyGroup getPolicyGroupById(long id) throws ConfigurationStoreException {
        this.validateState();
        try {
            Query select = this.entityManager.createQuery("SELECT cpg from CertPolicyGroup cpg WHERE cpg.id = ?1");
            select.setParameter(1, (Object)id);
            CertPolicyGroup rs = (CertPolicyGroup)select.getSingleResult();
            rs.getCertPolicyGroupReltn().size();
            return rs;
        }
        catch (NoResultException e) {
            return null;
        }
        catch (Exception e) {
            throw new ConfigurationStoreException("Failed to execute certificate policy group DAO query.", e);
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void addPolicyGroup(CertPolicyGroup group) throws ConfigurationStoreException {
        this.validateState();
        try {
            CertPolicyGroup existingPolicyGroup = this.getPolicyGroupByName(group.getPolicyGroupName());
            if (existingPolicyGroup != null) {
                throw new ConfigurationStoreException("Certificate policy group " + group.getPolicyGroupName() + " already exists");
            }
            group.setCreateTime(Calendar.getInstance(Locale.getDefault()));
            this.entityManager.persist((Object)group);
            this.entityManager.flush();
        }
        catch (ConfigurationStoreException cse) {
            throw cse;
        }
        catch (Exception e) {
            throw new ConfigurationStoreException("Failed to add certificate policy group " + group.getPolicyGroupName(), e);
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void deletePolicyGroups(long[] groupIds) throws ConfigurationStoreException {
        this.validateState();
        if (groupIds == null || groupIds.length == 0) {
            return;
        }
        for (long id : groupIds) {
            try {
                CertPolicyGroup bundle = this.getPolicyGroupById(id);
                this.entityManager.remove((Object)bundle);
                this.entityManager.flush();
            }
            catch (ConfigurationStoreException e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void updateGroupAttributes(long id, String groupName) throws ConfigurationStoreException {
        this.validateState();
        try {
            CertPolicyGroup existingPolicyGroup = this.getPolicyGroupById(id);
            if (existingPolicyGroup == null) {
                throw new ConfigurationStoreException("Policy group does not exist");
            }
            if (groupName != null && !groupName.isEmpty()) {
                existingPolicyGroup.setPolicyGroupName(groupName);
            }
            this.entityManager.persist((Object)existingPolicyGroup);
            this.entityManager.flush();
        }
        catch (ConfigurationStoreException cse) {
            throw cse;
        }
        catch (Exception e) {
            throw new ConfigurationStoreException("Failed to update certificate policy attributes.", e);
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void addPolicyUseToGroup(long groupId, long policyId, CertPolicyUse policyUse, boolean incoming, boolean outgoing) throws ConfigurationStoreException {
        this.validateState();
        CertPolicyGroup policyGroup = this.getPolicyGroupById(groupId);
        if (policyGroup == null) {
            throw new ConfigurationStoreException("Policy group with id " + groupId + " does not exist");
        }
        CertPolicy policy = this.getPolicyById(policyId);
        if (policy == null) {
            throw new ConfigurationStoreException("Policy with id " + policyId + " does not exist");
        }
        try {
            CertPolicyGroupReltn reltn = new CertPolicyGroupReltn();
            reltn.setCertPolicy(policy);
            reltn.setCertPolicyGroup(policyGroup);
            reltn.setPolicyUse(policyUse);
            reltn.setIncoming(incoming);
            reltn.setOutgoing(outgoing);
            policyGroup.getCertPolicyGroupReltn().add(reltn);
            this.entityManager.persist((Object)policyGroup);
            this.entityManager.flush();
        }
        catch (Exception e) {
            throw new ConfigurationStoreException("Failed to add policy use to policy group.", e);
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void removePolicyUseFromGroup(long policyGroupReltnId) throws ConfigurationStoreException {
        this.validateState();
        try {
            Query select = this.entityManager.createQuery("DELETE from CertPolicyGroupReltn cpr WHERE cpr.id = ?1");
            select.setParameter(1, (Object)policyGroupReltnId);
            select.executeUpdate();
            this.entityManager.flush();
        }
        catch (NoResultException e) {
            throw new ConfigurationStoreException("Policy group reltn with id " + policyGroupReltnId + " does not exist");
        }
        catch (Exception e) {
            throw new ConfigurationStoreException("Failed to remove policy use from policy group.", e);
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void associatePolicyGroupToDomain(long domainId, long policyGroupId) throws ConfigurationStoreException {
        this.validateState();
        Domain domain = this.domainDao.getDomain(domainId);
        if (domain == null) {
            throw new ConfigurationStoreException("Domain with id " + domainId + " does not exist");
        }
        CertPolicyGroup policyGroup = this.getPolicyGroupById(policyGroupId);
        if (policyGroup == null) {
            throw new ConfigurationStoreException("Policy group with id " + policyGroup + " does not exist");
        }
        try {
            CertPolicyGroupDomainReltn policyGroupDomainAssoc = new CertPolicyGroupDomainReltn();
            policyGroupDomainAssoc.setDomain(domain);
            policyGroupDomainAssoc.setCertPolicyGroup(policyGroup);
            this.entityManager.persist((Object)policyGroupDomainAssoc);
            this.entityManager.flush();
        }
        catch (Exception e) {
            throw new ConfigurationStoreException("Failed to associate policy group to domain.", e);
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void disassociatePolicyGroupFromDomain(long domainId, long policyGroupId) throws ConfigurationStoreException {
        this.validateState();
        Domain domain = this.domainDao.getDomain(domainId);
        if (domain == null) {
            throw new ConfigurationStoreException("Domain with id " + domainId + " does not exist");
        }
        CertPolicyGroup policyGroup = this.getPolicyGroupById(policyGroupId);
        if (policyGroup == null) {
            throw new ConfigurationStoreException("Policy group with id " + policyGroup + " does not exist");
        }
        try {
            Query select = this.entityManager.createQuery("SELECT cpr from CertPolicyGroupDomainReltn cpr where cpr.domain  = ?1  and cpr.certPolicyGroup = ?2 ");
            select.setParameter(1, (Object)domain);
            select.setParameter(2, (Object)policyGroup);
            CertPolicyGroupDomainReltn reltn = (CertPolicyGroupDomainReltn)select.getSingleResult();
            this.entityManager.remove((Object)reltn);
            this.entityManager.flush();
        }
        catch (NoResultException e) {
            throw new ConfigurationStoreException("Association between domain id " + domainId + " and policy group id " + policyGroupId + " does not exist", e);
        }
        catch (Exception e) {
            throw new ConfigurationStoreException("Failed to delete policy group from domain relation.", e);
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void disassociatePolicyGroupsFromDomain(long domainId) throws ConfigurationStoreException {
        this.validateState();
        Domain domain = this.domainDao.getDomain(domainId);
        if (domain == null) {
            throw new ConfigurationStoreException("Domain with id " + domainId + " does not exist");
        }
        try {
            Query delete = this.entityManager.createQuery("DELETE from CertPolicyGroupDomainReltn cpr where cpr.domain  = ?1");
            delete.setParameter(1, (Object)domain);
            delete.executeUpdate();
            this.entityManager.flush();
        }
        catch (Exception e) {
            throw new ConfigurationStoreException("Failed to dissaccociate group policies from domain id ." + domainId, e);
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void disassociatePolicyGroupFromDomains(long policyGroupId) throws ConfigurationStoreException {
        this.validateState();
        CertPolicyGroup policyGroup = this.getPolicyGroupById(policyGroupId);
        if (policyGroup == null) {
            throw new ConfigurationStoreException("Policy group with id " + policyGroupId + " does not exist");
        }
        try {
            Query delete = this.entityManager.createQuery("DELETE from CertPolicyGroupDomainReltn cpr where cpr.certPolicyGroup  = ?1");
            delete.setParameter(1, (Object)policyGroup);
            delete.executeUpdate();
            this.entityManager.flush();
        }
        catch (Exception e) {
            throw new ConfigurationStoreException("Failed to dissaccociate domains from policy group id ." + policyGroupId, e);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public Collection<CertPolicyGroupDomainReltn> getPolicyGroupDomainReltns() throws ConfigurationStoreException {
        this.validateState();
        try {
            Query select = this.entityManager.createQuery("SELECT cpdr from CertPolicyGroupDomainReltn cpdr");
            List rs = select.getResultList();
            if (rs.size() == 0) {
                return Collections.emptyList();
            }
            for (CertPolicyGroupDomainReltn reltn : rs) {
                if (reltn.getCertPolicyGroup().getCertPolicyGroupReltn().isEmpty()) continue;
                for (CertPolicyGroupReltn groupReltn : reltn.getCertPolicyGroup().getCertPolicyGroupReltn()) {
                    groupReltn.getCertPolicy().getPolicyData();
                }
            }
            return rs;
        }
        catch (Exception e) {
            throw new ConfigurationStoreException("Failed to execute certificate policy DAO query.", e);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public Collection<CertPolicyGroupDomainReltn> getPolicyGroupsByDomain(long domainId) throws ConfigurationStoreException {
        this.validateState();
        Domain domain = this.domainDao.getDomain(domainId);
        if (domain == null) {
            throw new ConfigurationStoreException("Domain with id " + domainId + " does not exist");
        }
        List retVal = null;
        try {
            Query select = this.entityManager.createQuery("SELECT cpr from CertPolicyGroupDomainReltn cpr where cpr.domain = ?1");
            select.setParameter(1, (Object)domain);
            retVal = select.getResultList();
            if (retVal.size() == 0) {
                return Collections.emptyList();
            }
            for (CertPolicyGroupDomainReltn reltn : retVal) {
                if (reltn.getCertPolicyGroup().getCertPolicyGroupReltn().isEmpty()) continue;
                for (CertPolicyGroupReltn groupReltn : reltn.getCertPolicyGroup().getCertPolicyGroupReltn()) {
                    groupReltn.getCertPolicy().getPolicyData();
                }
            }
        }
        catch (Exception e) {
            throw new ConfigurationStoreException("Failed to execute policy group to domain relation DAO query.", e);
        }
        return retVal;
    }
}

