/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store.dao.impl;

import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.nhindirect.common.crypto.KeyStoreProtectionManager;
import org.nhindirect.config.model.exceptions.CertificateConversionException;
import org.nhindirect.config.model.utils.CertUtils;
import org.nhindirect.config.store.Certificate;
import org.nhindirect.config.store.CertificateException;
import org.nhindirect.config.store.EntityStatus;
import org.nhindirect.config.store.dao.CertificateDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class CertificateDaoImpl
implements CertificateDao {
    @PersistenceContext
    @Autowired
    private EntityManager entityManager;
    @Autowired(required=false)
    private KeyStoreProtectionManager kspMgr;
    private static final Log log;

    public void setKeyStoreProtectionManager(KeyStoreProtectionManager mgr) {
        this.kspMgr = mgr;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    @Transactional(readOnly=true)
    public Certificate load(String owner, String thumbprint) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter");
        }
        List result = null;
        Query select = null;
        if (owner == null && thumbprint == null) {
            select = this.entityManager.createQuery("SELECT c from Certificate c");
        } else if (owner != null && thumbprint == null) {
            select = this.entityManager.createQuery("SELECT c from Certificate c WHERE UPPER(c.owner) = ?1");
            select.setParameter(1, (Object)owner.toUpperCase(Locale.getDefault()));
        } else if (owner == null && thumbprint != null) {
            select = this.entityManager.createQuery("SELECT c from Certificate c WHERE c.thumbprint = ?1");
            select.setParameter(1, (Object)thumbprint);
        } else {
            select = this.entityManager.createQuery("SELECT c from Certificate c WHERE c.thumbprint = ?1 and UPPER(c.owner) = ?2");
            select.setParameter(1, (Object)thumbprint);
            select.setParameter(2, (Object)owner.toUpperCase(Locale.getDefault()));
        }
        List rs = select.getResultList();
        if (rs.size() == 0 || !(rs.get(0) instanceof Certificate)) {
            return null;
        }
        result = rs;
        for (Certificate cert : result) {
            this.stripP12Protection(cert);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit");
        }
        return (Certificate)result.iterator().next();
    }

    @Override
    @Transactional(readOnly=true)
    public List<Certificate> list(List<Long> idList) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter");
        }
        if (idList == null || idList.size() == 0) {
            return Collections.emptyList();
        }
        List result = Collections.emptyList();
        Query select = null;
        StringBuffer ids = new StringBuffer("(");
        for (Long id : idList) {
            if (ids.length() > 1) {
                ids.append(", ");
            }
            ids.append(id);
        }
        ids.append(")");
        String query = "SELECT c from Certificate c WHERE c.id IN " + ids.toString();
        select = this.entityManager.createQuery(query);
        List rs = select.getResultList();
        if (rs != null && rs.size() != 0 && rs.get(0) instanceof Certificate) {
            result = rs;
        }
        for (Certificate cert : result) {
            this.stripP12Protection(cert);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit");
        }
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public List<Certificate> list(String owner) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter");
        }
        List result = Collections.emptyList();
        Query select = null;
        if (owner == null) {
            select = this.entityManager.createQuery("SELECT c from Certificate c");
        } else if (owner != null) {
            select = this.entityManager.createQuery("SELECT c from Certificate c WHERE UPPER(c.owner) = ?1");
            select.setParameter(1, (Object)owner.toUpperCase(Locale.getDefault()));
        }
        List rs = select.getResultList();
        if (rs.size() != 0 && rs.get(0) instanceof Certificate) {
            result = rs;
        }
        for (Certificate cert : result) {
            this.stripP12Protection(cert);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit");
        }
        return result;
    }

    @Override
    @Transactional(readOnly=false)
    public void save(Certificate cert) {
        this.save(Arrays.asList(cert));
    }

    private Certificate stripP12Protection(Certificate cert) {
        log.debug((Object)("Attempting to strip p12 protection for certificate with id " + cert.getId()));
        if (cert.isPrivateKey() && this.kspMgr != null) {
            log.debug((Object)"isPrivateKey = true ");
            char[] emptyProtection = "".toCharArray();
            try {
                log.debug((Object)"Attempting to convert to a container that is wrapped");
                if (CertUtils.toCertContainer((byte[])cert.getData()) != null) {
                    return cert;
                }
            }
            catch (CertificateConversionException e) {
                log.trace((Object)"CertificateConversionException error when converting wrapped data.", (Throwable)e);
            }
            catch (Throwable t) {
                log.debug((Object)"Throwable error when converting wrapped data.", t);
            }
            log.debug((Object)"Appears to not be wrapped.  Attempting to convert by changing p12 protection.");
            try {
                String oldKeystorePassPhrase = new String(this.kspMgr.getKeyStoreProtectionKey().getEncoded());
                String oldPrivateKeyPassPhrase = new String(this.kspMgr.getKeyStoreProtectionKey().getEncoded());
                byte[] data = CertUtils.changePkcs12Protection((byte[])cert.getData(), (char[])oldKeystorePassPhrase.toCharArray(), (char[])oldPrivateKeyPassPhrase.toCharArray(), (char[])emptyProtection, (char[])emptyProtection);
                cert.setData(data);
            }
            catch (Exception e) {
                throw new RuntimeException("Error stripping P12 protection data", e);
            }
        }
        return cert;
    }

    @Override
    @Transactional(readOnly=false)
    public void save(List<Certificate> certList) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter");
        }
        if (certList != null && certList.size() > 0) {
            for (Certificate cert : certList) {
                block14: {
                    cert.setCreateTime(Calendar.getInstance());
                    try {
                        CertUtils.CertContainer container = null;
                        X509Certificate xcert = null;
                        try {
                            container = CertUtils.toCertContainer((byte[])cert.getData());
                            xcert = container.getCert();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (cert.getValidStartDate() == null && xcert != null) {
                            Calendar startDate = Calendar.getInstance();
                            startDate.setTime(xcert.getNotBefore());
                            cert.setValidStartDate(startDate);
                        }
                        if (cert.getValidEndDate() == null && xcert != null) {
                            Calendar endDate = Calendar.getInstance();
                            endDate.setTime(xcert.getNotAfter());
                            cert.setValidEndDate(endDate);
                        }
                        if (cert.getStatus() == null) {
                            cert.setStatus(EntityStatus.NEW);
                        }
                        cert.setPrivateKey(container != null && (container.getKey() != null || container.getWrappedKeyData() != null));
                        if (!cert.isPrivateKey() || this.kspMgr == null || container.getKey() == null) break block14;
                        try {
                            String newKeystorePassPhrase = new String(this.kspMgr.getKeyStoreProtectionKey().getEncoded());
                            String newPrivateKeyPassPhrase = new String(this.kspMgr.getPrivateKeyProtectionKey().getEncoded());
                            cert.setRawData(CertUtils.changePkcs12Protection((byte[])cert.getData(), (char[])"".toCharArray(), (char[])"".toCharArray(), (char[])newKeystorePassPhrase.toCharArray(), (char[])newPrivateKeyPassPhrase.toCharArray()));
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Error converting P12 to encrypted/protected format", e);
                        }
                    }
                    catch (CertificateException certificateException) {
                        // empty catch block
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Calling JPA to persist the Certificate");
                }
                this.entityManager.persist((Object)cert);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Returned from JPA: Certificate ID=" + cert.getId()));
            }
            this.entityManager.flush();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit");
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void setStatus(List<Long> certificateIDs, EntityStatus status) {
        List<Certificate> certs;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter");
        }
        if ((certs = this.list(certificateIDs)) == null || certs.size() == 0) {
            return;
        }
        for (Certificate cert : certs) {
            cert.setStatus(status);
            this.entityManager.merge((Object)cert);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit");
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void setStatus(String owner, EntityStatus status) {
        List<Certificate> certs;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter");
        }
        if ((certs = this.list(owner)) == null || certs.size() == 0) {
            return;
        }
        for (Certificate cert : certs) {
            cert.setStatus(status);
            this.entityManager.merge((Object)cert);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit");
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void delete(List<Long> idList) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter");
        }
        if (idList != null && idList.size() > 0) {
            StringBuffer ids = new StringBuffer("(");
            for (Long id : idList) {
                if (ids.length() > 1) {
                    ids.append(", ");
                }
                ids.append(id);
            }
            ids.append(")");
            String query = "DELETE FROM Certificate c WHERE c.id IN " + ids.toString();
            int count = 0;
            Query delete = this.entityManager.createQuery(query);
            count = delete.executeUpdate();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exit: " + count + " certificate records deleted"));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit");
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void delete(String owner) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter");
        }
        if (owner == null) {
            return;
        }
        int count = 0;
        if (owner != null) {
            Query delete = this.entityManager.createQuery("DELETE FROM Certificate c WHERE UPPER(c.owner) = ?1");
            delete.setParameter(1, (Object)owner.toUpperCase(Locale.getDefault()));
            count = delete.executeUpdate();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: " + count + " certificate records deleted"));
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        log = LogFactory.getLog(CertificateDaoImpl.class);
    }
}

