/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.util.Calendar;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.config.repository.CertPolicyDaoBaseTest;
import org.nhindirect.config.store.CertPolicyGroup;

public class CertPolicyGroupRepository_getPolicyGroupByNameTest
extends CertPolicyDaoBaseTest {
    @Test
    public void testGetPolicyGroupByName_emptyStore_assertNoPolicyReturned() {
        Assert.assertNull((Object)this.groupRepo.findByPolicyGroupNameIgnoreCase("Test Group"));
    }

    @Test
    public void testGetPolicyGroupByName_singlePolicyGroupInStore_nameNotInStore_assertNoPolicyGroupReturned() {
        CertPolicyGroup group = new CertPolicyGroup();
        group.setPolicyGroupName("Test Group");
        this.groupRepo.save((Object)group);
        Assert.assertNull((Object)this.groupRepo.findByPolicyGroupNameIgnoreCase("Test Group X"));
    }

    @Test
    public void testGetPolicyGroupByName_singlePolicyGroupInStore_assertPolicyGroupReturned() {
        Calendar now = Calendar.getInstance(Locale.getDefault());
        CertPolicyGroup group = new CertPolicyGroup();
        group.setPolicyGroupName("Test Group");
        this.groupRepo.save((Object)group);
        CertPolicyGroup addedGroup = this.groupRepo.findByPolicyGroupNameIgnoreCase("Test GrouP");
        Assert.assertEquals((Object)group.getPolicyGroupName(), (Object)addedGroup.getPolicyGroupName());
        Assert.assertTrue((now.getTimeInMillis() <= addedGroup.getCreateTime().getTimeInMillis() ? 1 : 0) != 0);
    }
}

