/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.config.repository.CertPolicyDaoBaseTest;
import org.nhindirect.config.store.CertPolicy;
import org.nhindirect.policy.PolicyLexicon;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class CertPolicyRepository_deletePoliciesTest
extends CertPolicyDaoBaseTest {
    @Test
    public void testDeletePolicies_singlePolicy_assertPolicyDeleted() {
        CertPolicy policy = new CertPolicy();
        policy.setPolicyName("Test Policy");
        policy.setLexicon(PolicyLexicon.XML);
        policy.setPolicyData(new byte[]{1, 2, 3});
        this.polRepo.save((Object)policy);
        List policies = this.polRepo.findAll();
        Assert.assertEquals((long)1L, (long)policies.size());
        this.polRepo.deleteById((Object)((CertPolicy)policies.iterator().next()).getId());
        policies = this.polRepo.findAll();
        Assert.assertEquals((long)0L, (long)policies.size());
    }

    @Test
    public void testDeletePolicies_multiplePolicies_assertSinglePolicyDeleted() {
        CertPolicy policy1 = new CertPolicy();
        policy1.setPolicyName("Test Policy1");
        policy1.setLexicon(PolicyLexicon.XML);
        policy1.setPolicyData(new byte[]{1, 2, 3});
        this.polRepo.save((Object)policy1);
        CertPolicy policy2 = new CertPolicy();
        policy2.setPolicyName("Test Policy2");
        policy2.setLexicon(PolicyLexicon.JAVA_SER);
        policy2.setPolicyData(new byte[]{4, 5, 6});
        this.polRepo.save((Object)policy2);
        List policies = this.polRepo.findAll();
        Assert.assertEquals((long)2L, (long)policies.size());
        this.polRepo.deleteByIdIn(Arrays.asList(((CertPolicy)policies.iterator().next()).getId()));
        policies = this.polRepo.findAll();
        Assert.assertEquals((long)1L, (long)policies.size());
    }

    @Test
    public void testDeletePolicies_multiplePolicyes_assertAllPoliciesDeleted() {
        CertPolicy policy1 = new CertPolicy();
        policy1.setPolicyName("Test Policy1");
        policy1.setLexicon(PolicyLexicon.XML);
        policy1.setPolicyData(new byte[]{1, 2, 3});
        this.polRepo.save((Object)policy1);
        CertPolicy policy2 = new CertPolicy();
        policy2.setPolicyName("Test Policy2");
        policy2.setLexicon(PolicyLexicon.JAVA_SER);
        policy2.setPolicyData(new byte[]{4, 5, 6});
        this.polRepo.save((Object)policy2);
        List policies = this.polRepo.findAll();
        Assert.assertEquals((long)2L, (long)policies.size());
        Iterator iter = policies.iterator();
        this.polRepo.deleteByIdIn(Arrays.asList(((CertPolicy)iter.next()).getId(), ((CertPolicy)iter.next()).getId()));
        policies = this.polRepo.findAll();
        Assert.assertEquals((long)0L, (long)policies.size());
    }
}

