/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.config.repository.CertPolicyDaoBaseTest;
import org.nhindirect.config.store.CertPolicy;
import org.nhindirect.policy.PolicyLexicon;

public class CertPolicyRepository_getPoliciesTest
extends CertPolicyDaoBaseTest {
    @Test
    public void testGetPolicies_emptyPolicyStore_assertNoPoliciesRetrieved() {
        List policies = this.polRepo.findAll();
        Assert.assertTrue((boolean)policies.isEmpty());
    }

    @Test
    public void testGetPolicies_singleEntryInPolicyStore_assertPoliciesRetrieved() {
        Calendar now = Calendar.getInstance(Locale.getDefault());
        CertPolicy policy = new CertPolicy();
        policy.setPolicyName("Test Policy");
        policy.setLexicon(PolicyLexicon.XML);
        policy.setPolicyData(new byte[]{1, 2, 3});
        this.polRepo.save((Object)policy);
        List policies = this.polRepo.findAll();
        Assert.assertEquals((long)1L, (long)policies.size());
        CertPolicy addedPolicy = (CertPolicy)policies.iterator().next();
        Assert.assertEquals((Object)"Test Policy", (Object)addedPolicy.getPolicyName());
        Assert.assertEquals((Object)PolicyLexicon.XML, (Object)addedPolicy.getLexicon());
        Assert.assertTrue((now.getTimeInMillis() <= addedPolicy.getCreateTime().getTimeInMillis() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{1, 2, 3}, addedPolicy.getPolicyData()));
    }

    @Test
    public void testGetPolicies_multipeEntriesInPolicyStore_assertPoliciesRetrieved() {
        Calendar now = Calendar.getInstance(Locale.getDefault());
        CertPolicy policy1 = new CertPolicy();
        policy1.setPolicyName("Test Policy1");
        policy1.setLexicon(PolicyLexicon.XML);
        policy1.setPolicyData(new byte[]{1, 2, 3});
        this.polRepo.save((Object)policy1);
        CertPolicy policy2 = new CertPolicy();
        policy2.setPolicyName("Test Policy2");
        policy2.setLexicon(PolicyLexicon.JAVA_SER);
        policy2.setPolicyData(new byte[]{4, 5, 6});
        this.polRepo.save((Object)policy2);
        List policies = this.polRepo.findAll();
        Assert.assertEquals((long)2L, (long)policies.size());
        Iterator iter = policies.iterator();
        CertPolicy addedPolicy = (CertPolicy)iter.next();
        Assert.assertEquals((Object)policy1.getPolicyName(), (Object)addedPolicy.getPolicyName());
        Assert.assertEquals((Object)policy1.getLexicon(), (Object)addedPolicy.getLexicon());
        Assert.assertTrue((now.getTimeInMillis() <= addedPolicy.getCreateTime().getTimeInMillis() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Arrays.equals(policy1.getPolicyData(), addedPolicy.getPolicyData()));
        addedPolicy = (CertPolicy)iter.next();
        Assert.assertEquals((Object)policy2.getPolicyName(), (Object)addedPolicy.getPolicyName());
        Assert.assertEquals((Object)policy2.getLexicon(), (Object)addedPolicy.getLexicon());
        Assert.assertTrue((now.getTimeInMillis() <= addedPolicy.getCreateTime().getTimeInMillis() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Arrays.equals(policy2.getPolicyData(), addedPolicy.getPolicyData()));
    }
}

