/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nhindirect.common.crypto.CryptoExtensions;
import org.nhindirect.config.SpringBaseTest;
import org.nhindirect.config.repository.CertificateRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class CertificateRepositoryTest
extends SpringBaseTest {
    private static final String certBasePath = "src/test/resources/certs/";
    @Autowired
    private CertificateRepository repo;

    @Before
    public void cleanDataBase() {
        this.repo.deleteAll();
    }

    private static byte[] loadCertificateData(String certFileName) throws Exception {
        File fl = new File(certBasePath + certFileName);
        return FileUtils.readFileToByteArray((File)fl);
    }

    public static byte[] loadPkcs12FromCertAndKey(String certFileName, String keyFileName) throws Exception {
        byte[] retVal = null;
        try {
            KeyStore localKeyStore = KeyStore.getInstance("PKCS12", CryptoExtensions.getJCEProviderName());
            localKeyStore.load(null, null);
            byte[] certData = CertificateRepositoryTest.loadCertificateData(certFileName);
            byte[] keyData = CertificateRepositoryTest.loadCertificateData(keyFileName);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream inStr = new ByteArrayInputStream(certData);
            Certificate cert = cf.generateCertificate(inStr);
            ((InputStream)inStr).close();
            KeyFactory kf = KeyFactory.getInstance("RSA");
            PKCS8EncodedKeySpec keysp = new PKCS8EncodedKeySpec(keyData);
            PrivateKey privKey = kf.generatePrivate(keysp);
            char[] array = "".toCharArray();
            localKeyStore.setKeyEntry("privCert", privKey, array, new Certificate[]{cert});
            ByteArrayOutputStream outStr = new ByteArrayOutputStream();
            localKeyStore.store(outStr, array);
            retVal = outStr.toByteArray();
            outStr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retVal;
    }

    @Test
    public void testCleanDatabase() throws Exception {
        Assert.assertEquals((long)0L, (long)this.repo.findAll().size());
    }

    @Test
    public void testAddPublicCert() throws Exception {
        byte[] certData = CertificateRepositoryTest.loadCertificateData("gm2552.der");
        org.nhindirect.config.store.Certificate cert = new org.nhindirect.config.store.Certificate();
        cert.setData(certData);
        cert.setOwner("gm2552@cerner.com");
        this.repo.save((Object)cert);
        List certificates = this.repo.findAll();
        Assert.assertEquals((long)1L, (long)certificates.size());
    }

    @Test
    public void testAddPKIXURL() throws Exception {
        this.testCleanDatabase();
        org.nhindirect.config.store.Certificate cert = new org.nhindirect.config.store.Certificate();
        cert.setData("http://localhost/test.der".getBytes());
        cert.setOwner("gm2552@cerner.com");
        this.repo.save((Object)cert);
        List certificates = this.repo.findAll();
        Assert.assertEquals((long)1L, (long)certificates.size());
        org.nhindirect.config.store.Certificate addedCert = (org.nhindirect.config.store.Certificate)certificates.iterator().next();
        Assert.assertEquals((Object)"", (Object)addedCert.getThumbprint());
        Assert.assertEquals((Object)"http://localhost/test.der", (Object)new String(addedCert.getData()));
    }

    @Test
    public void testAddPrivateCert() throws Exception {
        this.testCleanDatabase();
        byte[] certData = CertificateRepositoryTest.loadPkcs12FromCertAndKey("gm2552.der", "gm2552Key.der");
        org.nhindirect.config.store.Certificate cert = new org.nhindirect.config.store.Certificate();
        cert.setData(certData);
        cert.setOwner("gm2552@cerner.com");
        this.repo.save((Object)cert);
        List certificates = this.repo.findAll();
        Assert.assertEquals((long)1L, (long)certificates.size());
    }

    @Test
    public void testGetByOwner() throws Exception {
        this.testCleanDatabase();
        byte[] certData = CertificateRepositoryTest.loadPkcs12FromCertAndKey("gm2552.der", "gm2552Key.der");
        org.nhindirect.config.store.Certificate cert = new org.nhindirect.config.store.Certificate();
        cert.setData(certData);
        cert.setOwner("gm2552@cerner.com");
        this.repo.save((Object)cert);
        List certificates = this.repo.findByOwnerIgnoreCase("gm2552@cerner.com");
        Assert.assertEquals((long)1L, (long)certificates.size());
        cert = (org.nhindirect.config.store.Certificate)certificates.iterator().next();
        Assert.assertEquals((Object)"gm2552@cerner.com", (Object)cert.getOwner());
        this.repo.deleteAll();
        certData = CertificateRepositoryTest.loadCertificateData("gm2552.der");
        cert = new org.nhindirect.config.store.Certificate();
        cert.setData(certData);
        cert.setOwner("gm2552@cerner.com");
        this.repo.save((Object)cert);
        certificates = this.repo.findByOwnerIgnoreCase("gm2552@cerner.com");
        Assert.assertEquals((long)1L, (long)certificates.size());
        cert = (org.nhindirect.config.store.Certificate)certificates.iterator().next();
        Assert.assertEquals((Object)"gm2552@cerner.com", (Object)cert.getOwner());
    }

    @Test
    public void testGetById() throws Exception {
        this.testCleanDatabase();
        byte[] certData = CertificateRepositoryTest.loadPkcs12FromCertAndKey("gm2552.der", "gm2552Key.der");
        org.nhindirect.config.store.Certificate cert = new org.nhindirect.config.store.Certificate();
        cert.setData(certData);
        cert.setOwner("gm2552@cerner.com");
        this.repo.save((Object)cert);
        List certificates = this.repo.findByOwnerIgnoreCase("gm2552@cerner.com");
        Assert.assertEquals((long)1L, (long)certificates.size());
        cert = (org.nhindirect.config.store.Certificate)certificates.iterator().next();
        certificates = this.repo.findAllById(Arrays.asList(cert.getId()));
        Assert.assertEquals((long)1L, (long)certificates.size());
        cert = (org.nhindirect.config.store.Certificate)certificates.iterator().next();
        Assert.assertEquals((Object)"gm2552@cerner.com", (Object)cert.getOwner());
    }

    @Test
    public void testDeleteByOwner() throws Exception {
        this.testCleanDatabase();
        byte[] certData = CertificateRepositoryTest.loadPkcs12FromCertAndKey("gm2552.der", "gm2552Key.der");
        org.nhindirect.config.store.Certificate cert = new org.nhindirect.config.store.Certificate();
        cert.setData(certData);
        cert.setOwner("gm2552@cerner.com");
        this.repo.save((Object)cert);
        List certificates = this.repo.findByOwnerIgnoreCase("gm2552@cerner.COM");
        Assert.assertEquals((long)1L, (long)certificates.size());
        cert = (org.nhindirect.config.store.Certificate)certificates.iterator().next();
        Assert.assertEquals((Object)"gm2552@cerner.com", (Object)cert.getOwner());
        this.repo.deleteByOwnerIgnoreCase("gm2552@cerner.com");
        certificates = this.repo.findByOwnerIgnoreCase("gm2552@cerner.com");
        Assert.assertEquals((long)0L, (long)certificates.size());
    }

    @Test
    public void testDeleteById() throws Exception {
        this.testCleanDatabase();
        byte[] certData = CertificateRepositoryTest.loadPkcs12FromCertAndKey("gm2552.der", "gm2552Key.der");
        org.nhindirect.config.store.Certificate cert = new org.nhindirect.config.store.Certificate();
        cert.setData(certData);
        cert.setOwner("gm2552@cerner.com");
        this.repo.save((Object)cert);
        List certificates = this.repo.findByOwnerIgnoreCase("gm2552@cerner.com");
        Assert.assertEquals((long)1L, (long)certificates.size());
        cert = (org.nhindirect.config.store.Certificate)certificates.iterator().next();
        Assert.assertEquals((Object)"gm2552@cerner.com", (Object)cert.getOwner());
        this.repo.deleteById((Object)cert.getId());
        certificates = this.repo.findByOwnerIgnoreCase("gm2552@cerner.com");
        Assert.assertEquals((long)0L, (long)certificates.size());
    }

    static {
        CryptoExtensions.registerJCEProviders();
    }
}

