/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nhindirect.config.SpringBaseTest;
import org.nhindirect.config.repository.SettingRepository;
import org.nhindirect.config.store.EntityStatus;
import org.nhindirect.config.store.Setting;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;

public class SettingRepositoryTest
extends SpringBaseTest {
    @Autowired
    private SettingRepository repo;

    protected Setting newSetting(String name, String value) {
        Setting retVal = new Setting();
        retVal.setName(name);
        retVal.setValue(value);
        retVal.setStatus(EntityStatus.ENABLED);
        retVal.setUpdateTime(Calendar.getInstance());
        retVal.setUpdateTime(Calendar.getInstance());
        return retVal;
    }

    private void addSetting(String name, String value) throws Exception {
        this.repo.save((Object)this.newSetting(name, value));
    }

    @Before
    public void cleanDataBase() {
        this.repo.deleteAll();
    }

    @Test
    public void testCleanDatabase() throws Exception {
        List settings = this.repo.findAll();
        Assert.assertEquals((long)0L, (long)settings.size());
    }

    @Test
    public void addSettings() throws Exception {
        this.addSetting("TestName1", "TestValue1");
        this.addSetting("TestName2", "TestValue2");
        List settings = this.repo.findAll();
        Assert.assertEquals((long)2L, (long)settings.size());
    }

    @Test
    public void testAddDuplicateSettings_AssertException() throws Exception {
        this.addSetting("TestName1", "TestValue1");
        boolean exceptionOccured = false;
        try {
            this.addSetting("TestName1", "TestValue2");
        }
        catch (DataIntegrityViolationException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testGetAllSettings() throws Exception {
        this.addSetting("TestName1", "TestValue1");
        this.addSetting("TestName2", "TestValue2");
        List settings = this.repo.findAll();
        Assert.assertEquals((long)2L, (long)settings.size());
        this.addSetting("TestName3", "TestValue3");
        this.addSetting("TestName4", "TestValue4");
        this.addSetting("TestName5", "TestValue5");
        settings = this.repo.findAll();
        Assert.assertEquals((long)5L, (long)settings.size());
    }

    @Test
    public void testGetSettingsByName() throws Exception {
        this.addSetting("TestName1", "TestValue1");
        this.addSetting("TestName2", "TestValue2");
        List settings = this.repo.findByNameIgnoreCaseIn(Arrays.asList("TestName1".toUpperCase()));
        Assert.assertEquals((long)1L, (long)settings.size());
        Setting setting = (Setting)settings.iterator().next();
        Assert.assertEquals((Object)"TestName1", (Object)setting.getName());
        Assert.assertEquals((Object)"TestValue1", (Object)setting.getValue());
        settings = this.repo.findByNameIgnoreCaseIn(Arrays.asList("TestNAme2".toUpperCase()));
        Assert.assertEquals((long)1L, (long)settings.size());
        setting = (Setting)settings.iterator().next();
        Assert.assertEquals((Object)"TestName2", (Object)setting.getName());
        Assert.assertEquals((Object)"TestValue2", (Object)setting.getValue());
        settings = this.repo.findByNameIgnoreCaseIn(Arrays.asList("TestName1".toUpperCase(), "TestName2".toUpperCase()));
        Assert.assertEquals((long)2L, (long)settings.size());
    }

    @Test
    public void testUpdateSetting() throws Exception {
    }
}

