/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.nhindirect.common.crypto.CryptoExtensions;
import org.nhindirect.config.SpringBaseTest;
import org.nhindirect.config.repository.DomainRepository;
import org.nhindirect.config.repository.TrustBundleDomainReltnRepository;
import org.nhindirect.config.repository.TrustBundleRepository;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class TrustBundleDaoBaseTest
extends SpringBaseTest {
    @Autowired
    protected TrustBundleRepository tbRepo;
    @Autowired
    protected DomainRepository dmRepo;
    @Autowired
    protected TrustBundleDomainReltnRepository reltnRepo;
    protected static final String certBasePath = "src/test/resources/certs/";

    protected static byte[] loadCertificateData(String certFileName) throws Exception {
        File fl = new File(certBasePath + certFileName);
        return FileUtils.readFileToByteArray((File)fl);
    }

    @Before
    public void setUp() {
        this.clearRetlns();
        this.clearBundles();
        this.clearDomains();
    }

    @After
    public void tearDown() {
        this.clearRetlns();
        this.clearBundles();
        this.clearDomains();
    }

    protected void clearRetlns() {
        this.reltnRepo.deleteAll();
        Assert.assertTrue((boolean)this.reltnRepo.findAll().isEmpty());
    }

    protected void clearBundles() {
        this.tbRepo.deleteAll();
        Assert.assertTrue((boolean)this.tbRepo.findAll().isEmpty());
    }

    protected void clearDomains() {
        this.dmRepo.deleteAll();
        Assert.assertTrue((boolean)this.dmRepo.findAll().isEmpty());
    }

    static {
        CryptoExtensions.registerJCEProviders();
    }
}

