/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.common.cert.Thumbprint;
import org.nhindirect.config.repository.TrustBundleDaoBaseTest;
import org.nhindirect.config.store.TrustBundle;
import org.nhindirect.config.store.TrustBundleAnchor;

public class TrustBundleRepositry_getBundlesTest
extends TrustBundleDaoBaseTest {
    @Test
    public void testGetTrustBundles_emptyBundleStore_assertNotBundlesRetrieved() {
        List bundles = this.tbRepo.findAll();
        Assert.assertTrue((boolean)bundles.isEmpty());
    }

    @Test
    public void testGetTrustBundles_singleEntryInBundleStore_noAnchors_assertBundlesRetrieved() {
        Calendar now = Calendar.getInstance(Locale.getDefault());
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        bundle.setCreateTime(Calendar.getInstance());
        this.tbRepo.save((Object)bundle);
        List bundles = this.tbRepo.findAll();
        Assert.assertEquals((long)1L, (long)bundles.size());
        TrustBundle addedBundle = (TrustBundle)bundles.iterator().next();
        Assert.assertEquals((Object)"Test Bundle", (Object)addedBundle.getBundleName());
        Assert.assertEquals((Object)"http://testBundle/bundle.p7b", (Object)addedBundle.getBundleURL());
        Assert.assertEquals((Object)"12345", (Object)addedBundle.getCheckSum());
        Assert.assertEquals((long)5L, (long)addedBundle.getRefreshInterval());
        Assert.assertTrue((now.getTimeInMillis() <= addedBundle.getCreateTime().getTimeInMillis() ? 1 : 0) != 0);
        Assert.assertNull((Object)addedBundle.getLastRefreshAttempt());
        Assert.assertNull((Object)addedBundle.getLastSuccessfulRefresh());
        Assert.assertNull((Object)addedBundle.getLastRefreshError());
        Assert.assertNull((Object)addedBundle.getSigningCertificateData());
        Assert.assertTrue((boolean)addedBundle.getTrustBundleAnchors().isEmpty());
    }

    @Test
    public void testGetTrustBundles_singleEntryInBundleStore_signingCert_noAnchors_assertBundlesRetrieved() throws Exception {
        Calendar now = Calendar.getInstance(Locale.getDefault());
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setSigningCertificateData(TrustBundleRepositry_getBundlesTest.loadCertificateData("secureHealthEmailCACert.der"));
        bundle.setCheckSum("12345");
        bundle.setCreateTime(Calendar.getInstance());
        this.tbRepo.save((Object)bundle);
        List bundles = this.tbRepo.findAll();
        Assert.assertEquals((long)1L, (long)bundles.size());
        TrustBundle addedBundle = (TrustBundle)bundles.iterator().next();
        Assert.assertEquals((Object)"Test Bundle", (Object)addedBundle.getBundleName());
        Assert.assertEquals((Object)"http://testBundle/bundle.p7b", (Object)addedBundle.getBundleURL());
        Assert.assertEquals((Object)"12345", (Object)addedBundle.getCheckSum());
        Assert.assertEquals((Object)"12345", (Object)addedBundle.getCheckSum());
        Assert.assertEquals((long)5L, (long)addedBundle.getRefreshInterval());
        Assert.assertTrue((now.getTimeInMillis() <= addedBundle.getCreateTime().getTimeInMillis() ? 1 : 0) != 0);
        Assert.assertNull((Object)addedBundle.getLastRefreshAttempt());
        Assert.assertNull((Object)addedBundle.getLastSuccessfulRefresh());
        Assert.assertNull((Object)addedBundle.getLastRefreshError());
        Assert.assertNotNull((Object)addedBundle.getSigningCertificateData());
        Assert.assertTrue((boolean)addedBundle.getTrustBundleAnchors().isEmpty());
        Assert.assertNotNull((Object)addedBundle.toSigningCertificate());
    }

    @Test
    public void testGetTrustBundles_multipeEntriesInBundleStore_noAnchors_assertBundlesRetrieved() {
        Calendar now = Calendar.getInstance(Locale.getDefault());
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle1");
        bundle.setBundleURL("http://testBundle/bundle1.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        bundle.setCreateTime(Calendar.getInstance());
        this.tbRepo.save((Object)bundle);
        bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle2");
        bundle.setBundleURL("http://testBundle/bundle2.p7b");
        bundle.setRefreshInterval(6);
        bundle.setCheckSum("67890");
        bundle.setCreateTime(Calendar.getInstance());
        this.tbRepo.save((Object)bundle);
        List bundles = this.tbRepo.findAll();
        Assert.assertEquals((long)2L, (long)bundles.size());
        Iterator iter = bundles.iterator();
        TrustBundle addedBundle = (TrustBundle)iter.next();
        Assert.assertEquals((Object)"Test Bundle1", (Object)addedBundle.getBundleName());
        Assert.assertEquals((Object)"http://testBundle/bundle1.p7b", (Object)addedBundle.getBundleURL());
        Assert.assertEquals((Object)"12345", (Object)addedBundle.getCheckSum());
        Assert.assertEquals((long)5L, (long)addedBundle.getRefreshInterval());
        Assert.assertTrue((now.getTimeInMillis() <= addedBundle.getCreateTime().getTimeInMillis() ? 1 : 0) != 0);
        Assert.assertNull((Object)addedBundle.getLastRefreshAttempt());
        Assert.assertNull((Object)addedBundle.getLastSuccessfulRefresh());
        Assert.assertNull((Object)addedBundle.getLastRefreshError());
        Assert.assertNull((Object)addedBundle.getSigningCertificateData());
        Assert.assertTrue((boolean)addedBundle.getTrustBundleAnchors().isEmpty());
        addedBundle = (TrustBundle)iter.next();
        Assert.assertEquals((Object)"Test Bundle2", (Object)addedBundle.getBundleName());
        Assert.assertEquals((Object)"http://testBundle/bundle2.p7b", (Object)addedBundle.getBundleURL());
        Assert.assertEquals((Object)"67890", (Object)addedBundle.getCheckSum());
        Assert.assertEquals((long)6L, (long)addedBundle.getRefreshInterval());
        Assert.assertTrue((now.getTimeInMillis() <= addedBundle.getCreateTime().getTimeInMillis() ? 1 : 0) != 0);
        Assert.assertNull((Object)addedBundle.getLastRefreshAttempt());
        Assert.assertNull((Object)addedBundle.getLastSuccessfulRefresh());
        Assert.assertNull((Object)addedBundle.getLastRefreshError());
        Assert.assertNull((Object)addedBundle.getSigningCertificateData());
        Assert.assertTrue((boolean)addedBundle.getTrustBundleAnchors().isEmpty());
    }

    @Test
    public void testGetTrustBundles_singleEntryInBundleStore_singleAnchor_assertBundlesRetrieved() throws Exception {
        Calendar now = Calendar.getInstance(Locale.getDefault());
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        bundle.setCreateTime(Calendar.getInstance());
        TrustBundleAnchor anchor = new TrustBundleAnchor();
        anchor.setData(TrustBundleRepositry_getBundlesTest.loadCertificateData("secureHealthEmailCACert.der"));
        anchor.setTrustBundle(bundle);
        bundle.setTrustBundleAnchors(Arrays.asList(anchor));
        this.tbRepo.save((Object)bundle);
        List bundles = this.tbRepo.findAll();
        Assert.assertEquals((long)1L, (long)bundles.size());
        TrustBundle addedBundle = (TrustBundle)bundles.iterator().next();
        Assert.assertEquals((Object)"Test Bundle", (Object)addedBundle.getBundleName());
        Assert.assertEquals((Object)"http://testBundle/bundle.p7b", (Object)addedBundle.getBundleURL());
        Assert.assertEquals((Object)"12345", (Object)addedBundle.getCheckSum());
        Assert.assertEquals((long)5L, (long)addedBundle.getRefreshInterval());
        Assert.assertTrue((now.getTimeInMillis() <= addedBundle.getCreateTime().getTimeInMillis() ? 1 : 0) != 0);
        Assert.assertNull((Object)addedBundle.getLastRefreshAttempt());
        Assert.assertNull((Object)addedBundle.getLastSuccessfulRefresh());
        Assert.assertNull((Object)addedBundle.getLastRefreshError());
        Assert.assertNull((Object)addedBundle.getSigningCertificateData());
        Assert.assertEquals((long)1L, (long)addedBundle.getTrustBundleAnchors().size());
        TrustBundleAnchor addedAnchor = (TrustBundleAnchor)addedBundle.getTrustBundleAnchors().iterator().next();
        Assert.assertNotNull((Object)addedAnchor.toCertificate());
        Assert.assertEquals((Object)anchor.toCertificate(), (Object)addedAnchor.toCertificate());
        Assert.assertEquals((Object)Thumbprint.toThumbprint((X509Certificate)anchor.toCertificate()).toString(), (Object)addedAnchor.getThumbprint());
        Assert.assertEquals((Object)anchor.toCertificate().getNotAfter(), (Object)addedAnchor.getValidEndDate().getTime());
        Assert.assertEquals((Object)anchor.toCertificate().getNotBefore(), (Object)addedAnchor.getValidStartDate().getTime());
        Assert.assertEquals((Object)anchor.getTrustBundle().getBundleName(), (Object)bundle.getBundleName());
        Assert.assertEquals((long)anchor.getTrustBundle().getId(), (long)addedBundle.getId());
    }
}

