/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.util.Calendar;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import org.nhindirect.config.store.Domain;
import org.nhindirect.config.store.EntityStatus;

@Entity
@Table(name="address")
public class Address {
    private String emailAddress;
    private Long id;
    private Domain domain;
    private String displayName;
    private String endpoint;
    private Calendar createTime;
    private Calendar updateTime;
    private EntityStatus status;
    private String type;

    public Address() {
        this.createTime = Calendar.getInstance();
    }

    public Address(Domain aDomain, String anAddress) {
        this.setDomain(aDomain);
        this.setEmailAddress(anAddress);
        this.setDisplayName("");
        this.setCreateTime(Calendar.getInstance());
        this.setUpdateTime(Calendar.getInstance());
        this.setStatus(EntityStatus.NEW);
    }

    public Address(Domain aDomain, String anAddress, String aName) {
        this.setDomain(aDomain);
        this.setEmailAddress(anAddress);
        this.setDisplayName(aName);
        this.setCreateTime(Calendar.getInstance());
        this.setUpdateTime(Calendar.getInstance());
        this.setStatus(EntityStatus.NEW);
    }

    public Address(Address anAddress) {
        if (anAddress != null) {
            this.setDomain(anAddress.getDomain());
            this.setEmailAddress(anAddress.getEmailAddress());
            this.setDisplayName(anAddress.getDisplayName());
            this.setEndpoint(anAddress.getEndpoint());
            this.setCreateTime(anAddress.getCreateTime());
            this.setUpdateTime(anAddress.getUpdateTime());
            this.setStatus(anAddress.getStatus());
            this.setType(anAddress.getType());
        }
    }

    @Column(name="emailaddress", length=400)
    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String anEmail) {
        this.emailAddress = anEmail;
    }

    @Column(name="id", nullable=false)
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @XmlAttribute
    public Long getId() {
        if (this.id == null) {
            this.setId(new Long(0L));
        }
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @ManyToOne(optional=false, fetch=FetchType.EAGER)
    @JoinColumn(name="domainId")
    @XmlTransient
    public Domain getDomain() {
        return this.domain;
    }

    public void setDomain(Domain anId) {
        this.domain = anId;
    }

    @Column(name="displayname", length=100)
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String aName) {
        this.displayName = aName;
    }

    @Column(name="endpoint", length=255)
    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String anEndpoint) {
        this.endpoint = anEndpoint;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    public Calendar getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Calendar timestamp) {
        this.createTime = timestamp;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    public Calendar getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Calendar timestamp) {
        this.updateTime = timestamp;
    }

    @Column(name="status")
    @Enumerated
    public EntityStatus getStatus() {
        return this.status;
    }

    public void setStatus(EntityStatus aStatus) {
        this.status = aStatus;
    }

    @Column(name="type", length=64)
    public String getType() {
        return this.type;
    }

    public void setType(String aType) {
        this.type = aType;
    }

    public String toString() {
        return "[ID: " + this.getId() + " | Address: " + this.getEmailAddress() + " | For: " + this.getDisplayName() + " | Domain: " + (this.getDomain() != null ? this.getDomain().getDomainName() : "empty") + " | Endpoint: " + this.getEndpoint() + " | Status: " + (Object)((Object)this.getStatus()) + " | Type: " + this.getType() + "]";
    }

    public void afterUnmarshal(Unmarshaller u, Object parent) {
        this.setDomain((Domain)parent);
    }
}

