/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.io.ByteArrayInputStream;
import java.net.URL;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Enumeration;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.nhindirect.common.cert.Thumbprint;
import org.nhindirect.common.crypto.CryptoExtensions;
import org.nhindirect.config.model.utils.CertUtils;
import org.nhindirect.config.store.CertificateException;
import org.nhindirect.config.store.EntityStatus;

@Entity
@Table(name="certificate", indexes={@Index(columnList="thumbprint", name="IDX_RI_CERTIFICATE_THUMBPRINT", unique=false)})
public class Certificate {
    public static final byte[] NULL_CERT;
    private String owner;
    private String thumbprint;
    private long id = 0L;
    private byte[] data;
    private Calendar createTime = Calendar.getInstance();
    private Calendar validStartDate;
    private Calendar validEndDate;
    private EntityStatus status;
    private boolean privateKey;

    @Column(name="owner")
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Column(name="certificateData", length=8192)
    @Lob
    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) throws CertificateException {
        this.data = data;
        if (data == NULL_CERT) {
            this.setThumbprint("");
        } else {
            this.loadCertFromEmptyProtectedData();
        }
    }

    public void setRawData(byte[] data) {
        this.data = data;
    }

    @Column(name="privateKey")
    public boolean isPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(boolean b) throws CertificateException {
        this.privateKey = b;
    }

    private void setThumbprint(String aThumbprint) {
        this.thumbprint = aThumbprint;
    }

    @Column(name="thumbprint")
    public String getThumbprint() {
        return this.thumbprint;
    }

    @Id
    @Column(name="id", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Column(name="createTime")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Calendar getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Calendar timestamp) {
        this.createTime = timestamp;
    }

    @Column(name="status")
    @Enumerated
    public EntityStatus getStatus() {
        return this.status;
    }

    public void setStatus(EntityStatus status) {
        this.status = status;
    }

    @Column(name="validStartDate")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Calendar getValidStartDate() {
        return this.validStartDate;
    }

    public void setValidStartDate(Calendar validStartDate) {
        this.validStartDate = validStartDate;
    }

    @Column(name="validEndDate")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Calendar getValidEndDate() {
        return this.validEndDate;
    }

    public void setValidEndDate(Calendar validEndDate) {
        this.validEndDate = validEndDate;
    }

    public void validate() throws CertificateException {
        if (!this.hasData()) {
            throw new CertificateException("Invalid Certificate: no certificate data exists");
        }
    }

    private boolean hasData() {
        return this.data != null && !this.data.equals(NULL_CERT);
    }

    public void clearData() {
        try {
            this.setData(NULL_CERT);
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
    }

    private void loadCertFromEmptyProtectedData() throws CertificateException {
        this.loadCertFromData("".toCharArray(), "".toCharArray());
    }

    private void loadCertFromData(char[] keyStorePassPhrase, char[] privateKeyPassPhrase) throws CertificateException {
        block7: {
            X509Certificate cert = null;
            CertUtils.CertContainer container = null;
            try {
                this.validate();
                try {
                    container = CertUtils.toCertContainer((byte[])this.data, (char[])keyStorePassPhrase, (char[])keyStorePassPhrase);
                    cert = container.getCert();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (cert == null) {
                    try {
                        URL uRL = new URL(new String(this.data, "ASCII"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.setThumbprint("");
                    break block7;
                }
                this.setThumbprint(Thumbprint.toThumbprint(cert).toString());
                this.setPrivateKey(container != null && (container.getKey() != null || container.getWrappedKeyData() != null));
            }
            catch (Exception e) {
                this.setData(NULL_CERT);
                throw new CertificateException("Data cannot be converted to a valid X.509 Certificate or IPKIX URL", e);
            }
        }
    }

    public CertContainer toCredential() throws CertificateException {
        return this.toCredential("".toCharArray(), "".toCharArray());
    }

    public CertContainer toCredential(char[] keyStorePass, char[] privateKeyPass) throws CertificateException {
        CertContainer certContainer = null;
        try {
            this.validate();
            ByteArrayInputStream bais = new ByteArrayInputStream(this.data);
            try {
                KeyStore localKeyStore = KeyStore.getInstance("PKCS12", CryptoExtensions.getJCEProviderName());
                localKeyStore.load(bais, keyStorePass);
                Enumeration<String> aliases = localKeyStore.aliases();
                if (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    X509Certificate cert = (X509Certificate)localKeyStore.getCertificate(alias);
                    Key key = localKeyStore.getKey(alias, privateKeyPass);
                    if (key != null && key instanceof PrivateKey) {
                        certContainer = new CertContainer(cert, key);
                    }
                }
            }
            catch (Exception localKeyStore) {
                // empty catch block
            }
            if (certContainer == null) {
                bais.reset();
                bais = new ByteArrayInputStream(this.data);
                X509Certificate cert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(bais);
                certContainer = new CertContainer(cert, null);
            }
            bais.close();
        }
        catch (Exception e) {
            throw new CertificateException("Data cannot be converted to a valid X.509 Certificate", e);
        }
        return certContainer;
    }

    static {
        CryptoExtensions.registerJCEProviders();
        NULL_CERT = new byte[0];
    }

    public static class CertContainer {
        private final X509Certificate cert;
        private final Key key;

        public CertContainer(X509Certificate cert, Key key) {
            this.cert = cert;
            this.key = key;
        }

        public X509Certificate getCert() {
            return this.cert;
        }

        public Key getKey() {
            return this.key;
        }
    }
}

