/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.nhindirect.config.store.Address;
import org.nhindirect.config.store.EntityStatus;

@Entity
@Table(name="domain")
@XmlRootElement
public class Domain {
    private static long MAGIC_POSTMASTER_ID = -2L;
    private String domainName;
    private Calendar createTime;
    private Calendar updateTime;
    private Long postmasterAddressId;
    private Collection<Address> addresses;
    private Long id;
    private EntityStatus status = EntityStatus.NEW;

    public Domain() {
    }

    public Domain(String aName) {
        this.setDomainName(aName);
        this.setCreateTime(Calendar.getInstance());
        this.setUpdateTime(Calendar.getInstance());
        this.setStatus(EntityStatus.NEW);
    }

    @Column(name="id", nullable=false)
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @XmlAttribute
    public Long getId() {
        if (this.id == null) {
            this.setId(new Long(0L));
        }
        return this.id;
    }

    public void setId(Long anId) {
        this.id = anId;
    }

    @Column(name="domainName", unique=true)
    public String getDomainName() {
        return this.domainName;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    public Calendar getCreateTime() {
        return this.createTime;
    }

    @Column(name="postmasterAddressId")
    public Long getPostmasterAddressId() {
        return this.postmasterAddressId;
    }

    public void setPostmasterAddressId(Long anId) {
        this.postmasterAddressId = anId;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    public Calendar getUpdateTime() {
        return this.updateTime;
    }

    @Column(name="status")
    @Enumerated
    @XmlAttribute
    public EntityStatus getStatus() {
        return this.status;
    }

    public void setDomainName(String aName) {
        this.domainName = aName;
    }

    public void setCreateTime(Calendar timestamp) {
        this.createTime = timestamp;
    }

    public void setUpdateTime(Calendar timestamp) {
        this.updateTime = timestamp;
    }

    public void setStatus(EntityStatus aStatus) {
        this.status = aStatus;
    }

    @Transient
    public String getPostMasterEmail() {
        String result = null;
        if (this.getAddresses().size() > 0 && this.getPostmasterAddressId() != null) {
            for (Address address : this.getAddresses()) {
                if (!address.getId().equals(this.getPostmasterAddressId())) continue;
                result = address.getEmailAddress();
                break;
            }
        }
        return result;
    }

    public void setPostMasterEmail(String email) {
        if (email == null) {
            if (this.getPostmasterAddressId() != null) {
                this.setPostmasterAddressId(null);
            }
        } else {
            Long addressId = null;
            boolean matched = false;
            for (Address address : this.getAddresses()) {
                if (!address.getEmailAddress().equals(email)) continue;
                addressId = address.getId();
                matched = true;
                break;
            }
            if (!matched) {
                Address postmaster = new Address(this, email);
                postmaster.setDisplayName("Postmaster");
                postmaster.setStatus(EntityStatus.NEW);
                postmaster.setId(MAGIC_POSTMASTER_ID);
                this.getAddresses().add(postmaster);
                addressId = postmaster.getId();
            }
            this.setPostmasterAddressId(addressId);
        }
    }

    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.EAGER, mappedBy="domain")
    @XmlElement(name="address")
    public Collection<Address> getAddresses() {
        if (this.addresses == null) {
            this.addresses = new ArrayList<Address>();
        }
        return this.addresses;
    }

    public void setAddresses(Collection<Address> addresses) {
        this.addresses = addresses;
    }

    @Transient
    public boolean isValid() {
        boolean result = false;
        if (this.getDomainName() != null && this.getDomainName().length() > 0 && (this.getStatus().equals((Object)EntityStatus.ENABLED) || this.getStatus().equals((Object)EntityStatus.DISABLED) || this.getStatus().equals((Object)EntityStatus.NEW) && this.getId() == 0L)) {
            result = true;
        }
        return result;
    }

    public String toString() {
        return "[ID: " + this.getId() + " | Domain: " + this.getDomainName() + " | Status: " + this.getStatus().toString() + " | Addresses: " + this.getAddresses().size() + "]";
    }

    public boolean equals(Object other) {
        boolean result = false;
        if (other == null) {
            return false;
        }
        if (other instanceof Domain) {
            Domain otherDomain = (Domain)other;
            if (otherDomain.id == this.id && otherDomain.domainName.equals(this.domainName) && otherDomain.postmasterAddressId == this.postmasterAddressId && otherDomain.status.equals((Object)this.status)) {
                if (otherDomain.addresses == null && this.addresses == null) {
                    result = true;
                } else if (otherDomain.addresses != null && this.addresses != null) {
                    result = otherDomain.addresses.size() == this.addresses.size();
                }
            }
        }
        return result;
    }
}

